/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.maildir;

import gnu.mail.providers.maildir.MaildirFolder;
import gnu.mail.treeutil.StatusEvent;
import gnu.mail.treeutil.StatusListener;
import gnu.mail.treeutil.StatusSource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.jpackage.mail.inet.util.TraceLevel;

public final class MaildirStore
extends Store
implements StatusSource {
    static final Logger logger = Logger.getLogger("gnu.mail.util.providers.maildir");
    static final Level MAILDIR_TRACE = new TraceLevel("maildir");
    private static final char separatorChar = '/';
    private List statusListeners = new ArrayList();

    public MaildirStore(Session session, URLName urlname) {
        super(session, urlname);
        if (session.getDebug()) {
            logger.setLevel(MAILDIR_TRACE);
        }
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        return true;
    }

    public Folder getDefaultFolder() throws MessagingException {
        String file;
        if (this.url != null && (file = this.url.getFile()) != null && file.length() > 0) {
            return this.getFolder(file);
        }
        String home = this.session.getProperty("mail.maildir.home");
        if (home == null) {
            try {
                home = System.getProperty("user.home");
                if (!this.exists(home)) {
                    home = null;
                }
            }
            catch (SecurityException e) {
                this.log("access denied reading system properties");
            }
        }
        home = this.toFilename(home);
        return new MaildirFolder(this, home, true, false);
    }

    public Folder getFolder(String filename) throws MessagingException {
        boolean inbox = false;
        if ("inbox".equalsIgnoreCase(filename)) {
            String maildir = this.session.getProperty("mail.maildir.maildir");
            if (!this.isMaildir(maildir)) {
                try {
                    String userhome = System.getProperty("user.home");
                    maildir = userhome + "/Maildir";
                    if (!this.isMaildir(maildir)) {
                        maildir = null;
                    }
                }
                catch (SecurityException e) {
                    this.log("unable to access system properties");
                }
            }
            if (maildir != null) {
                filename = maildir;
                inbox = true;
            }
        }
        filename = this.toFilename(filename);
        return new MaildirFolder(this, filename, false, inbox);
    }

    String toFilename(String filename) {
        StringBuffer buf = new StringBuffer();
        if (filename.length() < 1 || filename.charAt(0) != '/') {
            buf.append(File.separator);
        }
        if ('/' != File.separatorChar) {
            buf.append(filename.replace('/', File.separatorChar));
        } else {
            buf.append(filename);
        }
        return buf.toString();
    }

    private boolean exists(String filename) {
        if (filename != null) {
            File file = new File(filename);
            if ('/' != File.separatorChar) {
                file = new File(filename.replace('/', File.separatorChar));
            }
            return file.exists();
        }
        return false;
    }

    private boolean isMaildir(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if ('/' != File.separatorChar) {
            file = new File(path.replace('/', File.separatorChar));
        }
        return file.exists() && file.isDirectory();
    }

    public Folder getFolder(URLName urlname) throws MessagingException {
        return this.getFolder(urlname.getFile());
    }

    Session getSession() {
        return this.session;
    }

    void log(String message) {
        logger.log(MAILDIR_TRACE, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener l) {
        List list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener l) {
        List list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStatusEvent(StatusEvent event) {
        StatusListener[] listeners;
        List list = this.statusListeners;
        synchronized (list) {
            listeners = new StatusListener[this.statusListeners.size()];
            this.statusListeners.toArray(listeners);
        }
        switch (event.getType()) {
            case 0: {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].statusOperationStarted(event);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].statusProgressUpdate(event);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].statusOperationEnded(event);
                }
                break;
            }
        }
    }
}

