/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.mbox;

import gnu.mail.providers.ReadOnlyMessage;
import gnu.mail.providers.mbox.MboxFolder;
import java.io.InputStream;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class MboxMessage
extends ReadOnlyMessage {
    protected static final String STATUS = "Status";
    protected String fromLine;

    protected MboxMessage(MboxFolder folder, String fromLine, InputStream in, int msgnum) throws MessagingException {
        super(folder, in, msgnum);
        this.fromLine = fromLine;
        this.readStatusHeader();
    }

    protected MboxMessage(MboxFolder folder, MimeMessage message, int msgnum) throws MessagingException {
        super(message);
        this.folder = folder;
        this.msgnum = msgnum;
        this.readStatusHeader();
    }

    protected void setExpunged(boolean expunged) {
        super.setExpunged(expunged);
    }

    public synchronized void setFlags(Flags flag, boolean set) throws MessagingException {
        if (set) {
            this.flags.add(flag);
        } else {
            this.flags.remove(flag);
        }
    }

    protected void updateHeaders() throws MessagingException {
        String status;
        super.updateHeaders();
        String old = this.getHeader(STATUS, "\n");
        StringBuffer buffer = new StringBuffer();
        boolean seen = this.flags.contains(Flags.Flag.SEEN);
        boolean recent = this.flags.contains(Flags.Flag.RECENT);
        boolean answered = this.flags.contains(Flags.Flag.ANSWERED);
        boolean deleted = this.flags.contains(Flags.Flag.DELETED);
        if (seen) {
            buffer.append('R');
        }
        if (!recent) {
            buffer.append('O');
        }
        if (answered) {
            buffer.append('A');
        }
        if (deleted) {
            buffer.append('D');
        }
        if (!(status = buffer.toString()).equals(old)) {
            this.setHeader(STATUS, status);
        }
    }

    private void readStatusHeader() throws MessagingException {
        String[] currentStatus = this.getHeader(STATUS);
        if (currentStatus != null && currentStatus.length > 0) {
            this.flags = new Flags();
            if (currentStatus[0].indexOf(82) >= 0) {
                this.flags.add(Flags.Flag.SEEN);
            }
            if (currentStatus[0].indexOf(79) < 0) {
                this.flags.add(Flags.Flag.RECENT);
            }
            if (currentStatus[0].indexOf(65) >= 0) {
                this.flags.add(Flags.Flag.ANSWERED);
            }
            if (currentStatus[0].indexOf(68) >= 0) {
                this.flags.add(Flags.Flag.DELETED);
            }
        }
    }

    public boolean equals(Object other) {
        if (other instanceof MimeMessage) {
            MimeMessage message = (MimeMessage)other;
            return message.getFolder() == this.getFolder() && message.getMessageNumber() == this.getMessageNumber();
        }
        return false;
    }
}

