/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.nntp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.NewsAddress;
import org.jpackage.mail.inet.nntp.NNTPConnection;

public class NNTPTransport
extends Transport {
    NNTPConnection connection;

    public NNTPTransport(Session session, URLName url) {
        super(session, url);
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        if (this.connection != null) {
            return true;
        }
        if (host == null) {
            host = this.getProperty("host");
        }
        if (username == null) {
            username = this.getProperty("user");
        }
        if (port < 0) {
            port = this.getIntProperty("port");
        }
        if (host == null) {
            return false;
        }
        try {
            int connectionTimeout = this.getIntProperty("connectiontimeout");
            int timeout = this.getIntProperty("timeout");
            if (port < 0) {
                port = 119;
            }
            if (this.session.getDebug()) {
                NNTPConnection.logger.setLevel(NNTPConnection.NNTP_TRACE);
            }
            this.connection = new NNTPConnection(host, port, connectionTimeout, timeout);
            if (username != null && password != null) {
                return this.connection.authinfo(username, password);
            }
            return true;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        catch (SecurityException e) {
            if (username != null && password != null) {
                throw new AuthenticationFailedException(e.getMessage());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        block5: {
            try {
                NNTPConnection nNTPConnection = this.connection;
                synchronized (nNTPConnection) {
                    this.connection.quit();
                }
            }
            catch (IOException e) {
                if (e instanceof SocketException) break block5;
                throw new MessagingException(e.getMessage(), e);
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message, Address[] addresses) throws MessagingException {
        boolean ok;
        addresses = message.getRecipients(MimeMessage.RecipientType.NEWSGROUPS);
        boolean bl = ok = addresses.length > 0;
        if (!ok) {
            throw new MessagingException("No recipients specified");
        }
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] instanceof NewsAddress) continue;
            ok = false;
            break;
        }
        if (!ok) {
            throw new MessagingException("Newsgroup recipients must be specified as type NewsAddress");
        }
        try {
            NNTPConnection i = this.connection;
            synchronized (i) {
                OutputStream out = this.connection.post();
                message.writeTo(out);
                out.close();
            }
            this.notifyTransportListeners(1, addresses, new NewsAddress[0], new NewsAddress[0], message);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    private int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean propertyIsFalse(String key) {
        return "false".equals(this.getProperty(key));
    }

    private boolean propertyIsTrue(String key) {
        return "true".equals(this.getProperty(key));
    }

    private String getProperty(String key) {
        String value = this.session.getProperty("mail.nntp." + key);
        if (value == null) {
            value = this.session.getProperty("mail." + key);
        }
        return value;
    }
}

