/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.pop3;

import gnu.mail.providers.pop3.POP3Folder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.net.ssl.TrustManager;
import org.jpackage.mail.inet.pop3.POP3Connection;

public final class POP3Store
extends Store {
    POP3Connection connection;
    POP3Folder root;
    boolean disableApop;

    public POP3Store(Session session, URLName urlname) {
        super(session, urlname);
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        if (this.connection != null) {
            return true;
        }
        if (host == null) {
            host = this.getProperty("host");
        }
        if (username == null) {
            username = this.getProperty("user");
        }
        if (port < 0 && (port = this.getIntProperty("port")) < 0) {
            port = 110;
        }
        if (host == null || username == null || password == null) {
            return false;
        }
        this.disableApop = false;
        POP3Store pOP3Store = this;
        synchronized (pOP3Store) {
            try {
                List capa;
                int connectionTimeout = this.getIntProperty("connectiontimeout");
                int timeout = this.getIntProperty("timeout");
                if (this.session.getDebug()) {
                    POP3Connection.logger.setLevel(POP3Connection.POP3_TRACE);
                }
                boolean tls = "pop3s".equals(this.url.getProtocol());
                TrustManager tm = this.getTrustManager();
                this.connection = new POP3Connection(host, port, connectionTimeout, timeout, tls, tm);
                if (this.propertyIsFalse("apop")) {
                    this.disableApop = true;
                }
                if ((capa = this.connection.capa()) != null) {
                    if (capa.contains("STLS") && !tls && !this.propertyIsFalse("tls") && (tls = tm == null ? this.connection.stls() : this.connection.stls(tm))) {
                        capa = this.connection.capa();
                    }
                    if (!tls && "required".equals(this.getProperty("tls"))) {
                        throw new MessagingException("TLS not available");
                    }
                    ArrayList<String> authenticationMechanisms = null;
                    Iterator i = capa.iterator();
                    while (i.hasNext()) {
                        String cap = (String)i.next();
                        if (!cap.startsWith("SASL ")) continue;
                        if (authenticationMechanisms == null) {
                            authenticationMechanisms = new ArrayList<String>();
                        }
                        authenticationMechanisms.add(cap.substring(5));
                    }
                    if (authenticationMechanisms != null && !authenticationMechanisms.isEmpty()) {
                        if (username == null || password == null) {
                            PasswordAuthentication pa = this.session.getPasswordAuthentication(this.url);
                            if (pa == null) {
                                InetAddress addr = InetAddress.getByName(host);
                                pa = this.session.requestPasswordAuthentication(addr, port, "pop3", null, null);
                            }
                            if (pa != null) {
                                username = pa.getUserName();
                                password = pa.getPassword();
                            }
                        }
                        if (username != null && password != null) {
                            String authPrefs = this.getProperty("auth.mechanisms");
                            Iterator i2 = null;
                            if (authPrefs == null) {
                                i2 = authenticationMechanisms.iterator();
                            } else {
                                StringTokenizer st = new StringTokenizer(authPrefs, ",");
                                ArrayList<Object> authPrefList = Collections.list(st);
                                i2 = authPrefList.iterator();
                            }
                            while (i2.hasNext()) {
                                String mechanism = (String)i2.next();
                                if (!authenticationMechanisms.contains(mechanism) || !this.connection.auth(mechanism, username, password)) continue;
                                return true;
                            }
                        }
                    }
                }
                if (!this.disableApop) {
                    return this.connection.apop(username, password);
                }
                return this.connection.login(username, password);
            }
            catch (UnknownHostException e) {
                throw new MessagingException("Connect failed", e);
            }
            catch (IOException e) {
                throw new MessagingException("Connect failed", e);
            }
        }
    }

    protected TrustManager getTrustManager() throws MessagingException {
        String tmt = this.getProperty("trustmanager");
        if (tmt == null) {
            return null;
        }
        try {
            Class<?> t = Class.forName(tmt);
            TrustManager tm = (TrustManager)t.newInstance();
            try {
                Class[] pt = new Class[]{Session.class};
                Method m = t.getMethod("setSession", pt);
                Object[] args = new Object[]{this.session};
                m.invoke((Object)tm, args);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return tm;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        if (this.connection != null) {
            POP3Connection pOP3Connection = this.connection;
            synchronized (pOP3Connection) {
                try {
                    if (this.propertyIsTrue("rsetbeforequit")) {
                        this.connection.rset();
                    }
                    this.connection.quit();
                }
                catch (IOException e) {
                    throw new MessagingException("Close failed", e);
                }
            }
            this.connection = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder getDefaultFolder() throws MessagingException {
        POP3Store pOP3Store = this;
        synchronized (pOP3Store) {
            if (this.root == null) {
                this.root = new POP3Folder(this, 2);
            }
        }
        return this.root;
    }

    public Folder getFolder(String s) throws MessagingException {
        return this.getDefaultFolder().getFolder(s);
    }

    public Folder getFolder(URLName urlname) throws MessagingException {
        return this.getDefaultFolder().getFolder(urlname.getFile());
    }

    private int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean propertyIsFalse(String key) {
        return "false".equals(this.getProperty(key));
    }

    private boolean propertyIsTrue(String key) {
        return "true".equals(this.getProperty(key));
    }

    private String getProperty(String key) {
        String value = this.session.getProperty("mail.pop3." + key);
        if (value == null) {
            value = this.session.getProperty("mail." + key);
        }
        return value;
    }
}

