/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpackage.mail.inet.util.LineInputStream;

public class UUInputStream
extends FilterInputStream {
    boolean body;
    ByteArrayOutputStream pending = new ByteArrayOutputStream();

    public UUInputStream(InputStream in) {
        super(new LineInputStream(in));
    }

    public int read() throws IOException {
        int len;
        byte[] buf = new byte[1];
        while ((len = this.read(buf, 0, 1)) == 0) {
        }
        return len == -1 ? len : buf[0];
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int plen = this.pending.size();
        if (plen == 0) {
            int i;
            String line;
            LineInputStream lin = (LineInputStream)this.in;
            if (!this.body) {
                line = lin.readLine();
                if (line == null || !line.startsWith("begin ")) {
                    throw new IOException("No `begin' line");
                }
                this.body = true;
            }
            while ("".equals(line = lin.readLine())) {
            }
            if (line == null) {
                throw new EOFException();
            }
            byte[] src = line.getBytes("US-ASCII");
            int n = UUInputStream.decode(src[i = 0]);
            if (n <= 0) {
                this.body = false;
                line = lin.readLine();
                if (line == null || !line.equals("end")) {
                    throw new IOException("No `end' line");
                }
                return -1;
            }
            ++i;
            while (n > 0) {
                int c;
                if (n >= 1) {
                    c = UUInputStream.decode(src[i]) << 2 | UUInputStream.decode(src[i + 1]) >> 4;
                    this.pending.write(c);
                }
                if (n >= 2) {
                    c = UUInputStream.decode(src[i + 1]) << 4 | UUInputStream.decode(src[i + 2]) >> 2;
                    this.pending.write(c);
                }
                if (n >= 3) {
                    c = UUInputStream.decode(src[i + 2]) << 6 | UUInputStream.decode(src[i + 3]);
                    this.pending.write(c);
                }
                i += 4;
                n -= 3;
            }
        }
        byte[] pbuf = this.pending.toByteArray();
        plen = pbuf.length;
        this.pending.reset();
        if (plen > len) {
            System.arraycopy(pbuf, 0, buf, 0, len);
            byte[] tmp = new byte[plen - len];
            System.arraycopy(pbuf, len, tmp, 0, tmp.length);
            this.pending.write(tmp);
            return len;
        }
        System.arraycopy(pbuf, 0, buf, 0, plen);
        return plen;
    }

    static int decode(byte c) {
        int c2 = c;
        if (c2 < 0) {
            c2 += 256;
        }
        return c2 - 32 & 0x3F;
    }
}

