/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.PrintStream;
import java.io.PrintWriter;

public class MessagingException
extends Exception {
    private Exception nextException;

    public MessagingException() {
        this(null, null);
    }

    public MessagingException(String message) {
        this(message, null);
    }

    public MessagingException(String message, Exception exception) {
        super(message);
        this.nextException = exception;
    }

    public Exception getNextException() {
        return this.nextException;
    }

    public synchronized boolean setNextException(Exception exception) {
        Exception o = this;
        while (o instanceof MessagingException && o.nextException != null) {
            o = o.nextException;
        }
        if (o instanceof MessagingException) {
            o.nextException = exception;
            return true;
        }
        return false;
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.nextException != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(message);
            buffer.append(";\n  nested exception is: \n\t");
            buffer.append(this.nextException.toString());
            message = buffer.toString();
        }
        return message;
    }

    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.nextException != null) {
            out.println("nested exception is:");
            this.nextException.printStackTrace(out);
        }
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.nextException != null) {
            out.println("nested exception is:");
            this.nextException.printStackTrace(out);
        }
    }
}

