/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

public class Provider {
    private Type type;
    private String protocol;
    private String className;
    private String vendor;
    private String version;

    Provider(Type type, String protocol, String className, String vendor, String version) {
        this.type = type;
        this.protocol = protocol;
        this.className = className;
        this.vendor = vendor;
        this.version = version;
    }

    public Type getType() {
        return this.type;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getClassName() {
        return this.className;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("javax.mail.Provider[");
        if (this.type == Type.STORE) {
            buffer.append("STORE,");
        } else if (this.type == Type.TRANSPORT) {
            buffer.append("TRANSPORT,");
        }
        buffer.append(this.protocol);
        buffer.append(',');
        buffer.append(this.className);
        if (this.vendor != null) {
            buffer.append(',');
            buffer.append(this.vendor);
        }
        if (this.version != null) {
            buffer.append(',');
            buffer.append(this.version);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static class Type {
        public static final Type STORE = new Type("Store");
        public static final Type TRANSPORT = new Type("Transport");
        private String type;

        private Type(String type) {
            this.type = type;
        }
    }
}

