/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;

public final class Session {
    private static final String SYSTEM_PROVIDERS = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javamail.providers";
    private static final String CUSTOM_PROVIDERS = "META-INF/javamail.providers";
    private static final String DEFAULT_PROVIDERS = "META-INF/javamail.default.providers";
    private static final String SYSTEM_ADDRESS_MAP = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javamail.address.map";
    private static final String CUSTOM_ADDRESS_MAP = "META-INF/javamail.address.map";
    private static final String DEFAULT_ADDRESS_MAP = "META-INF/javamail.default.address.map";
    private Properties props;
    private Authenticator authenticator;
    private HashMap authTable = new HashMap();
    private boolean debug;
    private ArrayList providers = new ArrayList();
    private HashMap providersByProtocol = new HashMap();
    private HashMap providersByClassName = new HashMap();
    private Properties addressMap = new Properties();
    private static Session defaultSession = null;
    private Logger logger = Logger.getLogger(Session.class.getName());

    private Session(Properties props, Authenticator authenticator) {
        File file;
        this.props = props;
        this.authenticator = authenticator;
        this.debug = new Boolean(props.getProperty("mail.debug"));
        this.logger.setLevel(this.debug ? Level.FINER : Level.SEVERE);
        this.logger.info("using GNU JavaMail 1.3");
        ClassLoader loader = null;
        loader = authenticator == null ? this.getClass().getClassLoader() : authenticator.getClass().getClassLoader();
        this.loadProviders(this.getResourceAsStream(loader, DEFAULT_PROVIDERS), "default");
        this.loadProviders(this.getResourceAsStream(loader, CUSTOM_PROVIDERS), "custom");
        try {
            file = new File(SYSTEM_PROVIDERS);
            BufferedInputStream pin = new BufferedInputStream(new FileInputStream(file));
            this.loadProviders(pin, "system");
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.WARNING, "no system providers", e);
        }
        this.logger.log(Level.FINE, "Providers by class name: " + this.providersByClassName.toString());
        this.logger.log(Level.FINE, "Providers by protocol: " + this.providersByProtocol.toString());
        this.loadAddressMap(this.getResourceAsStream(loader, DEFAULT_ADDRESS_MAP), "default");
        this.loadAddressMap(this.getResourceAsStream(loader, CUSTOM_ADDRESS_MAP), "custom");
        try {
            file = new File(SYSTEM_ADDRESS_MAP);
            BufferedInputStream min = new BufferedInputStream(new FileInputStream(file));
            this.loadAddressMap(min, "system");
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.WARNING, "no system address map", e);
        }
    }

    private InputStream getResourceAsStream(ClassLoader loader, String resource) {
        InputStream in = null;
        try {
            in = loader == null ? loader.getResourceAsStream(resource) : this.getClass().getResourceAsStream(resource);
            if (in == null && resource.charAt(0) != '/') {
                in = this.getResourceAsStream(loader, "/" + resource);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return in;
    }

    private void loadProviders(InputStream in, String description) {
        if (in == null) {
            this.logger.info("no " + description + " providers");
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#") && line.length() > 0) {
                    Provider.Type type = null;
                    String protocol = null;
                    String className = null;
                    String vendor = null;
                    String version = null;
                    StringTokenizer st = new StringTokenizer(line, ";");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        int equalsIndex = token.indexOf("=");
                        if (token.startsWith("protocol=")) {
                            protocol = token.substring(equalsIndex + 1);
                            continue;
                        }
                        if (token.startsWith("type=")) {
                            String transportValue = token.substring(equalsIndex + 1);
                            if (transportValue.equalsIgnoreCase("store")) {
                                type = Provider.Type.STORE;
                                continue;
                            }
                            if (!transportValue.equalsIgnoreCase("transport")) continue;
                            type = Provider.Type.TRANSPORT;
                            continue;
                        }
                        if (token.startsWith("class=")) {
                            className = token.substring(equalsIndex + 1);
                            continue;
                        }
                        if (token.startsWith("vendor=")) {
                            vendor = token.substring(equalsIndex + 1);
                            continue;
                        }
                        if (!token.startsWith("version=")) continue;
                        version = token.substring(equalsIndex + 1);
                    }
                    if (type == null || protocol == null || className == null) {
                        this.logger.warning("Invalid provider: " + line);
                    } else {
                        Provider provider = new Provider(type, protocol, className, vendor, version);
                        this.providers.add(provider);
                        this.providersByClassName.put(className, provider);
                        if (!this.providersByProtocol.containsKey(protocol)) {
                            this.providersByProtocol.put(protocol, provider);
                        }
                    }
                }
                line = reader.readLine();
            }
            in.close();
            this.logger.info("loaded " + description + " providers");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (SecurityException e) {
            this.logger.log(Level.WARNING, "can't load " + description + " providers", e);
        }
    }

    private void loadAddressMap(InputStream in, String description) {
        if (in == null) {
            this.logger.info("no " + description + " address map");
            return;
        }
        try {
            this.addressMap.load(in);
            in.close();
            this.logger.info("loaded " + description + " address map");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (SecurityException e) {
            this.logger.log(Level.WARNING, "can't load " + description + " address map", e);
        }
    }

    public static Session getInstance(Properties props, Authenticator authenticator) {
        return new Session(props, authenticator);
    }

    public static Session getInstance(Properties props) {
        return Session.getInstance(props, null);
    }

    public static Session getDefaultInstance(Properties props, Authenticator authenticator) {
        if (defaultSession == null) {
            defaultSession = new Session(props, authenticator);
        } else if (Session.defaultSession.authenticator != authenticator && (Session.defaultSession.authenticator == null || authenticator == null || Session.defaultSession.authenticator.getClass().getClassLoader() != authenticator.getClass().getClassLoader())) {
            throw new SecurityException("Access denied");
        }
        return defaultSession;
    }

    public static Session getDefaultInstance(Properties props) {
        return Session.getDefaultInstance(props, null);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public Provider[] getProviders() {
        Provider[] p = new Provider[this.providers.size()];
        this.providers.toArray(p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider getProvider(String protocol) throws NoSuchProviderException {
        if (protocol == null || protocol.length() <= 0) {
            throw new NoSuchProviderException("Invalid protocol: " + protocol);
        }
        Provider provider = null;
        String providerClassKey = "mail." + protocol + ".class";
        String providerClassName = this.props.getProperty(providerClassKey);
        ArrayList arrayList = this.providers;
        synchronized (arrayList) {
            if (providerClassName != null) {
                provider = (Provider)this.providersByClassName.get(providerClassName);
            }
            if (provider == null) {
                provider = (Provider)this.providersByProtocol.get(protocol);
            }
        }
        if (provider == null) {
            throw new NoSuchProviderException("No provider for " + protocol);
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProvider(Provider provider) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("Can't set null provider");
        }
        ArrayList arrayList = this.providers;
        synchronized (arrayList) {
            String protocol = provider.getProtocol();
            this.providersByProtocol.put(protocol, provider);
            String providerClassKey = "mail." + protocol + ".class";
            this.props.put(providerClassKey, provider.getClassName());
        }
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this.getProperty("mail.store.protocol"));
    }

    public Store getStore(String protocol) throws NoSuchProviderException {
        return this.getStore(new URLName(protocol, null, -1, null, null, null));
    }

    public Store getStore(URLName url) throws NoSuchProviderException {
        String protocol = url.getProtocol();
        Provider provider = this.getProvider(protocol);
        return this.getStore(provider, url);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        return this.getStore(provider, null);
    }

    private Store getStore(Provider provider, URLName url) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.STORE) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Store)this.getService(provider, url);
        }
        catch (ClassCastException e) {
            throw new NoSuchProviderException("not a store");
        }
    }

    public Transport getTransport() throws NoSuchProviderException {
        return this.getTransport(this.getProperty("mail.transport.protocol"));
    }

    public Transport getTransport(String protocol) throws NoSuchProviderException {
        return this.getTransport(new URLName(protocol, null, -1, null, null, null));
    }

    public Transport getTransport(URLName url) throws NoSuchProviderException {
        String protocol = url.getProtocol();
        Provider provider = this.getProvider(protocol);
        return this.getTransport(provider, url);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return this.getTransport(provider, null);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String provider = (String)this.addressMap.get(address.getType());
        if (provider == null) {
            throw new NoSuchProviderException("No provider for address: " + address.getType());
        }
        return this.getTransport(provider);
    }

    private Transport getTransport(Provider provider, URLName urlname) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.TRANSPORT) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Transport)this.getService(provider, urlname);
        }
        catch (ClassCastException _ex) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    public Folder getFolder(URLName url) throws MessagingException {
        Store store = this.getStore(url);
        store.connect();
        return store.getFolder(url);
    }

    private Object getService(Provider provider, URLName url) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("null");
        }
        if (url == null) {
            url = new URLName(provider.getProtocol(), null, -1, null, null, null);
        }
        Class<?> providerClass = null;
        ClassLoader loader = this.authenticator != null ? this.authenticator.getClass().getClassLoader() : this.getClass().getClassLoader();
        try {
            providerClass = loader.loadClass(provider.getClassName());
        }
        catch (Exception e) {
            try {
                providerClass = Class.forName(provider.getClassName());
            }
            catch (Exception e2) {
                if (this.debug) {
                    e2.printStackTrace();
                }
                throw new NoSuchProviderException(provider.getProtocol());
            }
        }
        try {
            Class[] parameterTypes = new Class[]{Session.class, URLName.class};
            Constructor<?> constructor = providerClass.getConstructor(parameterTypes);
            Object[] parameters = new Object[]{this, url};
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new NoSuchProviderException(provider.getProtocol());
        }
    }

    public void setPasswordAuthentication(URLName url, PasswordAuthentication pw) {
        if (pw == null) {
            this.authTable.remove(url);
        } else {
            this.authTable.put(url, pw);
        }
    }

    public PasswordAuthentication getPasswordAuthentication(URLName url) {
        return (PasswordAuthentication)this.authTable.get(url);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress address, int port, String protocol, String prompt, String defaultUserName) {
        if (this.authenticator != null) {
            return this.authenticator.requestPasswordAuthentication(address, port, protocol, prompt, defaultUserName);
        }
        return null;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public void setDebugOut(PrintStream out) {
        if (out == null) {
            out = System.err;
        }
    }

    public PrintStream getDebugOut() {
        return null;
    }
}

