/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MailDateFormat
extends SimpleDateFormat {
    private static final String[] DAYS_OF_WEEK = new String[]{null, "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public MailDateFormat() {
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.numberFormat = new DecimalFormat();
    }

    public StringBuffer format(Date date, StringBuffer buf, FieldPosition field) {
        this.calendar.clear();
        this.calendar.setTime(date);
        buf.setLength(0);
        buf.append(DAYS_OF_WEEK[this.calendar.get(7)]);
        buf.append(',');
        buf.append(' ');
        buf.append(Integer.toString(this.calendar.get(5)));
        buf.append(' ');
        buf.append(MONTHS[this.calendar.get(2)]);
        buf.append(' ');
        int year = this.calendar.get(1);
        if (year < 1000) {
            buf.append('0');
            if (year < 100) {
                buf.append('0');
                if (year < 10) {
                    buf.append('0');
                }
            }
        }
        buf.append(Integer.toString(year));
        buf.append(' ');
        int hour = this.calendar.get(11);
        buf.append(Character.forDigit(hour / 10, 10));
        buf.append(Character.forDigit(hour % 10, 10));
        buf.append(':');
        int minute = this.calendar.get(12);
        buf.append(Character.forDigit(minute / 10, 10));
        buf.append(Character.forDigit(minute % 10, 10));
        buf.append(':');
        int second = this.calendar.get(13);
        buf.append(Character.forDigit(second / 10, 10));
        buf.append(Character.forDigit(second % 10, 10));
        buf.append(' ');
        int zoneOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        if (zoneOffset < 0) {
            zoneOffset = -zoneOffset;
            buf.append('-');
        } else {
            buf.append('+');
        }
        int tzhours = zoneOffset / 60;
        buf.append(Character.forDigit(tzhours / 10, 10));
        buf.append(Character.forDigit(tzhours % 10, 10));
        int tzminutes = zoneOffset % 60;
        buf.append(Character.forDigit(tzminutes / 10, 10));
        buf.append(Character.forDigit(tzminutes % 10, 10));
        field.setBeginIndex(0);
        field.setEndIndex(buf.length());
        return buf;
    }

    public Date parse(String text, ParsePosition pos) {
        int start = 0;
        int end = -1;
        int len = text.length();
        this.calendar.clear();
        pos.setIndex(start);
        try {
            if (Character.isLetter(text.charAt(start))) {
                start = this.skipNonWhitespace(text, start, len);
            }
            start = this.skipWhitespace(text, start, len);
            pos.setIndex(start);
            end = this.skipNonWhitespace(text, start + 1, len);
            int date = Integer.parseInt(text.substring(start, end));
            start = this.skipWhitespace(text, end + 1, len);
            pos.setIndex(start);
            end = this.skipNonWhitespace(text, start + 1, len);
            String monthText = text.substring(start, end);
            int month = -1;
            for (int i = 0; i < 12; ++i) {
                if (!MONTHS[i].equals(monthText)) continue;
                month = i;
                break;
            }
            if (month == -1) {
                pos.setErrorIndex(end);
                return null;
            }
            start = this.skipWhitespace(text, end + 1, len);
            pos.setIndex(start);
            end = this.skipNonWhitespace(text, start + 1, len);
            int year = Integer.parseInt(text.substring(start, end));
            this.calendar.set(1, year);
            this.calendar.set(2, month);
            this.calendar.set(5, date);
            start = this.skipWhitespace(text, end + 1, len);
            pos.setIndex(start);
            end = this.skipToColon(text, start + 1, len);
            int hour = Integer.parseInt(text.substring(start, end));
            this.calendar.set(10, hour);
            start = end + 1;
            pos.setIndex(start);
            end = this.skipToColon(text, start + 1, len);
            int minute = Integer.parseInt(text.substring(start, end));
            this.calendar.set(12, minute);
            start = end + 1;
            pos.setIndex(start);
            end = this.skipNonWhitespace(text, start + 1, len);
            int second = Integer.parseInt(text.substring(start, end));
            this.calendar.set(13, second);
            if (end != len && (start = this.skipWhitespace(text, end + 1, len)) != len) {
                end = this.skipNonWhitespace(text, start + 1, len);
                char pm = text.charAt(start);
                if (Character.isLetter(pm)) {
                    TimeZone tz = TimeZone.getTimeZone(text.substring(start, end));
                    this.calendar.set(15, tz.getRawOffset());
                } else {
                    int zoneOffset = 0;
                    zoneOffset += 600 * Character.digit(text.charAt(++start), 10);
                    zoneOffset += 60 * Character.digit(text.charAt(++start), 10);
                    zoneOffset += 10 * Character.digit(text.charAt(++start), 10);
                    zoneOffset += Character.digit(text.charAt(++start), 10);
                    zoneOffset *= 60000;
                    if ('-' == pm) {
                        zoneOffset = -zoneOffset;
                    }
                    this.calendar.set(15, zoneOffset);
                }
            }
            pos.setIndex(end);
            return this.calendar.getTime();
        }
        catch (NumberFormatException e) {
            pos.setErrorIndex(Math.max(start, end));
        }
        catch (StringIndexOutOfBoundsException e) {
            pos.setErrorIndex(Math.max(start, end));
        }
        return null;
    }

    private int skipWhitespace(String text, int pos, int len) {
        while (pos < len && Character.isWhitespace(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private int skipNonWhitespace(String text, int pos, int len) {
        while (pos < len && !Character.isWhitespace(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private int skipToColon(String text, int pos, int len) {
        while (pos < len && text.charAt(pos) != ':') {
            ++pos;
        }
        return pos;
    }

    public void setCalendar(Calendar newCalendar) {
        throw new UnsupportedOperationException();
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        throw new UnsupportedOperationException();
    }
}

