/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class MimePartDataSource
implements DataSource,
MessageAware {
    private MimePart part;
    private MessageContext context;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream is;
            if (this.part instanceof MimeBodyPart) {
                is = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                is = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part type");
            }
            String encoding = this.part.getEncoding();
            return encoding != null ? MimeUtility.decode(is, encoding) : is;
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String getName() {
        return "";
    }

    public MessageContext getMessageContext() {
        if (this.context == null) {
            this.context = new MessageContext(this.part);
        }
        return this.context;
    }
}

