/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class FlagTerm
extends SearchTerm {
    protected boolean set;
    protected Flags flags;

    public FlagTerm(Flags flags, boolean set) {
        this.flags = flags;
        this.set = set;
    }

    public Flags getFlags() {
        return (Flags)this.flags.clone();
    }

    public boolean getTestSet() {
        return this.set;
    }

    public boolean match(Message msg) {
        try {
            Flags messageFlags = msg.getFlags();
            if (this.set) {
                return messageFlags.contains(this.flags);
            }
            Flags.Flag[] systemFlags = this.flags.getSystemFlags();
            for (int i = 0; i < systemFlags.length; ++i) {
                if (!messageFlags.contains(systemFlags[i])) continue;
                return false;
            }
            String[] userFlags = this.flags.getUserFlags();
            for (int i = 0; i < userFlags.length; ++i) {
                if (!messageFlags.contains(userFlags[i])) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof FlagTerm) {
            FlagTerm ft = (FlagTerm)other;
            return ft.set == this.set && ft.flags.equals(this.flags);
        }
        return false;
    }

    public int hashCode() {
        return this.set ? this.flags.hashCode() : ~this.flags.hashCode();
    }
}

