/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import org.jpackage.mail.inet.ftp.DTP;
import org.jpackage.mail.inet.ftp.DTPInputStream;

class CompressedInputStream
extends DTPInputStream {
    static final int EOF = 64;
    static final int RAW = 0;
    static final int COMPRESSED = 128;
    static final int FILLER = 192;
    int descriptor;
    int max = -1;
    int count = -1;
    int state = 0;
    int rep;
    int n = 0;

    CompressedInputStream(DTP dtp, InputStream in) {
        super(dtp, in);
    }

    public int read() throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        if (this.n > 0 && (this.state == 128 || this.state == 192)) {
            --this.n;
            return this.rep;
        }
        int c = this.in.read();
        if (c == -1) {
            this.close();
        }
        ++this.count;
        if (this.count >= this.max) {
            this.count = -1;
            if (this.descriptor == 64) {
                this.close();
            }
        }
        if (c == -1) {
            return c;
        }
        while (this.n == 0) {
            this.state = c & 0xC0;
            this.n = c & 0x3F;
            c = this.in.read();
            if (c != -1) continue;
            return -1;
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 128: 
            case 192: {
                this.rep = c;
                break;
            }
            default: {
                throw new ProtocolException("Illegal state: " + this.state);
            }
        }
        --this.n;
        return c;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        for (int i = off; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                this.close();
                return i;
            }
            buf[i] = (byte)c;
        }
        return len;
    }

    void readHeader() throws IOException {
        this.descriptor = this.in.read();
        int max_hi = this.in.read();
        int max_lo = this.in.read();
        this.max = max_hi << 8 | max_lo;
        this.count = 0;
    }

    void readCodeHeader() throws IOException {
        int code = this.in.read();
        this.state = code & 0xC0;
        this.n = code & 0x3F;
    }
}

