/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.gopher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import org.jpackage.mail.inet.gopher.GopherConnection;
import org.jpackage.mail.inet.gopher.GopherContentHandler;

public class GopherURLConnection
extends URLConnection {
    protected GopherConnection connection;

    public GopherURLConnection(URL url) {
        super(url);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String host = this.url.getHost();
        int port = this.url.getPort();
        this.connection = new GopherConnection(host, port);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        String dir = this.url.getPath();
        String filename = this.url.getFile();
        if (dir == null && filename == null) {
            throw new UnsupportedOperationException("not implemented");
        }
        String selector = dir == null ? filename : dir + '/' + filename;
        return this.connection.get(selector);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public Object getContent() throws IOException {
        return new GopherContentHandler().getContent(this);
    }

    public Object getContent(Class[] classes) throws IOException {
        return new GopherContentHandler().getContent(this, classes);
    }
}

