/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.imap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jpackage.mail.inet.imap.IMAPConstants;
import org.jpackage.mail.inet.imap.IMAPException;
import org.jpackage.mail.inet.imap.IMAPResponse;
import org.jpackage.mail.inet.imap.IMAPResponseTokenizer;
import org.jpackage.mail.inet.imap.ListEntry;
import org.jpackage.mail.inet.imap.MailboxStatus;
import org.jpackage.mail.inet.imap.MessageStatus;
import org.jpackage.mail.inet.imap.Namespaces;
import org.jpackage.mail.inet.imap.Quota;
import org.jpackage.mail.inet.imap.UTF7imap;
import org.jpackage.mail.inet.util.BASE64;
import org.jpackage.mail.inet.util.CRLFOutputStream;
import org.jpackage.mail.inet.util.EmptyX509TrustManager;
import org.jpackage.mail.inet.util.SaslCallbackHandler;
import org.jpackage.mail.inet.util.SaslCramMD5;
import org.jpackage.mail.inet.util.SaslInputStream;
import org.jpackage.mail.inet.util.SaslLogin;
import org.jpackage.mail.inet.util.SaslOutputStream;
import org.jpackage.mail.inet.util.SaslPlain;
import org.jpackage.mail.inet.util.TraceLevel;

public class IMAPConnection
implements IMAPConstants {
    public static final Logger logger = Logger.getLogger("org.jpackage.mail.inet.imap");
    public static final Level IMAP_TRACE = new TraceLevel("imap");
    protected static final String TAG_PREFIX = "A";
    protected static final String US_ASCII = "US-ASCII";
    protected static final int DEFAULT_PORT = 143;
    protected static final int DEFAULT_SSL_PORT = 993;
    protected Socket socket;
    protected IMAPResponseTokenizer in;
    protected CRLFOutputStream out;
    protected List asyncResponses;
    private List alerts;
    private int tagIndex = 0;
    private boolean ansiDebug = false;

    public IMAPConnection(String host) throws UnknownHostException, IOException {
        this(host, -1, 0, 0, false, null);
    }

    public IMAPConnection(String host, int port) throws UnknownHostException, IOException {
        this(host, port, 0, 0, false, null);
    }

    public IMAPConnection(String host, int port, int connectionTimeout, int timeout) throws UnknownHostException, IOException {
        this(host, port, connectionTimeout, timeout, false, null);
    }

    public IMAPConnection(String host, int port, TrustManager tm) throws UnknownHostException, IOException {
        this(host, port, 0, 0, true, tm);
    }

    public IMAPConnection(String host, int port, int connectionTimeout, int timeout, boolean secure, TrustManager tm) throws UnknownHostException, IOException {
        if (port < 0) {
            port = secure ? 993 : 143;
        }
        try {
            this.socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(host, port);
            if (connectionTimeout > 0) {
                this.socket.connect(address, connectionTimeout);
            } else {
                this.socket.connect(address);
            }
            if (timeout > 0) {
                this.socket.setSoTimeout(timeout);
            }
            if (secure) {
                SSLSocketFactory factory = this.getSSLSocketFactory(tm);
                SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, host, port, true);
                String[] protocols = new String[]{"TLSv1", "SSLv3"};
                ss.setEnabledProtocols(protocols);
                ss.setUseClientMode(true);
                ss.startHandshake();
                this.socket = ss;
            }
        }
        catch (GeneralSecurityException e) {
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
        InputStream in = this.socket.getInputStream();
        in = new BufferedInputStream(in);
        this.in = new IMAPResponseTokenizer(in);
        OutputStream out = this.socket.getOutputStream();
        out = new BufferedOutputStream(out);
        this.out = new CRLFOutputStream(out);
        this.asyncResponses = new ArrayList();
        this.alerts = new ArrayList();
    }

    public void setAnsiDebug(boolean flag) {
        this.ansiDebug = flag;
    }

    protected String newTag() {
        return TAG_PREFIX + ++this.tagIndex;
    }

    protected void sendCommand(String tag, String command) throws IOException {
        logger.log(IMAP_TRACE, "> " + tag + " " + command);
        this.out.write(tag + ' ' + command);
        this.out.writeln();
        this.out.flush();
    }

    protected boolean invokeSimpleCommand(String command) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        this.sendCommand(tag, command);
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return true;
                }
                if (id == "NO") {
                    return false;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    protected IMAPResponse readResponse() throws IOException {
        IMAPResponse response = this.in.next();
        if (response == null) {
            logger.log(IMAP_TRACE, "<EOF");
            throw new EOFException();
        }
        if (this.ansiDebug) {
            logger.log(IMAP_TRACE, "< " + response.toANSIString());
        } else {
            logger.log(IMAP_TRACE, "< " + response.toString());
        }
        return response;
    }

    private void processAlerts(IMAPResponse response) {
        List code = response.getResponseCode();
        if (code != null && code.contains("ALERT")) {
            this.alerts.add(response.getText());
        }
    }

    public boolean alertsPending() {
        return this.alerts.size() > 0;
    }

    public String[] getAlerts() {
        String[] a = new String[this.alerts.size()];
        this.alerts.toArray(a);
        this.alerts.clear();
        return a;
    }

    public List capability() throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        this.sendCommand(tag, "CAPABILITY");
        ArrayList<String> capabilities = new ArrayList<String>();
        block0: while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    if (capabilities.size() == 0) {
                        this.addTokens(capabilities, response.getText());
                    }
                    return capabilities;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if (id == "CAPABILITY") {
                this.addTokens(capabilities, response.getText());
                continue;
            }
            if (id == "OK") {
                int len;
                List code = response.getResponseCode();
                int n = len = code == null ? 0 : code.size();
                if (len > 0 && "CAPABILITY".equals(code.get(0))) {
                    int i = 1;
                    while (true) {
                        if (i >= len) continue block0;
                        String token = (String)code.get(i);
                        if (!capabilities.contains(token)) {
                            capabilities.add(token);
                        }
                        ++i;
                    }
                }
                this.asyncResponses.add(response);
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    private void addTokens(List list, String text) {
        String token;
        int start = 0;
        int end = text.indexOf(32);
        while (end != -1) {
            token = text.substring(start, end);
            if (!list.contains(token)) {
                list.add(token);
            }
            start = end + 1;
            end = text.indexOf(32, start);
        }
        token = text.substring(start);
        if (token.length() > 0 && !list.contains(token)) {
            list.add(token);
        }
    }

    public MailboxStatus noop() throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        this.sendCommand(tag, "NOOP");
        boolean changed = false;
        MailboxStatus ms = new MailboxStatus();
        Iterator asyncIterator = this.asyncResponses.iterator();
        while (true) {
            if (asyncIterator.hasNext()) {
                response = (IMAPResponse)asyncIterator.next();
                asyncIterator.remove();
            } else {
                response = this.readResponse();
            }
            id = response.getID();
            if (!response.isUntagged()) break;
            changed = changed || this.updateMailboxStatus(ms, id, response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                return changed ? ms : null;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    protected SSLSocketFactory getSSLSocketFactory(TrustManager tm) throws GeneralSecurityException {
        if (tm == null) {
            tm = new EmptyX509TrustManager();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trust = new TrustManager[]{tm};
        context.init(null, trust, null);
        return context.getSocketFactory();
    }

    public boolean starttls() throws IOException {
        return this.starttls(new EmptyX509TrustManager());
    }

    public boolean starttls(TrustManager tm) throws IOException {
        try {
            SSLSocketFactory factory = this.getSSLSocketFactory(tm);
            String hostname = this.socket.getInetAddress().getHostName();
            int port = this.socket.getPort();
            String tag = this.newTag();
            this.sendCommand(tag, "STARTTLS");
            while (true) {
                IMAPResponse response;
                if ((response = this.readResponse()).isTagged() && tag.equals(response.getTag())) {
                    this.processAlerts(response);
                    String id = response.getID();
                    if (id == "OK") break;
                    if (id != "BAD") continue;
                    return false;
                }
                this.asyncResponses.add(response);
            }
            SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, hostname, port, true);
            String[] protocols = new String[]{"TLSv1", "SSLv3"};
            ss.setEnabledProtocols(protocols);
            ss.setUseClientMode(true);
            ss.startHandshake();
            InputStream in = ss.getInputStream();
            in = new BufferedInputStream(in);
            this.in = new IMAPResponseTokenizer(in);
            OutputStream out = ss.getOutputStream();
            out = new BufferedOutputStream(out);
            this.out = new CRLFOutputStream(out);
            return true;
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean login(String username, String password) throws IOException {
        return this.invokeSimpleCommand("LOGIN " + IMAPConnection.quote(username) + ' ' + IMAPConnection.quote(password));
    }

    public boolean authenticate(String mechanism, String username, String password) throws IOException {
        try {
            String[] m = new String[]{mechanism};
            SaslCallbackHandler ch = new SaslCallbackHandler(username, password);
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("gnu.crypto.sasl.username", username);
            p.put("gnu.crypto.sasl.password", password);
            SaslClient sasl = Sasl.createSaslClient(m, null, "imap", this.socket.getInetAddress().getHostName(), p, ch);
            if (sasl == null) {
                if ("LOGIN".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslLogin(username, password);
                } else if ("PLAIN".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslPlain(username, password);
                } else if ("CRAM-MD5".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslCramMD5(username, password);
                } else {
                    logger.log(IMAP_TRACE, mechanism + " not available");
                    return false;
                }
            }
            StringBuffer cmd = new StringBuffer("AUTHENTICATE");
            cmd.append(' ');
            cmd.append(mechanism);
            String tag = this.newTag();
            this.sendCommand(tag, cmd.toString());
            while (true) {
                IMAPResponse response;
                if (tag.equals((response = this.readResponse()).getTag())) {
                    this.processAlerts(response);
                    String id = response.getID();
                    if (id == "OK") {
                        String qop = (String)sasl.getNegotiatedProperty("javax.security.sasl.qop");
                        if ("auth-int".equalsIgnoreCase(qop) || "auth-conf".equalsIgnoreCase(qop)) {
                            InputStream in = this.socket.getInputStream();
                            in = new BufferedInputStream(in);
                            in = new SaslInputStream(sasl, in);
                            this.in = new IMAPResponseTokenizer(in);
                            OutputStream out = this.socket.getOutputStream();
                            out = new BufferedOutputStream(out);
                            out = new SaslOutputStream(sasl, out);
                            this.out = new CRLFOutputStream(out);
                        }
                        return true;
                    }
                    if (id == "NO") {
                        return false;
                    }
                    if (id != "BAD") continue;
                    throw new IMAPException(id, response.getText());
                }
                if (response.isContinuation()) {
                    try {
                        byte[] c0 = response.getText().getBytes(US_ASCII);
                        byte[] c1 = BASE64.decode(c0);
                        byte[] r0 = sasl.evaluateChallenge(c1);
                        byte[] r1 = BASE64.encode(r0);
                        this.out.write(r1);
                        this.out.writeln();
                        this.out.flush();
                        logger.log(IMAP_TRACE, "> " + new String(r1, US_ASCII));
                    }
                    catch (SaslException e) {
                        this.out.write(42);
                        this.out.writeln();
                        this.out.flush();
                        logger.log(IMAP_TRACE, "> *");
                    }
                    continue;
                }
                this.asyncResponses.add(response);
            }
        }
        catch (SaslException e) {
            logger.log(IMAP_TRACE, e.getMessage(), e);
            return false;
        }
        catch (RuntimeException e) {
            logger.log(IMAP_TRACE, e.getMessage(), e);
            return false;
        }
    }

    public void logout() throws IOException {
        String tag = this.newTag();
        this.sendCommand(tag, "LOGOUT");
        while (true) {
            IMAPResponse response;
            if ((response = this.readResponse()).isTagged() && tag.equals(response.getTag())) {
                this.processAlerts(response);
                String id = response.getID();
                if (id == "OK") {
                    this.socket.close();
                    return;
                }
                throw new IMAPException(id, response.getText());
            }
            this.asyncResponses.add(response);
        }
    }

    public MailboxStatus select(String mailbox) throws IOException {
        return this.selectImpl(mailbox, "SELECT");
    }

    public MailboxStatus examine(String mailbox) throws IOException {
        return this.selectImpl(mailbox, "EXAMINE");
    }

    protected MailboxStatus selectImpl(String mailbox, String command) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        this.sendCommand(tag, command + ' ' + IMAPConnection.quote(UTF7imap.encode(mailbox)));
        MailboxStatus ms = new MailboxStatus();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (!response.isUntagged()) break;
            if (this.updateMailboxStatus(ms, id, response)) continue;
            this.asyncResponses.add(response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                List rc = response.getResponseCode();
                if (rc != null && rc.size() > 0 && rc.get(0) == "READ-WRITE") {
                    ms.readWrite = true;
                }
                return ms;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    protected boolean updateMailboxStatus(MailboxStatus ms, String id, IMAPResponse response) throws IOException {
        if (id == "OK") {
            boolean changed = false;
            List rc = response.getResponseCode();
            int len = rc == null ? 0 : rc.size();
            for (int i = 0; i < len; ++i) {
                Object ocmd = rc.get(i);
                if (!(ocmd instanceof String)) continue;
                String cmd = (String)ocmd;
                if (i + 1 >= len) continue;
                Object oparam = rc.get(i + 1);
                if (oparam instanceof String) {
                    String param = (String)oparam;
                    try {
                        if (cmd == "UNSEEN") {
                            ms.firstUnreadMessage = Integer.parseInt(param);
                            ++i;
                            changed = true;
                            continue;
                        }
                        if (cmd != "UIDVALIDITY") continue;
                        ms.uidValidity = Integer.parseInt(param);
                        ++i;
                        changed = true;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ProtocolException("Illegal " + cmd + " value: " + param);
                    }
                }
                if (!(oparam instanceof List) || cmd != "PERMANENTFLAGS") continue;
                ms.permanentFlags = (List)oparam;
                ++i;
                changed = true;
            }
            return changed;
        }
        if (id == "EXISTS") {
            ms.messageCount = response.getCount();
            return true;
        }
        if (id == "RECENT") {
            ms.newMessageCount = response.getCount();
            return true;
        }
        if (id == "FLAGS") {
            ms.flags = response.getResponseCode();
            return true;
        }
        return false;
    }

    public boolean create(String mailbox) throws IOException {
        return this.invokeSimpleCommand("CREATE " + IMAPConnection.quote(UTF7imap.encode(mailbox)));
    }

    public boolean delete(String mailbox) throws IOException {
        return this.invokeSimpleCommand("DELETE " + IMAPConnection.quote(UTF7imap.encode(mailbox)));
    }

    public boolean rename(String source, String target) throws IOException {
        return this.invokeSimpleCommand("RENAME " + IMAPConnection.quote(UTF7imap.encode(source)) + ' ' + IMAPConnection.quote(UTF7imap.encode(target)));
    }

    public boolean subscribe(String mailbox) throws IOException {
        return this.invokeSimpleCommand("SUBSCRIBE " + IMAPConnection.quote(UTF7imap.encode(mailbox)));
    }

    public boolean unsubscribe(String mailbox) throws IOException {
        return this.invokeSimpleCommand("UNSUBSCRIBE " + IMAPConnection.quote(UTF7imap.encode(mailbox)));
    }

    public ListEntry[] list(String reference, String mailbox) throws IOException {
        return this.listImpl("LIST", reference, mailbox);
    }

    public ListEntry[] lsub(String reference, String mailbox) throws IOException {
        return this.listImpl("LSUB", reference, mailbox);
    }

    protected ListEntry[] listImpl(String command, String reference, String mailbox) throws IOException {
        String id;
        IMAPResponse response;
        if (reference == null) {
            reference = "";
        }
        if (mailbox == null) {
            mailbox = "";
        }
        String tag = this.newTag();
        this.sendCommand(tag, command + ' ' + IMAPConnection.quote(UTF7imap.encode(reference)) + ' ' + IMAPConnection.quote(UTF7imap.encode(mailbox)));
        ArrayList<ListEntry> acc = new ArrayList<ListEntry>();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (!response.isUntagged()) break;
            if (id.equals(command)) {
                List code = response.getResponseCode();
                String text = response.getText();
                int alen = code == null ? 0 : code.size();
                boolean noinferiors = false;
                boolean noselect = false;
                boolean marked = false;
                boolean unmarked = false;
                for (int i = 0; i < alen; ++i) {
                    String attribute = (String)code.get(i);
                    if (attribute.equalsIgnoreCase("\\Noinferiors")) {
                        noinferiors = true;
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("\\Noselect")) {
                        noselect = true;
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("\\Marked")) {
                        marked = true;
                        continue;
                    }
                    if (!attribute.equalsIgnoreCase("\\Unmarked")) continue;
                    unmarked = true;
                }
                int si = text.indexOf(32);
                char delimiter = '\u0000';
                String d = text.substring(0, si);
                if (!d.equalsIgnoreCase("NIL")) {
                    delimiter = IMAPConnection.stripQuotes(d).charAt(0);
                }
                String mbox = IMAPConnection.stripQuotes(text.substring(si + 1));
                mbox = UTF7imap.decode(mbox);
                ListEntry entry = new ListEntry(mbox, delimiter, noinferiors, noselect, marked, unmarked);
                acc.add(entry);
                continue;
            }
            this.asyncResponses.add(response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                ListEntry[] entries = new ListEntry[acc.size()];
                acc.toArray(entries);
                return entries;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    public MailboxStatus status(String mailbox, String[] statusNames) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        StringBuffer buffer = new StringBuffer("STATUS").append(' ').append(IMAPConnection.quote(UTF7imap.encode(mailbox))).append(' ').append('(');
        for (int i = 0; i < statusNames.length; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(statusNames[i]);
        }
        buffer.append(')');
        this.sendCommand(tag, buffer.toString());
        MailboxStatus ms = new MailboxStatus();
        block3: while (true) {
            response = this.readResponse();
            id = response.getID();
            if (!response.isUntagged()) break;
            if (id == "STATUS") {
                List code = response.getResponseCode();
                int last = code == null ? 0 : code.size() - 1;
                int i = 0;
                while (true) {
                    if (i >= last) continue block3;
                    try {
                        String statusName = ((String)code.get(i)).intern();
                        int value = Integer.parseInt((String)code.get(i + 1));
                        if (statusName == "MESSAGES") {
                            ms.messageCount = value;
                        } else if (statusName == "RECENT") {
                            ms.newMessageCount = value;
                        } else if (statusName == "UIDNEXT") {
                            ms.uidNext = value;
                        } else if (statusName == "UIDVALIDITY") {
                            ms.uidValidity = value;
                        } else if (statusName == "UNSEEN") {
                            ms.firstUnreadMessage = value;
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IMAPException(id, "Invalid code: " + code);
                    }
                    i += 2;
                }
            }
            this.asyncResponses.add(response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                return ms;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    public boolean append(String mailbox, String[] flags, byte[] content) throws IOException {
        String id;
        String tag = this.newTag();
        StringBuffer buffer = new StringBuffer("APPEND").append(' ').append(IMAPConnection.quote(UTF7imap.encode(mailbox))).append(' ');
        if (flags != null) {
            buffer.append('(');
            for (int i = 0; i < flags.length; ++i) {
                if (i > 0) {
                    buffer.append(' ');
                }
                buffer.append(flags[i]);
            }
            buffer.append(')');
            buffer.append(' ');
        }
        buffer.append('{');
        buffer.append(content.length);
        buffer.append('}');
        this.sendCommand(tag, buffer.toString());
        IMAPResponse response = this.readResponse();
        if (!response.isContinuation()) {
            throw new IMAPException(response.getID(), response.getText());
        }
        this.out.write(content);
        this.out.writeln();
        this.out.flush();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return true;
                }
                if (id == "NO") {
                    return false;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    public void check() throws IOException {
        this.invokeSimpleCommand("CHECK");
    }

    public boolean close() throws IOException {
        return this.invokeSimpleCommand("CLOSE");
    }

    public int[] expunge() throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        this.sendCommand(tag, "EXPUNGE");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (!response.isUntagged()) break;
            if (id == "EXPUNGE") {
                numbers.add(new Integer(response.getCount()));
                continue;
            }
            this.asyncResponses.add(response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                int len = numbers.size();
                int[] mn = new int[len];
                for (int i = 0; i < len; ++i) {
                    mn[i] = (Integer)numbers.get(i);
                }
                return mn;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    public int[] search(String charset, String[] criteria) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        StringBuffer buffer = new StringBuffer("SEARCH");
        buffer.append(' ');
        if (charset != null) {
            buffer.append(charset);
            buffer.append(' ');
        }
        for (int i = 0; i < criteria.length; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(criteria[i]);
        }
        this.sendCommand(tag, buffer.toString());
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (!response.isUntagged()) break;
            if (id == "SEARCH") {
                String text = response.getText();
                if (text == null) continue;
                try {
                    int si = text.indexOf(32);
                    while (si != -1) {
                        list.add(new Integer(text.substring(0, si)));
                        text = text.substring(si + 1);
                        si = text.indexOf(32);
                    }
                    list.add(new Integer(text));
                }
                catch (NumberFormatException e) {
                    throw new IMAPException(id, "Expecting number: " + text);
                }
            }
            this.asyncResponses.add(response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                int len = list.size();
                int[] mn = new int[len];
                for (int i = 0; i < len; ++i) {
                    mn[i] = (Integer)list.get(i);
                }
                return mn;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    public MessageStatus fetch(int message, String[] fetchCommands) throws IOException {
        String ids = message == -1 ? "*" : Integer.toString(message);
        return this.fetchImpl("FETCH", ids, fetchCommands)[0];
    }

    public MessageStatus[] fetch(int start, int end, String[] fetchCommands) throws IOException {
        StringBuffer ids = new StringBuffer();
        ids.append(start == -1 ? 42 : start);
        ids.append(':');
        ids.append(end == -1 ? 42 : end);
        return this.fetchImpl("FETCH", ids.toString(), fetchCommands);
    }

    public MessageStatus[] fetch(int[] messages, String[] fetchCommands) throws IOException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < messages.length; ++i) {
            if (i > 0) {
                ids.append(',');
            }
            ids.append(messages[i]);
        }
        return this.fetchImpl("FETCH", ids.toString(), fetchCommands);
    }

    public MessageStatus uidFetch(long uid, String[] fetchCommands) throws IOException {
        String ids = uid == -1L ? "*" : Long.toString(uid);
        return this.fetchImpl("UID FETCH", ids, fetchCommands)[0];
    }

    public MessageStatus[] uidFetch(long start, long end, String[] fetchCommands) throws IOException {
        StringBuffer ids = new StringBuffer();
        ids.append(start == -1L ? 42L : start);
        ids.append(':');
        ids.append(end == -1L ? 42L : end);
        return this.fetchImpl("UID FETCH", ids.toString(), fetchCommands);
    }

    public MessageStatus[] uidFetch(long[] uids, String[] fetchCommands) throws IOException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < uids.length; ++i) {
            if (i > 0) {
                ids.append(',');
            }
            ids.append(uids[i]);
        }
        return this.fetchImpl("UID FETCH", ids.toString(), fetchCommands);
    }

    private MessageStatus[] fetchImpl(String cmd, String ids, String[] fetchCommands) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        StringBuffer buffer = new StringBuffer(cmd);
        buffer.append(' ');
        buffer.append(ids);
        buffer.append(' ');
        buffer.append('(');
        for (int i = 0; i < fetchCommands.length; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(fetchCommands[i]);
        }
        buffer.append(')');
        this.sendCommand(tag, buffer.toString());
        ArrayList<MessageStatus> list = new ArrayList<MessageStatus>();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (!response.isUntagged()) break;
            if (id == "FETCH") {
                int msgnum = response.getCount();
                List code = response.getResponseCode();
                MessageStatus status = new MessageStatus(msgnum, code);
                list.add(status);
                continue;
            }
            this.asyncResponses.add(response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                MessageStatus[] statuses = new MessageStatus[list.size()];
                list.toArray(statuses);
                return statuses;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    public MessageStatus store(int message, String flagCommand, String[] flags) throws IOException {
        String ids = message == -1 ? "*" : Integer.toString(message);
        return this.storeImpl("STORE", ids, flagCommand, flags)[0];
    }

    public MessageStatus[] store(int start, int end, String flagCommand, String[] flags) throws IOException {
        StringBuffer ids = new StringBuffer();
        ids.append(start == -1 ? 42 : start);
        ids.append(':');
        ids.append(end == -1 ? 42 : end);
        return this.storeImpl("STORE", ids.toString(), flagCommand, flags);
    }

    public MessageStatus[] store(int[] messages, String flagCommand, String[] flags) throws IOException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < messages.length; ++i) {
            if (i > 0) {
                ids.append(',');
            }
            ids.append(messages[i]);
        }
        return this.storeImpl("STORE", ids.toString(), flagCommand, flags);
    }

    public MessageStatus uidStore(long uid, String flagCommand, String[] flags) throws IOException {
        String ids = uid == -1L ? "*" : Long.toString(uid);
        return this.storeImpl("UID STORE", ids, flagCommand, flags)[0];
    }

    public MessageStatus[] uidStore(long start, long end, String flagCommand, String[] flags) throws IOException {
        StringBuffer ids = new StringBuffer();
        ids.append(start == -1L ? 42L : start);
        ids.append(':');
        ids.append(end == -1L ? 42L : end);
        return this.storeImpl("UID STORE", ids.toString(), flagCommand, flags);
    }

    public MessageStatus[] uidStore(long[] uids, String flagCommand, String[] flags) throws IOException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < uids.length; ++i) {
            if (i > 0) {
                ids.append(',');
            }
            ids.append(uids[i]);
        }
        return this.storeImpl("UID STORE", ids.toString(), flagCommand, flags);
    }

    private MessageStatus[] storeImpl(String cmd, String ids, String flagCommand, String[] flags) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        StringBuffer buffer = new StringBuffer(cmd);
        buffer.append(' ');
        buffer.append(ids);
        buffer.append(' ');
        buffer.append(flagCommand);
        buffer.append(' ');
        buffer.append('(');
        for (int i = 0; i < flags.length; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(flags[i]);
        }
        buffer.append(')');
        this.sendCommand(tag, buffer.toString());
        ArrayList<MessageStatus> list = new ArrayList<MessageStatus>();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (!response.isUntagged()) break;
            int msgnum = response.getCount();
            List code = response.getResponseCode();
            if (id == "FETCH") {
                MessageStatus mf = new MessageStatus(msgnum, code);
                list.add(mf);
                continue;
            }
            if (id == "FETCH FLAGS") {
                ArrayList<Object> base = new ArrayList<Object>();
                base.add("FLAGS");
                base.add(code);
                MessageStatus mf = new MessageStatus(msgnum, base);
                list.add(mf);
                continue;
            }
            this.asyncResponses.add(response);
        }
        if (tag.equals(response.getTag())) {
            this.processAlerts(response);
            if (id == "OK") {
                MessageStatus[] mf = new MessageStatus[list.size()];
                list.toArray(mf);
                return mf;
            }
            throw new IMAPException(id, response.getText());
        }
        throw new IMAPException(id, response.getText());
    }

    public boolean copy(int[] messages, String mailbox) throws IOException {
        if (messages == null || messages.length < 1) {
            return true;
        }
        StringBuffer buffer = new StringBuffer("COPY").append(' ');
        for (int i = 0; i < messages.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(messages[i]);
        }
        buffer.append(' ').append(IMAPConnection.quote(UTF7imap.encode(mailbox)));
        return this.invokeSimpleCommand(buffer.toString());
    }

    public Namespaces namespace() throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        this.sendCommand(tag, "NAMESPACE");
        Namespaces namespaces = null;
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return namespaces;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if ("NAMESPACE".equals(response.getID())) {
                namespaces = new Namespaces(response.getText());
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    public boolean setacl(String mailbox, String principal, int rights) throws IOException {
        String command = "SETACL " + IMAPConnection.quote(UTF7imap.encode(mailbox)) + ' ' + UTF7imap.encode(principal) + ' ' + this.rightsToString(rights);
        return this.invokeSimpleCommand(command);
    }

    public boolean deleteacl(String mailbox, String principal) throws IOException {
        String command = "DELETEACL " + IMAPConnection.quote(UTF7imap.encode(mailbox)) + ' ' + UTF7imap.encode(principal);
        return this.invokeSimpleCommand(command);
    }

    public Map getacl(String mailbox) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        this.sendCommand(tag, "GETACL " + IMAPConnection.quote(UTF7imap.encode(mailbox)));
        TreeMap ret = new TreeMap();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return ret;
                }
                if (id == "NO") {
                    return null;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if ("ACL".equals(response.getID())) {
                String text = response.getText();
                List args = this.parseACL(text, 1);
                String rights = (String)args.get(2);
                ret.put(args.get(1), new Integer(this.stringToRights(rights)));
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    public int listrights(String mailbox, String principal) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        String command = "LISTRIGHTS " + IMAPConnection.quote(UTF7imap.encode(mailbox)) + ' ' + UTF7imap.encode(principal);
        this.sendCommand(tag, command);
        int ret = -1;
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return ret;
                }
                if (id == "NO") {
                    return -1;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if ("LISTRIGHTS".equals(response.getID())) {
                String text = response.getText();
                List args = this.parseACL(text, 1);
                ret = this.stringToRights((String)args.get(2));
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    public int myrights(String mailbox) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        String command = "MYRIGHTS " + IMAPConnection.quote(UTF7imap.encode(mailbox));
        this.sendCommand(tag, command);
        int ret = -1;
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return ret;
                }
                if (id == "NO") {
                    return -1;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if ("MYRIGHTS".equals(response.getID())) {
                String text = response.getText();
                List args = this.parseACL(text, 0);
                ret = this.stringToRights((String)args.get(2));
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    private String rightsToString(int rights) {
        StringBuffer buf = new StringBuffer();
        if ((rights & 1) != 0) {
            buf.append('l');
        }
        if ((rights & 2) != 0) {
            buf.append('r');
        }
        if ((rights & 4) != 0) {
            buf.append('s');
        }
        if ((rights & 8) != 0) {
            buf.append('w');
        }
        if ((rights & 0x10) != 0) {
            buf.append('i');
        }
        if ((rights & 0x20) != 0) {
            buf.append('p');
        }
        if ((rights & 0x40) != 0) {
            buf.append('c');
        }
        if ((rights & 0x80) != 0) {
            buf.append('d');
        }
        if ((rights & 0x100) != 0) {
            buf.append('a');
        }
        return buf.toString();
    }

    private int stringToRights(String text) {
        int ret = 0;
        int len = text.length();
        block11: for (int i = 0; i < len; ++i) {
            switch (text.charAt(i)) {
                case 'l': {
                    ret |= 1;
                    continue block11;
                }
                case 'r': {
                    ret |= 2;
                    continue block11;
                }
                case 's': {
                    ret |= 4;
                    continue block11;
                }
                case 'w': {
                    ret |= 8;
                    continue block11;
                }
                case 'i': {
                    ret |= 0x10;
                    continue block11;
                }
                case 'p': {
                    ret |= 0x20;
                    continue block11;
                }
                case 'c': {
                    ret |= 0x40;
                    continue block11;
                }
                case 'd': {
                    ret |= 0x80;
                    continue block11;
                }
                case 'a': {
                    ret |= 0x100;
                }
            }
        }
        return ret;
    }

    private List parseACL(String text, int prolog) {
        int len = text.length();
        boolean inQuotes = false;
        ArrayList<String> ret = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block4;
                }
                case ' ': {
                    if (inQuotes || ret.size() > prolog) {
                        buf.append(c);
                        continue block4;
                    }
                    ret.add(UTF7imap.decode(buf.toString()));
                    buf.setLength(0);
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        ret.add(buf.toString());
        return ret;
    }

    public Quota setquota(String quotaRoot, Quota.Resource[] resources) throws IOException {
        String id;
        IMAPResponse response;
        StringBuffer resourceLimits = new StringBuffer();
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                if (i > 0) {
                    resourceLimits.append(' ');
                }
                resourceLimits.append(resources[i].toString());
            }
        }
        String tag = this.newTag();
        String command = "SETQUOTA " + IMAPConnection.quote(UTF7imap.encode(quotaRoot)) + ' ' + resourceLimits.toString();
        this.sendCommand(tag, command);
        Quota ret = null;
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return ret;
                }
                if (id == "NO") {
                    return null;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if ("QUOTA".equals(response.getID())) {
                ret = new Quota(response.getText());
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    public Quota getquota(String quotaRoot) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        String command = "GETQUOTA " + IMAPConnection.quote(UTF7imap.encode(quotaRoot));
        this.sendCommand(tag, command);
        Quota ret = null;
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    return ret;
                }
                if (id == "NO") {
                    return null;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if ("QUOTA".equals(response.getID())) {
                ret = new Quota(response.getText());
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    public Quota[] getquotaroot(String mailbox) throws IOException {
        String id;
        IMAPResponse response;
        String tag = this.newTag();
        String command = "GETQUOTAROOT " + IMAPConnection.quote(UTF7imap.encode(mailbox));
        this.sendCommand(tag, command);
        ArrayList<Quota> acc = new ArrayList<Quota>();
        while (true) {
            response = this.readResponse();
            id = response.getID();
            if (tag.equals(response.getTag())) {
                this.processAlerts(response);
                if (id == "OK") {
                    Quota[] ret = new Quota[acc.size()];
                    acc.toArray(ret);
                    return ret;
                }
                if (id == "NO") {
                    return null;
                }
                throw new IMAPException(id, response.getText());
            }
            if (!response.isUntagged()) break;
            if ("QUOTA".equals(response.getID())) {
                acc.add(new Quota(response.getText()));
                continue;
            }
            this.asyncResponses.add(response);
        }
        throw new IMAPException(id, response.getText());
    }

    static String stripQuotes(String text) {
        int len;
        if (text.charAt(0) == '\"' && text.charAt((len = text.length()) - 1) == '\"') {
            return text.substring(1, len - 1);
        }
        return text;
    }

    static String quote(String text) {
        if (text.length() == 0 || text.indexOf(32) != -1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('\"');
            buffer.append(text);
            buffer.append('\"');
            return buffer.toString();
        }
        return text;
    }
}

