/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.smtp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jpackage.mail.inet.smtp.ParameterList;
import org.jpackage.mail.inet.util.BASE64;
import org.jpackage.mail.inet.util.CRLFInputStream;
import org.jpackage.mail.inet.util.CRLFOutputStream;
import org.jpackage.mail.inet.util.EmptyX509TrustManager;
import org.jpackage.mail.inet.util.LineInputStream;
import org.jpackage.mail.inet.util.MessageOutputStream;
import org.jpackage.mail.inet.util.SaslCallbackHandler;
import org.jpackage.mail.inet.util.SaslCramMD5;
import org.jpackage.mail.inet.util.SaslInputStream;
import org.jpackage.mail.inet.util.SaslLogin;
import org.jpackage.mail.inet.util.SaslOutputStream;
import org.jpackage.mail.inet.util.SaslPlain;
import org.jpackage.mail.inet.util.TraceLevel;

public class SMTPConnection {
    public static final Logger logger = Logger.getLogger("org.jpackage.mail.inet.smtp");
    public static final Level SMTP_TRACE = new TraceLevel("smtp");
    public static final int DEFAULT_PORT = 25;
    protected static final String MAIL_FROM = "MAIL FROM:";
    protected static final String RCPT_TO = "RCPT TO:";
    protected static final String SP = " ";
    protected static final String DATA = "DATA";
    protected static final String FINISH_DATA = "\n.";
    protected static final String RSET = "RSET";
    protected static final String VRFY = "VRFY";
    protected static final String EXPN = "EXPN";
    protected static final String HELP = "HELP";
    protected static final String NOOP = "NOOP";
    protected static final String QUIT = "QUIT";
    protected static final String HELO = "HELO";
    protected static final String EHLO = "EHLO";
    protected static final String AUTH = "AUTH";
    protected static final String STARTTLS = "STARTTLS";
    protected static final int INFO = 214;
    protected static final int READY = 220;
    protected static final int OK = 250;
    protected static final int OK_NOT_LOCAL = 251;
    protected static final int OK_UNVERIFIED = 252;
    protected static final int SEND_DATA = 354;
    protected static final int AMBIGUOUS = 553;
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected String response;
    protected boolean continuation;
    protected final String greeting;

    public SMTPConnection(String host) throws IOException {
        this(host, 25, 0, 0, false, null);
    }

    public SMTPConnection(String host, int port) throws IOException {
        this(host, port, 0, 0, false, null);
    }

    public SMTPConnection(String host, int port, int connectionTimeout, int timeout) throws IOException {
        this(host, port, connectionTimeout, timeout, false, null);
    }

    public SMTPConnection(String host, int port, int connectionTimeout, int timeout, boolean secure, TrustManager tm) throws IOException {
        if (port <= 0) {
            port = 25;
        }
        this.response = null;
        this.continuation = false;
        try {
            this.socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(host, port);
            if (connectionTimeout > 0) {
                this.socket.connect(address, connectionTimeout);
            } else {
                this.socket.connect(address);
            }
            if (timeout > 0) {
                this.socket.setSoTimeout(timeout);
            }
            if (secure) {
                SSLSocketFactory factory = this.getSSLSocketFactory(tm);
                SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, host, port, true);
                String[] protocols = new String[]{"TLSv1", "SSLv3"};
                ss.setEnabledProtocols(protocols);
                ss.setUseClientMode(true);
                ss.startHandshake();
                this.socket = ss;
            }
        }
        catch (GeneralSecurityException e) {
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
        InputStream in = this.socket.getInputStream();
        in = new BufferedInputStream(in);
        in = new CRLFInputStream(in);
        this.in = new LineInputStream(in);
        OutputStream out = this.socket.getOutputStream();
        out = new BufferedOutputStream(out);
        this.out = new CRLFOutputStream(out);
        StringBuffer greetingBuffer = new StringBuffer();
        boolean notFirst = false;
        do {
            if (this.getResponse() != 220) {
                throw new ProtocolException(this.response);
            }
            if (notFirst) {
                greetingBuffer.append('\n');
            } else {
                notFirst = true;
            }
            greetingBuffer.append(this.response);
        } while (this.continuation);
        this.greeting = greetingBuffer.toString();
    }

    public String getGreeting() {
        return this.greeting;
    }

    public String getLastResponse() {
        return this.response;
    }

    public boolean mailFrom(String reversePath, ParameterList parameters) throws IOException {
        StringBuffer command = new StringBuffer(MAIL_FROM);
        command.append('<');
        command.append(reversePath);
        command.append('>');
        if (parameters != null) {
            command.append(SP);
            command.append(parameters);
        }
        this.send(command.toString());
        switch (this.getAllResponses()) {
            case 250: 
            case 251: 
            case 252: {
                return true;
            }
        }
        return false;
    }

    public boolean rcptTo(String forwardPath, ParameterList parameters) throws IOException {
        StringBuffer command = new StringBuffer(RCPT_TO);
        command.append('<');
        command.append(forwardPath);
        command.append('>');
        if (parameters != null) {
            command.append(SP);
            command.append(parameters);
        }
        this.send(command.toString());
        switch (this.getAllResponses()) {
            case 250: 
            case 251: 
            case 252: {
                return true;
            }
        }
        return false;
    }

    public OutputStream data() throws IOException {
        this.send(DATA);
        switch (this.getAllResponses()) {
            case 354: {
                return new MessageOutputStream(this.out);
            }
        }
        throw new ProtocolException(this.response);
    }

    public boolean finishData() throws IOException {
        this.send(FINISH_DATA);
        switch (this.getAllResponses()) {
            case 250: {
                return true;
            }
        }
        return false;
    }

    public void rset() throws IOException {
        this.send(RSET);
        if (this.getAllResponses() != 250) {
            throw new ProtocolException(this.response);
        }
    }

    public List vrfy(String address) throws IOException {
        String command = "VRFY " + address;
        this.send(command);
        ArrayList<String> list = new ArrayList<String>();
        block3: do {
            switch (this.getResponse()) {
                case 250: 
                case 553: {
                    this.response = this.response.trim();
                    if (this.response.indexOf(64) != -1) {
                        list.add(this.response);
                        break;
                    }
                    if (this.response.indexOf(60) != -1) {
                        list.add(this.response);
                        break;
                    }
                    if (this.response.indexOf(32) != -1) continue block3;
                    list.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(list);
    }

    public List expn(String address) throws IOException {
        String command = "EXPN " + address;
        this.send(command);
        ArrayList<String> list = new ArrayList<String>();
        do {
            switch (this.getResponse()) {
                case 250: {
                    this.response = this.response.trim();
                    list.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(list);
    }

    public List help(String arg) throws IOException {
        String command = arg == null ? HELP : "HELP " + arg;
        this.send(command);
        ArrayList<String> list = new ArrayList<String>();
        do {
            switch (this.getResponse()) {
                case 214: {
                    list.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(list);
    }

    public void noop() throws IOException {
        this.send(NOOP);
        this.getAllResponses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException {
        try {
            this.send(QUIT);
            this.getAllResponses();
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket.close();
        }
    }

    public boolean helo(String hostname) throws IOException {
        String command = "HELO " + hostname;
        this.send(command);
        return this.getAllResponses() == 250;
    }

    public List ehlo(String hostname) throws IOException {
        String command = "EHLO " + hostname;
        this.send(command);
        ArrayList<String> extensions = new ArrayList<String>();
        do {
            switch (this.getResponse()) {
                case 250: {
                    extensions.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(extensions);
    }

    protected SSLSocketFactory getSSLSocketFactory(TrustManager tm) throws GeneralSecurityException {
        if (tm == null) {
            tm = new EmptyX509TrustManager();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trust = new TrustManager[]{tm};
        context.init(null, trust, null);
        return context.getSocketFactory();
    }

    public boolean starttls() throws IOException {
        return this.starttls(new EmptyX509TrustManager());
    }

    public boolean starttls(TrustManager tm) throws IOException {
        try {
            SSLSocketFactory factory = this.getSSLSocketFactory(tm);
            this.send(STARTTLS);
            if (this.getAllResponses() != 220) {
                return false;
            }
            String hostname = this.socket.getInetAddress().getHostName();
            int port = this.socket.getPort();
            SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, hostname, port, true);
            String[] protocols = new String[]{"TLSv1", "SSLv3"};
            ss.setEnabledProtocols(protocols);
            ss.setUseClientMode(true);
            ss.startHandshake();
            InputStream in = ss.getInputStream();
            in = new BufferedInputStream(in);
            in = new CRLFInputStream(in);
            this.in = new LineInputStream(in);
            OutputStream out = ss.getOutputStream();
            out = new BufferedOutputStream(out);
            this.out = new CRLFOutputStream(out);
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public boolean authenticate(String mechanism, String username, String password) throws IOException {
        try {
            String[] m = new String[]{mechanism};
            SaslCallbackHandler ch = new SaslCallbackHandler(username, password);
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("gnu.crypto.sasl.username", username);
            p.put("gnu.crypto.sasl.password", password);
            SaslClient sasl = Sasl.createSaslClient(m, null, "smtp", this.socket.getInetAddress().getHostName(), p, ch);
            if (sasl == null) {
                if ("LOGIN".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslLogin(username, password);
                } else if ("PLAIN".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslPlain(username, password);
                } else if ("CRAM-MD5".equalsIgnoreCase(mechanism)) {
                    sasl = new SaslCramMD5(username, password);
                } else {
                    return false;
                }
            }
            StringBuffer cmd = new StringBuffer(AUTH);
            cmd.append(' ');
            cmd.append(mechanism);
            if (sasl.hasInitialResponse()) {
                cmd.append(' ');
                byte[] init = sasl.evaluateChallenge(new byte[0]);
                if (init.length == 0) {
                    cmd.append('=');
                } else {
                    cmd.append(new String(BASE64.encode(init), "US-ASCII"));
                }
            }
            this.send(cmd.toString());
            block9: while (true) {
                switch (this.getAllResponses()) {
                    case 334: {
                        try {
                            byte[] c0 = this.response.getBytes("US-ASCII");
                            byte[] c1 = BASE64.decode(c0);
                            byte[] r0 = sasl.evaluateChallenge(c1);
                            byte[] r1 = BASE64.encode(r0);
                            this.out.write(r1);
                            this.out.write(13);
                            this.out.flush();
                            logger.log(SMTP_TRACE, "> " + new String(r1, "US-ASCII"));
                        }
                        catch (SaslException e) {
                            this.out.write(42);
                            this.out.write(13);
                            this.out.flush();
                            logger.log(SMTP_TRACE, "> *");
                        }
                        continue block9;
                    }
                    case 235: {
                        String qop = (String)sasl.getNegotiatedProperty("javax.security.sasl.qop");
                        if ("auth-int".equalsIgnoreCase(qop) || "auth-conf".equalsIgnoreCase(qop)) {
                            InputStream in = this.socket.getInputStream();
                            in = new BufferedInputStream(in);
                            in = new SaslInputStream(sasl, in);
                            in = new CRLFInputStream(in);
                            this.in = new LineInputStream(in);
                            OutputStream out = this.socket.getOutputStream();
                            out = new BufferedOutputStream(out);
                            out = new SaslOutputStream(sasl, out);
                            this.out = new CRLFOutputStream(out);
                        }
                        return true;
                    }
                }
                break;
            }
            return false;
        }
        catch (SaslException e) {
            logger.log(SMTP_TRACE, e.getMessage(), e);
            return false;
        }
        catch (RuntimeException e) {
            logger.log(SMTP_TRACE, e.getMessage(), e);
            return false;
        }
    }

    protected void send(String command) throws IOException {
        logger.log(SMTP_TRACE, "> " + command);
        this.out.write(command.getBytes("US-ASCII"));
        this.out.write(13);
        this.out.flush();
    }

    protected int getResponse() throws IOException {
        String line = null;
        try {
            line = this.in.readLine();
            if (line.length() < 4) {
                line = line + '\n' + this.in.readLine();
            }
            logger.log(SMTP_TRACE, "< " + line);
            int code = Integer.parseInt(line.substring(0, 3));
            this.continuation = line.charAt(3) == '-';
            this.response = line.substring(4);
            return code;
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Unexpected response: " + line);
        }
    }

    protected int getAllResponses() throws IOException {
        int code;
        boolean err = false;
        int code1 = code = this.getResponse();
        while (this.continuation) {
            code = this.getResponse();
            if (code == code1) continue;
            err = true;
        }
        if (err) {
            throw new ProtocolException("Conflicting response codes");
        }
        return code;
    }
}

