/*
 * Decompiled with CFR 0.152.
 */
package org.jpackage.mail.inet.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MessageInputStream
extends FilterInputStream {
    public static final int END = 46;
    public static final int LF = 10;
    protected boolean eof = false;
    protected int buf1 = -1;
    protected int buf2 = -1;
    protected int markBuf1;
    protected int markBuf2;

    public MessageInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int c;
        if (this.eof) {
            return -1;
        }
        if (this.buf1 != -1) {
            c = this.buf1;
            this.buf1 = this.buf2;
            this.buf2 = -1;
        } else {
            c = super.read();
        }
        if (c == 10) {
            if (this.buf1 == -1) {
                this.buf1 = super.read();
                if (this.buf1 == 46) {
                    this.buf2 = super.read();
                    if (this.buf2 == 10) {
                        this.eof = true;
                    }
                }
            } else if (this.buf1 == 46) {
                if (this.buf2 == -1) {
                    this.buf2 = super.read();
                    if (this.buf2 == 10) {
                        this.eof = true;
                    }
                } else if (this.buf2 == 10) {
                    this.eof = true;
                }
            }
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        int end = off + len;
        for (int i = off; i < end; ++i) {
            int c = this.read();
            if (c == -1) {
                len = i - off;
                break;
            }
            b[i] = (byte)c;
        }
        return len;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markBuf1 = this.buf1;
        this.markBuf2 = this.buf2;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.buf1 = this.markBuf1;
        this.buf2 = this.markBuf2;
    }
}

