/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.timespec;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class TimeSpec {
    static final int TYPE_ABSOLUTE = 0;
    static final int TYPE_START = 1;
    static final int TYPE_END = 2;
    int type = 0;
    int year;
    int month;
    int day;
    int hour;
    int min;
    int sec;
    int wday;
    int dyear;
    int dmonth;
    int dday;
    int dhour;
    int dmin;
    int dsec;
    String dateString;
    TimeSpec context;

    TimeSpec(String dateString) {
        this.dateString = dateString;
    }

    void localtime(long timestamp) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(new Date(timestamp * 1000L));
        this.year = date.get(1) - 1900;
        this.month = date.get(2);
        this.day = date.get(5);
        this.hour = date.get(11);
        this.min = date.get(12);
        this.sec = date.get(13);
        this.wday = date.get(7) - 1;
    }

    GregorianCalendar getTime() throws RrdException {
        GregorianCalendar gc;
        if (this.type == 0) {
            gc = new GregorianCalendar(this.year + 1900, this.month, this.day, this.hour, this.min, this.sec);
        } else if (this.context != null && this.context.type == 0) {
            gc = this.context.getTime();
        } else {
            throw new RrdException("Relative times like '" + this.dateString + "' require proper absolute context to be evaluated");
        }
        gc.add(1, this.dyear);
        gc.add(2, this.dmonth);
        gc.add(5, this.dday);
        gc.add(11, this.dhour);
        gc.add(12, this.dmin);
        gc.add(13, this.dsec);
        return gc;
    }

    public long getTimestamp() throws RrdException {
        return Util.getTimestamp(this.getTime());
    }

    String dump() {
        return (this.type == 0 ? "ABSTIME" : (this.type == 1 ? "START" : "END")) + ": " + this.year + "/" + this.month + "/" + this.day + "/" + this.hour + "/" + this.min + "/" + this.sec + " (" + this.dyear + "/" + this.dmonth + "/" + this.dday + "/" + this.dhour + "/" + this.dmin + "/" + this.dsec + ")";
    }

    public static Calendar[] getTimes(TimeSpec spec1, TimeSpec spec2) throws RrdException {
        if (spec1.type == 1 || spec2.type == 2) {
            throw new RrdException("Recursive time specifications not allowed");
        }
        spec1.context = spec2;
        spec2.context = spec1;
        return new Calendar[]{spec1.getTime(), spec2.getTime()};
    }

    public static long[] getTimestamps(TimeSpec spec1, TimeSpec spec2) throws RrdException {
        Calendar[] gcs = TimeSpec.getTimes(spec1, spec2);
        return new long[]{Util.getTimestamp(gcs[0]), Util.getTimestamp(gcs[1])};
    }
}

