/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Plottable;
import org.jrobin.graph.Area;
import org.jrobin.graph.CDef;
import org.jrobin.graph.CommentText;
import org.jrobin.graph.Def;
import org.jrobin.graph.HRule;
import org.jrobin.graph.LegendText;
import org.jrobin.graph.Line;
import org.jrobin.graph.PDef;
import org.jrobin.graph.PlotElement;
import org.jrobin.graph.PrintText;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.SDef;
import org.jrobin.graph.Source;
import org.jrobin.graph.SourcedPlotElement;
import org.jrobin.graph.Stack;
import org.jrobin.graph.TimeAxisSetting;
import org.jrobin.graph.VRule;
import org.jrobin.graph.ValueAxisSetting;

public class RrdGraphDef
implements RrdGraphConstants {
    boolean poolUsed = false;
    boolean antiAliasing = false;
    String filename = "-";
    long startTime;
    long endTime;
    TimeAxisSetting timeAxisSetting = null;
    ValueAxisSetting valueAxisSetting = null;
    boolean altYGrid = false;
    boolean noMinorGrid = false;
    boolean altYMrtg = false;
    boolean altAutoscale = false;
    boolean altAutoscaleMax = false;
    int unitsExponent = Integer.MAX_VALUE;
    int unitsLength = 9;
    String verticalLabel = null;
    int width = 400;
    int height = 100;
    boolean interlaced = false;
    String imageInfo = null;
    String imageFormat = "gif";
    float imageQuality = 0.8f;
    String backgroundImage = null;
    String overlayImage = null;
    String unit = null;
    String signature = "Created with JRobin";
    boolean lazy = false;
    double minValue = Double.NaN;
    double maxValue = Double.NaN;
    boolean rigid = false;
    double base = 1000.0;
    boolean logarithmic = false;
    Paint[] colors = new Paint[]{DEFAULT_CANVAS_COLOR, DEFAULT_BACK_COLOR, DEFAULT_SHADEA_COLOR, DEFAULT_SHADEB_COLOR, DEFAULT_GRID_COLOR, DEFAULT_MGRID_COLOR, DEFAULT_FONT_COLOR, DEFAULT_FRAME_COLOR, DEFAULT_ARROW_COLOR};
    boolean noLegend = false;
    boolean onlyGraph = false;
    boolean forceRulesLegend = false;
    String title = null;
    long step = 0L;
    protected Font smallFont;
    protected Font largeFont;
    boolean drawXGrid = true;
    boolean drawYGrid = true;
    int firstDayOfWeek = FIRST_DAY_OF_WEEK;
    boolean showSignature = true;
    File fontDir = null;
    List<Source> sources = new ArrayList<Source>();
    List<CommentText> comments = new ArrayList<CommentText>();
    List<PlotElement> plotElements = new ArrayList<PlotElement>();

    public RrdGraphDef() {
        try {
            this.setTimeSpan(Util.getTimestamps("end-1d", "now"));
        }
        catch (RrdException e) {
            throw new RuntimeException(e);
        }
        String fontdirProperty = System.getProperty("jrobin.fontdir");
        if (fontdirProperty != null && fontdirProperty.length() != 0) {
            this.fontDir = new File(fontdirProperty);
        }
        this.smallFont = new Font(DEFAULT_FONT_NAME, 0, 10);
        this.largeFont = new Font(DEFAULT_FONT_NAME, 1, 12);
    }

    protected Font getFontFromResourceName(String name) {
        Font font = null;
        Exception exception = null;
        URL file = null;
        if (this.fontDir != null) {
            try {
                file = new URL("file://" + new File(this.fontDir, name).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                exception = e;
            }
        }
        if (file == null) {
            file = this.getClass().getResource(name);
        }
        if (file != null) {
            try {
                InputStream fontStream = file.openStream();
                font = Font.createFont(0, fontStream);
                fontStream.close();
            }
            catch (Exception e) {
                exception = e;
            }
        } else {
            System.err.println("An error occurred loading the font '" + name + "'.  Falling back to the default.");
            if (exception != null) {
                System.err.println(exception.getLocalizedMessage());
            }
            font = new Font(DEFAULT_FONT_NAME, 0, 10);
        }
        if (font == null) {
            font = new Font(null, 0, 10);
        }
        return font;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setStartTime(long time) {
        this.startTime = time;
        if (time <= 0L) {
            this.startTime += Util.getTime();
        }
    }

    public void setEndTime(long time) {
        this.endTime = time;
        if (time <= 0L) {
            this.endTime += Util.getTime();
        }
    }

    public void setTimeSpan(long startTime, long endTime) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
    }

    public void setTimeSpan(long[] timestamps) {
        this.setTimeSpan(timestamps[0], timestamps[timestamps.length - 1]);
    }

    public void setPoolUsed(boolean poolUsed) {
        this.poolUsed = poolUsed;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setTimeAxis(int minorUnit, int minorUnitCount, int majorUnit, int majorUnitCount, int labelUnit, int labelUnitCount, int labelSpan, String simpleDateFormat) {
        this.timeAxisSetting = new TimeAxisSetting(minorUnit, minorUnitCount, majorUnit, majorUnitCount, labelUnit, labelUnitCount, labelSpan, simpleDateFormat);
    }

    public void setValueAxis(double gridStep, int labelFactor) {
        this.valueAxisSetting = new ValueAxisSetting(gridStep, labelFactor);
    }

    public void setAltYGrid(boolean altYGrid) {
        this.altYGrid = altYGrid;
    }

    public void setNoMinorGrid(boolean noMinorGrid) {
        this.noMinorGrid = noMinorGrid;
    }

    public void setAltYMrtg(boolean altYMrtg) {
        this.altYMrtg = altYMrtg;
    }

    public void setAltAutoscale(boolean altAutoscale) {
        this.altAutoscale = altAutoscale;
    }

    public void setAltAutoscaleMax(boolean altAutoscaleMax) {
        this.altAutoscaleMax = altAutoscaleMax;
    }

    public void setUnitsExponent(int unitsExponent) {
        this.unitsExponent = unitsExponent;
    }

    public void setUnitsLength(int unitsLength) {
        this.unitsLength = unitsLength;
    }

    public void setVerticalLabel(String verticalLabel) {
        this.verticalLabel = verticalLabel;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setInterlaced(boolean interlaced) {
        this.interlaced = interlaced;
    }

    public void setImageInfo(String imageInfo) {
        this.imageInfo = imageInfo;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setOverlayImage(String overlayImage) {
        this.overlayImage = overlayImage;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setRigid(boolean rigid) {
        this.rigid = rigid;
    }

    public void setBase(double base) {
        this.base = base;
    }

    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    public void setColor(int colorTag, Paint color) throws RrdException {
        if (colorTag < 0 || colorTag >= this.colors.length) {
            throw new RrdException("Invalid color index specified: " + colorTag);
        }
        this.colors[colorTag] = color;
    }

    public void setColor(String colorName, Paint color) throws RrdException {
        this.setColor(RrdGraphDef.getColorTagByName(colorName), color);
    }

    private static int getColorTagByName(String colorName) throws RrdException {
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            if (!COLOR_NAMES[i].equalsIgnoreCase(colorName)) continue;
            return i;
        }
        throw new RrdException("Unknown color name specified: " + colorName);
    }

    public void setNoLegend(boolean noLegend) {
        this.noLegend = noLegend;
    }

    public void setOnlyGraph(boolean onlyGraph) {
        this.onlyGraph = onlyGraph;
    }

    public void setForceRulesLegend(boolean forceRulesLegend) {
        this.forceRulesLegend = forceRulesLegend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStep(long step) {
        this.step = step;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public void setSmallFont(Font smallFont) {
        this.smallFont = smallFont;
    }

    public void setLargeFont(Font largeFont) {
        this.largeFont = largeFont;
    }

    public void datasource(String name, String rrdPath, String dsName, String consolFun) {
        this.sources.add(new Def(name, rrdPath, dsName, consolFun));
    }

    public void datasource(String name, String rrdPath, String dsName, String consolFun, String backend) {
        this.sources.add(new Def(name, rrdPath, dsName, consolFun, backend));
    }

    public void datasource(String name, String rpnExpression) {
        this.sources.add(new CDef(name, rpnExpression));
    }

    public void datasource(String name, String defName, String consolFun) {
        this.sources.add(new SDef(name, defName, consolFun));
    }

    public void datasource(String name, Plottable plottable) {
        this.sources.add(new PDef(name, plottable));
    }

    public void print(String srcName, String consolFun, String format) {
        this.comments.add(new PrintText(srcName, consolFun, format, false));
    }

    public void gprint(String srcName, String consolFun, String format) {
        this.comments.add(new PrintText(srcName, consolFun, format, true));
    }

    public void comment(String text) {
        this.comments.add(new CommentText(text));
    }

    public void hrule(double value, Paint color, String legend) {
        this.hrule(value, color, legend, 1.0f);
    }

    public void hrule(double value, Paint color, String legend, float width) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new HRule(value, color, legendText, width));
    }

    public void vrule(long timestamp, Paint color, String legend) {
        this.vrule(timestamp, color, legend, 1.0f);
    }

    public void vrule(long timestamp, Paint color, String legend, float width) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new VRule(timestamp, color, legendText, width));
    }

    public void line(String srcName, Paint color, String legend, float width) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new Line(srcName, color, width));
    }

    public void line(String srcName, Paint color, String legend) {
        this.line(srcName, color, legend, 1.0f);
    }

    public void area(String srcName, Paint color, String legend) {
        this.area(srcName, color);
        if (legend != null && legend.length() > 0) {
            LegendText legendText = new LegendText(color, legend);
            this.comments.add(legendText);
        }
    }

    public void area(String srcName, Paint color) {
        this.plotElements.add(new Area(srcName, color));
    }

    public void stack(String srcName, Paint color, String legend) throws RrdException {
        SourcedPlotElement parent = null;
        for (int i = this.plotElements.size() - 1; i >= 0; --i) {
            PlotElement plotElement = this.plotElements.get(i);
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            parent = (SourcedPlotElement)plotElement;
            break;
        }
        if (parent == null) {
            throw new RrdException("You have to stack graph onto something (line or area)");
        }
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new Stack(parent, srcName, color));
    }

    public void setDrawXGrid(boolean drawXGrid) {
        this.drawXGrid = drawXGrid;
    }

    public void setDrawYGrid(boolean drawYGrid) {
        this.drawYGrid = drawYGrid;
    }

    public void setImageQuality(float imageQuality) {
        this.imageQuality = imageQuality;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setShowSignature(boolean showSignature) {
        this.showSignature = showSignature;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    int printStatementCount() {
        int count = 0;
        for (CommentText comment : this.comments) {
            if (!(comment instanceof PrintText) || !comment.isPrint()) continue;
            ++count;
        }
        return count;
    }

    boolean shouldPlot() {
        if (this.plotElements.size() > 0) {
            return true;
        }
        for (CommentText comment : this.comments) {
            if (!comment.isValidGraphElement()) continue;
            return true;
        }
        return false;
    }
}

