/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.positioners.BasicBalloonTipPositioner;
import net.java.balloontip.positioners.LeftAbovePositioner;
import net.java.balloontip.positioners.LeftBelowPositioner;
import net.java.balloontip.positioners.RightAbovePositioner;
import net.java.balloontip.positioners.RightBelowPositioner;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.RoundedBalloonStyle;

public class BalloonTip
extends JPanel {
    protected JComponent contents = null;
    protected JButton closeButton = null;
    protected VisibilityControl visibilityControl = new VisibilityControl();
    protected BalloonTipStyle style;
    protected int padding = 0;
    protected float opacity = 1.0f;
    protected BalloonTipPositioner positioner;
    protected JLayeredPane topLevelContainer = null;
    protected JComponent attachedComponent;
    private static Icon defaultCloseIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_default.png"));
    private static Icon rolloverCloseIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_rollover.png"));
    private static Icon pressedCloseIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_pressed.png"));
    private final ComponentListener componentListener = new ComponentListener(){

        public void componentMoved(ComponentEvent e) {
            BalloonTip.this.refreshLocation();
        }

        public void componentResized(ComponentEvent e) {
            BalloonTip.this.visibilityControl.setCriteriumAndUpdate("attachedComponentShowing", BalloonTip.this.isAttachedComponentShowing());
            BalloonTip.this.refreshLocation();
        }

        public void componentShown(ComponentEvent e) {
            BalloonTip.this.visibilityControl.setCriteriumAndUpdate("attachedComponentShowing", BalloonTip.this.isAttachedComponentShowing());
            BalloonTip.this.refreshLocation();
        }

        public void componentHidden(ComponentEvent e) {
            BalloonTip.this.visibilityControl.setCriteriumAndUpdate("attachedComponentShowing", false);
        }
    };
    private final ComponentAdapter topLevelContainerListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            BalloonTip.this.refreshLocation();
        }
    };
    private ComponentAdapter tabbedPaneListener = null;
    protected NestedViewportListener viewportListener = null;
    private MouseAdapter clickListener = null;

    public BalloonTip(JComponent attachedComponent, String text) {
        this(attachedComponent, text, (BalloonTipStyle)new RoundedBalloonStyle(5, 5, Color.WHITE, Color.BLACK), true);
    }

    public BalloonTip(JComponent attachedComponent, String text, BalloonTipStyle style, boolean useCloseButton) {
        this(attachedComponent, new JLabel(text), style, useCloseButton);
    }

    public BalloonTip(JComponent attachedComponent, JComponent contents, BalloonTipStyle style, boolean useCloseButton) {
        this(attachedComponent, contents, style, Orientation.LEFT_ABOVE, AttachLocation.ALIGNED, 15, 15, useCloseButton);
    }

    public BalloonTip(JComponent attachedComponent, JComponent contents, BalloonTipStyle style, Orientation orientation, AttachLocation attachLocation, int horizontalOffset, int verticalOffset, boolean useCloseButton) {
        this.setup(attachedComponent, contents, style, this.setupPositioner(orientation, attachLocation, horizontalOffset, verticalOffset), useCloseButton ? BalloonTip.getDefaultCloseButton() : null);
    }

    public BalloonTip(JComponent attachedComponent, JComponent contents, BalloonTipStyle style, BalloonTipPositioner positioner, JButton closeButton) {
        this.setup(attachedComponent, contents, style, positioner, closeButton);
    }

    public void setContents(JComponent contents) {
        JComponent oldContents = this.contents;
        if (oldContents != null) {
            this.remove(this.contents);
        }
        this.contents = contents;
        if (contents != null) {
            this.setPadding(this.getPadding());
            this.add((Component)this.contents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.visibilityControl.setCriteriumAndUpdate("hasContents", true);
        } else {
            this.visibilityControl.setCriteriumAndUpdate("hasContents", false);
        }
        this.firePropertyChange("contents", oldContents, this.contents);
        this.refreshLocation();
    }

    public JComponent getContents() {
        return this.contents;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.contents.setBorder(BorderFactory.createEmptyBorder(padding, padding, padding, padding));
        this.refreshLocation();
    }

    public int getPadding() {
        return this.padding;
    }

    public void setStyle(BalloonTipStyle style) {
        BalloonTipStyle oldStyle = this.style;
        this.style = style;
        this.setBorder(this.style);
        this.firePropertyChange("style", oldStyle, style);
        this.refreshLocation();
    }

    public BalloonTipStyle getStyle() {
        return this.style;
    }

    public void setPositioner(BalloonTipPositioner positioner) {
        BalloonTipPositioner oldPositioner = this.positioner;
        this.positioner = positioner;
        this.positioner.setBalloonTip(this);
        this.firePropertyChange("positioner", oldPositioner, positioner);
        this.refreshLocation();
    }

    public BalloonTipPositioner getPositioner() {
        return this.positioner;
    }

    public void closeBalloon() {
        this.forceSetVisible(false);
        this.setCloseButton(null);
        for (MouseListener m : this.getMouseListeners()) {
            this.removeMouseListener(m);
        }
        this.tearDownHelper();
    }

    public void setCloseButton(JButton button) {
        this.setCloseButton(button, true, false);
    }

    public void setCloseButton(JButton button, boolean permanentClose, boolean noDefault) {
        if (this.closeButton != null) {
            for (ActionListener a : this.closeButton.getActionListeners()) {
                this.closeButton.removeActionListener(a);
            }
            this.remove(this.closeButton);
            this.closeButton = null;
        }
        if (button != null) {
            this.closeButton = button;
            if (!noDefault && permanentClose) {
                this.closeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        BalloonTip.this.closeBalloon();
                    }
                });
            } else if (!noDefault && !permanentClose) {
                this.closeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        BalloonTip.this.setVisible(false);
                    }
                });
            }
            this.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.refreshLocation();
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public static JButton getDefaultCloseButton() {
        JButton button = new JButton();
        button.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        button.setContentAreaFilled(false);
        button.setIcon(defaultCloseIcon);
        button.setRolloverIcon(rolloverCloseIcon);
        button.setPressedIcon(pressedCloseIcon);
        return button;
    }

    public static void setDefaultCloseButtonIcons(Icon normal, Icon pressed, Icon rollover) {
        defaultCloseIcon = normal;
        rolloverCloseIcon = rollover;
        pressedCloseIcon = pressed;
    }

    public void addDefaultMouseListener(boolean permanentClose) {
        this.removeMouseListener(this.clickListener);
        this.clickListener = permanentClose ? new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                e.consume();
                BalloonTip.this.closeBalloon();
            }
        } : new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                e.consume();
                BalloonTip.this.setVisible(false);
            }
        };
        this.addMouseListener(this.clickListener);
    }

    public void setAttachedComponent(JComponent newComponent) {
        JComponent oldComponent = this.attachedComponent;
        this.tearDownHelper();
        this.attachedComponent = newComponent;
        this.setupHelper();
        this.firePropertyChange("attachedComponent", oldComponent, this.attachedComponent);
        this.refreshLocation();
    }

    public JComponent getAttachedComponent() {
        return this.attachedComponent;
    }

    public void setTopLevelContainer(JLayeredPane tlc) {
        if (this.topLevelContainer != null) {
            this.topLevelContainer.remove(this);
            this.topLevelContainer.removeComponentListener(this.topLevelContainerListener);
        }
        this.topLevelContainer = tlc;
        this.topLevelContainer.addComponentListener(this.topLevelContainerListener);
        this.topLevelContainer.add((Component)this, JLayeredPane.POPUP_LAYER);
    }

    public JLayeredPane getTopLevelContainer() {
        return this.topLevelContainer;
    }

    public Rectangle getAttachedRectangle() {
        Point location = SwingUtilities.convertPoint(this.attachedComponent, this.getLocation(), this);
        return new Rectangle(location.x, location.y, this.attachedComponent.getWidth(), this.attachedComponent.getHeight());
    }

    public void refreshLocation() {
        if (this.topLevelContainer != null) {
            this.positioner.determineAndSetLocation(this.getAttachedRectangle());
        }
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
        this.repaint();
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void paintComponent(Graphics g) {
        if (this.opacity != 1.0f) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.opacity));
        }
        super.paintComponent(g);
    }

    public void setVisible(boolean visible) {
        this.visibilityControl.setCriteriumAndUpdate("manual", visible);
    }

    protected void finalize() throws Throwable {
        this.closeBalloon();
        super.finalize();
    }

    protected void forceSetVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected boolean isAttachedComponentShowing() {
        return this.attachedComponent.isShowing() && this.attachedComponent.getWidth() > 0 && this.attachedComponent.getHeight() > 0;
    }

    protected BalloonTip() {
    }

    protected BalloonTipPositioner setupPositioner(Orientation orientation, AttachLocation attachLocation, int horizontalOffset, int verticalOffset) {
        BasicBalloonTipPositioner positioner = null;
        float attachX = 0.0f;
        float attachY = 0.0f;
        boolean fixedAttachLocation = true;
        switch (attachLocation) {
            case ALIGNED: {
                fixedAttachLocation = false;
                break;
            }
            case CENTER: {
                attachX = 0.5f;
                attachY = 0.5f;
                break;
            }
            case NORTH: {
                attachX = 0.5f;
                break;
            }
            case NORTHEAST: {
                attachX = 1.0f;
                break;
            }
            case EAST: {
                attachX = 1.0f;
                attachY = 0.5f;
                break;
            }
            case SOUTHEAST: {
                attachX = 1.0f;
                attachY = 1.0f;
                break;
            }
            case SOUTH: {
                attachX = 0.5f;
                attachY = 1.0f;
                break;
            }
            case SOUTHWEST: {
                attachY = 1.0f;
                break;
            }
            case WEST: {
                attachY = 0.5f;
                break;
            }
        }
        switch (orientation) {
            case LEFT_ABOVE: {
                positioner = new LeftAbovePositioner(horizontalOffset, verticalOffset);
                break;
            }
            case LEFT_BELOW: {
                positioner = new LeftBelowPositioner(horizontalOffset, verticalOffset);
                break;
            }
            case RIGHT_ABOVE: {
                positioner = new RightAbovePositioner(horizontalOffset, verticalOffset);
                break;
            }
            case RIGHT_BELOW: {
                positioner = new RightBelowPositioner(horizontalOffset, verticalOffset);
            }
        }
        positioner.enableFixedAttachLocation(fixedAttachLocation);
        positioner.setAttachLocation(attachX, attachY);
        return positioner;
    }

    protected void setup(JComponent attachedComponent, JComponent contents, BalloonTipStyle style, BalloonTipPositioner positioner, JButton closeButton) {
        this.attachedComponent = attachedComponent;
        this.contents = contents;
        this.style = style;
        this.positioner = positioner;
        positioner.setBalloonTip(this);
        this.setBorder(this.style);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setPadding(4);
        this.add((Component)this.contents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setCloseButton(closeButton);
        this.clickListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                e.consume();
            }
        };
        this.addMouseListener(this.clickListener);
        if (attachedComponent.isValid()) {
            this.setupHelper();
        } else {
            AncestorListener attachedComponentParentListener = new AncestorListener(){

                public void ancestorAdded(AncestorEvent e) {
                    BalloonTip.this.setupHelper();
                    e.getComponent().removeAncestorListener(this);
                }

                public void ancestorMoved(AncestorEvent e) {
                }

                public void ancestorRemoved(AncestorEvent e) {
                }
            };
            attachedComponent.addAncestorListener(attachedComponentParentListener);
        }
    }

    private void setupHelper() {
        if (this.topLevelContainer == null) {
            this.setTopLevelContainer(this.attachedComponent.getRootPane().getLayeredPane());
        }
        this.attachedComponent.addComponentListener(this.componentListener);
        this.visibilityControl.setCriteriumAndUpdate("attachedComponentShowing", this.isAttachedComponentShowing());
        Container previous = this.attachedComponent;
        for (Container current = this.attachedComponent.getParent(); current != null; current = current.getParent()) {
            if (current instanceof JTabbedPane) {
                if (this.tabbedPaneListener == null) {
                    this.tabbedPaneListener = this.getTabbedPaneListener();
                }
                previous.addComponentListener(this.tabbedPaneListener);
            } else if (current instanceof JViewport) {
                if (this.viewportListener == null) {
                    this.viewportListener = new NestedViewportListener();
                }
                this.viewportListener.viewports.add((JViewport)current);
                ((JViewport)current).addChangeListener(this.viewportListener);
            } else if (current instanceof BalloonTip) {
                current.addComponentListener(this.componentListener);
                this.topLevelContainer.setLayer(this, JLayeredPane.getLayer(this) + 1);
                break;
            }
            previous = current;
        }
        this.refreshLocation();
        if (this.viewportListener != null) {
            this.viewportListener.stateChanged(new ChangeEvent(this));
        }
    }

    private void tearDownHelper() {
        this.attachedComponent.removeComponentListener(this.componentListener);
        if (this.tabbedPaneListener != null || this.viewportListener != null) {
            Container previous = this.attachedComponent;
            for (Container current = this.attachedComponent.getParent(); current != null; current = current.getParent()) {
                if (current instanceof JTabbedPane) {
                    previous.removeComponentListener(this.tabbedPaneListener);
                } else if (current instanceof JViewport) {
                    ((JViewport)current).removeChangeListener(this.viewportListener);
                } else if (current instanceof BalloonTip) {
                    current.removeComponentListener(this.componentListener);
                    break;
                }
                previous = current;
            }
            this.tabbedPaneListener = null;
        }
        if (this.topLevelContainer != null) {
            this.topLevelContainer.remove(this);
            this.topLevelContainer.removeComponentListener(this.topLevelContainerListener);
            this.topLevelContainer = null;
        }
        if (this.viewportListener != null) {
            this.viewportListener.viewports.clear();
            this.viewportListener = null;
        }
        this.visibilityControl.criteria.clear();
    }

    private ComponentAdapter getTabbedPaneListener() {
        return new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                BalloonTip.this.visibilityControl.setCriteriumAndUpdate("tabShowing", true);
                BalloonTip.this.visibilityControl.setCriteriumAndUpdate("attachedComponentShowing", BalloonTip.this.isAttachedComponentShowing());
                BalloonTip.this.refreshLocation();
            }

            public void componentHidden(ComponentEvent e) {
                BalloonTip.this.visibilityControl.setCriteriumAndUpdate("tabShowing", false);
            }
        };
    }

    protected class VisibilityControl {
        private HashMap<String, Boolean> criteria = new HashMap();

        protected VisibilityControl() {
        }

        public void setCriteriumAndUpdate(String criterium, Boolean value) {
            this.criteria.put(criterium, value);
            this.update();
        }

        public void update() {
            Iterator<Boolean> i = this.criteria.values().iterator();
            while (i.hasNext()) {
                if (i.next().booleanValue()) continue;
                BalloonTip.this.forceSetVisible(false);
                return;
            }
            BalloonTip.this.forceSetVisible(true);
        }
    }

    private class NestedViewportListener
    implements ChangeListener {
        private Vector<JViewport> viewports = new Vector();

        private NestedViewportListener() {
        }

        public void stateChanged(ChangeEvent e) {
            BalloonTip.this.refreshLocation();
            Point tipLocation = BalloonTip.this.positioner.getTipLocation();
            boolean isWithinViewport = false;
            for (JViewport viewport : BalloonTip.this.viewportListener.viewports) {
                Rectangle view = new Rectangle(SwingUtilities.convertPoint(viewport, viewport.getLocation(), BalloonTip.this.getTopLevelContainer()), viewport.getSize());
                if (tipLocation.y >= view.y - 1 && tipLocation.y <= view.y + view.height && tipLocation.x >= view.x && tipLocation.x <= view.x + view.width) {
                    isWithinViewport = true;
                    continue;
                }
                isWithinViewport = false;
                break;
            }
            if (!this.viewports.isEmpty()) {
                BalloonTip.this.visibilityControl.setCriteriumAndUpdate("withinViewport", isWithinViewport);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttachLocation {
        ALIGNED,
        CENTER,
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        LEFT_ABOVE,
        RIGHT_ABOVE,
        LEFT_BELOW,
        RIGHT_BELOW;

    }
}

