/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.CustomBalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;

public class TablecellBalloonTip
extends CustomBalloonTip {
    protected int row;
    protected int column;
    private AncestorListener attachedComponentParentListener = null;
    private final TableColumnModelListener columnListener = new TableColumnModelListener(){

        public void columnAdded(TableColumnModelEvent e) {
            TablecellBalloonTip.this.closeBalloon();
        }

        public void columnMarginChanged(ChangeEvent e) {
            TablecellBalloonTip.this.setCellPosition(TablecellBalloonTip.this.row, TablecellBalloonTip.this.column);
        }

        public void columnMoved(TableColumnModelEvent e) {
            TablecellBalloonTip.this.closeBalloon();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            TablecellBalloonTip.this.closeBalloon();
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    };
    private final TableModelListener tableModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 1 || e.getType() == -1) {
                TablecellBalloonTip.this.closeBalloon();
            }
        }
    };

    public TablecellBalloonTip(JTable table, JComponent component, int row, int column, BalloonTipStyle style, BalloonTip.Orientation alignment, BalloonTip.AttachLocation attachLocation, int horizontalOffset, int verticalOffset, boolean useCloseButton) {
        super(table, component, table.getCellRect(row, column, true), style, alignment, attachLocation, horizontalOffset, verticalOffset, useCloseButton);
        this.setup(table, row, column);
    }

    public TablecellBalloonTip(JTable table, JComponent component, int row, int column, BalloonTipStyle style, BalloonTipPositioner positioner, JButton closeButton) {
        super(table, component, table.getCellRect(row, column, true), style, positioner, closeButton);
        this.setup(table, row, column);
    }

    public void setCellPosition(int row, int column) {
        this.offset = ((JTable)this.attachedComponent).getCellRect(row, column, true);
        this.refreshLocation();
    }

    public void closeBalloon() {
        this.attachedComponent.removeAncestorListener(this.attachedComponentParentListener);
        this.removeListeners();
        super.closeBalloon();
    }

    private void setup(JTable table, int row, int column) {
        this.row = row;
        this.column = column;
        if (this.getTopLevelContainer() != null) {
            this.addListeners();
        } else {
            this.attachedComponentParentListener = new ConstructorHelper();
            table.addAncestorListener(this.attachedComponentParentListener);
        }
    }

    private void addListeners() {
        JTable attachedTable = (JTable)this.attachedComponent;
        attachedTable.getColumnModel().addColumnModelListener(this.columnListener);
        attachedTable.getModel().addTableModelListener(this.tableModelListener);
    }

    private void removeListeners() {
        JTable attachedTable = (JTable)this.attachedComponent;
        attachedTable.getColumnModel().removeColumnModelListener(this.columnListener);
        attachedTable.getModel().removeTableModelListener(this.tableModelListener);
    }

    private class ConstructorHelper
    implements AncestorListener {
        private ConstructorHelper() {
        }

        public void ancestorAdded(AncestorEvent event) {
            TablecellBalloonTip.this.addListeners();
            TablecellBalloonTip.this.setCellPosition(TablecellBalloonTip.this.row, TablecellBalloonTip.this.column);
            ((JTable)TablecellBalloonTip.this.attachedComponent).removeAncestorListener(this);
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

