/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import net.java.balloontip.BalloonTip;

public final class FadingUtils {
    private FadingUtils() {
    }

    public static void fadeInBalloon(final BalloonTip balloon, final ActionListener onStop, final int time, int refreshRate) {
        balloon.setOpacity(0.0f);
        balloon.setVisible(true);
        final int timeDelta = 1000 / refreshRate;
        Timer timer = new Timer(timeDelta, new ActionListener(){
            int curTime = 0;

            public void actionPerformed(ActionEvent e) {
                this.curTime += timeDelta;
                float newOpacity = (float)this.curTime / (float)time;
                if (newOpacity >= 0.9999999f || Float.isNaN(newOpacity)) {
                    ((Timer)e.getSource()).stop();
                    balloon.setOpacity(0.9999999f);
                    onStop.actionPerformed(e);
                } else {
                    balloon.setOpacity(newOpacity);
                }
            }
        });
        timer.setRepeats(true);
        timer.start();
    }

    public static void fadeOutBalloon(final BalloonTip balloon, final ActionListener onStop, final int time, int refreshRate) {
        balloon.setOpacity(0.9999999f);
        balloon.setVisible(true);
        final int timeDelta = 1000 / refreshRate;
        Timer timer = new Timer(timeDelta, new ActionListener(){
            int curTime = 0;

            public void actionPerformed(ActionEvent e) {
                this.curTime += timeDelta;
                float newOpacity = -1.0f / (float)time * (float)this.curTime + 1.0f;
                if (newOpacity <= 0.0f || Float.isNaN(newOpacity)) {
                    ((Timer)e.getSource()).stop();
                    balloon.setOpacity(0.0f);
                    onStop.actionPerformed(e);
                } else {
                    balloon.setOpacity(newOpacity);
                }
            }
        });
        timer.setRepeats(true);
        timer.start();
    }
}

