/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Timer;
import net.java.balloontip.BalloonTip;

public final class ToolTipUtils {
    private ToolTipUtils() {
    }

    public static void balloonToToolTip(BalloonTip bT, int initialDelay, int showDelay) {
        bT.setVisible(false);
        bT.getAttachedComponent().addMouseListener(new ToolTipController(bT, initialDelay, showDelay));
    }

    public static void toolTipToBalloon(BalloonTip bT) {
        for (MouseListener m : bT.getAttachedComponent().getMouseListeners()) {
            if (!(m instanceof ToolTipController)) continue;
            bT.getAttachedComponent().removeMouseListener(m);
            ((ToolTipController)m).stopTimers();
            bT.setVisible(true);
            return;
        }
    }

    private static class ToolTipController
    extends MouseAdapter {
        private final BalloonTip balloonTip;
        private final Timer initialTimer;
        private final Timer showTimer;

        public ToolTipController(final BalloonTip balloonTip, int initialDelay, int showDelay) {
            this.balloonTip = balloonTip;
            this.initialTimer = new Timer(initialDelay, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    balloonTip.setVisible(true);
                    ToolTipController.this.showTimer.start();
                }
            });
            this.initialTimer.setRepeats(false);
            this.showTimer = new Timer(showDelay, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    balloonTip.setVisible(false);
                }
            });
            this.showTimer.setRepeats(false);
        }

        public void mouseEntered(MouseEvent e) {
            if (!this.balloonTip.isVisible()) {
                this.initialTimer.start();
            }
        }

        public void mouseExited(MouseEvent e) {
            this.stopTimers();
            this.balloonTip.setVisible(false);
        }

        public void mousePressed(MouseEvent e) {
            this.stopTimers();
            this.balloonTip.setVisible(false);
        }

        private void stopTimers() {
            this.initialTimer.stop();
            this.showTimer.stop();
        }
    }
}

