/*
 * Decompiled with CFR 0.152.
 */
package datechooser.autorun;

import datechooser.beans.DateChooserBean;
import datechooser.beans.customizer.DateChooserCustomizer;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ConfigBean
extends JPanel
implements PropertyChangeListener {
    public static final String OK = "ok";
    private DateChooserBean bean;
    private DateChooserCustomizer customizer;
    private File file;
    private boolean saved;

    protected ConfigBean(DateChooserBean bean, DateChooserCustomizer customizer) {
        this.setFile(null);
        this.setBean(bean);
        this.setCustomizer(customizer);
        this.getCustomizer().setObject(this.getBean());
        this.getCustomizer().addPropertyChangeListener(this);
        this.setSaved(true);
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
    }

    public String toString() {
        return this.getBeanInfo().getBeanDescriptor().getDisplayName();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setSaved(false);
        if (this.getBean() instanceof JComponent) {
            ((JComponent)((Object)this.getBean())).repaint();
        }
    }

    protected DateChooserBean getBean() {
        return this.bean;
    }

    private void setBean(DateChooserBean bean) {
        this.bean = bean;
    }

    protected DateChooserCustomizer getCustomizer() {
        return this.customizer;
    }

    private void setCustomizer(DateChooserCustomizer customizer) {
        this.customizer = customizer;
    }

    protected BeanInfo getBeanInfo() {
        return this.getCustomizer().getBeanInfo();
    }

    public String getBeanDisplayName() {
        try {
            return this.getBeanInfo().getBeanDescriptor().getDisplayName();
        }
        catch (NullPointerException ex) {
            return "?";
        }
    }

    public String writeToFile(File file) {
        this.setFile(file);
        this.setSaved(true);
        return this.getCustomizer().getHolder().writeToFile(file);
    }

    public String readFromFile(File file) {
        this.setFile(file);
        this.setSaved(true);
        return this.getCustomizer().getHolder().readFromFile(file);
    }

    public abstract String getFileExt();

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }
}

