/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view;

import datechooser.model.DateChoose;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractNavigatePane
extends JPanel
implements PropertyChangeListener {
    protected boolean editedManually;
    private DateChoose model;
    private Calendar curDate;
    protected String[] monthsList;
    private boolean localeChanged;
    private boolean nothingSelectEnabled;

    public AbstractNavigatePane() {
        this.setFont(new Font("Serif", 0, 12));
        this.editedManually = false;
        this.nothingSelectEnabled = true;
        OnShowChange listener = new OnShowChange();
        this.setLocaleChanged(true);
    }

    public abstract void applyNothingSelectEnabled(boolean var1);

    public abstract void updateMonthControl();

    public abstract int getMonth();

    public abstract int getYear();

    public abstract void setMonth(int var1);

    public abstract void setYear(int var1);

    protected void initMonthList() {
        if (!this.isLocaleChanged()) {
            return;
        }
        this.editedManually = false;
        DateFormatSymbols dateSymbols = new DateFormatSymbols(this.getLocale());
        this.monthsList = dateSymbols.getMonths();
        this.updateMonthControl();
        this.setLocaleChanged(false);
        this.editedManually = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMonthYearChanged() {
        try {
            this.editedManually = false;
            this.getModel().showMonthYear(this.getMonth(), this.getYear());
        }
        finally {
            this.refresh();
            this.editedManually = true;
        }
    }

    protected void refresh() {
        this.curDate = this.getModel().getVisibleDate();
        this.setMonth(this.curDate.get(2));
        this.setYear(this.curDate.get(1));
    }

    protected void autoRefresh() {
        this.editedManually = false;
        this.refresh();
        this.editedManually = true;
    }

    protected void manualRefresh() {
        this.editedManually = true;
        this.refresh();
    }

    protected void someChanged() {
        if (!this.editedManually) {
            return;
        }
        this.fireMonthYearChanged();
    }

    protected DateChoose getModel() {
        return this.model;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.autoRefresh();
    }

    public void setModel(DateChoose model) {
        if (this.getModel() == model) {
            return;
        }
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
        }
        this.model = model;
        model.addPropertyChangeListener(this);
        this.setEnabled(this.getModel().isEnabled());
        this.autoRefresh();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void setLocale(Locale l) {
        if (this.getLocale().equals(l)) {
            return;
        }
        super.setLocale(l);
        this.setLocaleChanged(true);
        this.initMonthList();
    }

    private boolean isLocaleChanged() {
        return this.localeChanged;
    }

    private void setLocaleChanged(boolean localeChanged) {
        this.localeChanged = localeChanged;
    }

    public boolean isNothingSelectEnabled() {
        return this.nothingSelectEnabled;
    }

    public void setNothingSelectEnabled(boolean nothingSelectEnabled) {
        this.nothingSelectEnabled = nothingSelectEnabled;
        this.applyNothingSelectEnabled(nothingSelectEnabled);
    }

    protected class OnShowChange
    implements ChangeListener,
    ActionListener {
        protected OnShowChange() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractNavigatePane.this.someChanged();
        }

        public void stateChanged(ChangeEvent e) {
            AbstractNavigatePane.this.someChanged();
        }
    }
}

