/*
 * Decompiled with CFR 0.152.
 */
package gnu.activation.viewers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class ImageViewer
extends Component
implements CommandObject {
    private Image image;

    public Dimension getPreferredSize() {
        Dimension ps = new Dimension(0, 0);
        if (this.image != null) {
            ps.width = this.image.getWidth(this);
            ps.height = this.image.getHeight(this);
        }
        return ps;
    }

    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        InputStream in = dh.getInputStream();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int len = in.read(buf);
        while (len != -1) {
            bytes.write(buf, 0, len);
            len = in.read(buf);
        }
        in.close();
        Toolkit toolkit = this.getToolkit();
        Image image = toolkit.createImage(bytes.toByteArray());
        try {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        toolkit.prepareImage(image, -1, -1, this);
    }

    public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
        if ((flags & 0x20) != 0) {
            this.image = image;
            this.invalidate();
            this.repaint();
            return false;
        }
        return (flags & 0x40) == 0;
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            Dimension is = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            if (is.width > -1 && is.height > -1) {
                Dimension cs = this.getSize();
                g.drawImage(this.image, 0, 0, cs.width, cs.height, 0, 0, is.width, is.height, this);
            }
        }
    }
}

