/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandlerDataSource;
import javax.activation.DataSource;
import javax.activation.DataSourceDataContentHandler;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.ObjectDataContentHandler;
import javax.activation.URLDataSource;
import javax.activation.UnsupportedDataTypeException;

public class DataHandler
implements Transferable {
    private static final DataFlavor[] NO_FLAVORS = new DataFlavor[0];
    private static DataContentHandlerFactory factory = null;
    private DataSource dataSource;
    private DataSource objDataSource;
    private Object object;
    private String objectMimeType;
    private CommandMap currentCommandMap;
    private DataFlavor[] transferFlavors = NO_FLAVORS;
    private DataContentHandler dataContentHandler;
    private DataContentHandler factoryDCH;
    private DataContentHandlerFactory oldFactory;
    private String shortType;
    static /* synthetic */ Class class$0;

    public DataHandler(DataSource ds) {
        this.dataSource = ds;
        this.oldFactory = factory;
    }

    public DataHandler(Object obj, String mimeType) {
        this.object = obj;
        this.objectMimeType = mimeType;
        this.oldFactory = factory;
    }

    public DataHandler(URL url) {
        this.dataSource = new URLDataSource(url);
        this.oldFactory = factory;
    }

    public DataSource getDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.objDataSource == null) {
            this.objDataSource = new DataHandlerDataSource(this);
        }
        return this.objDataSource;
    }

    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.objectMimeType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataSource != null) {
            return this.dataSource.getInputStream();
        }
        DataContentHandler dch = this.getDataContentHandler();
        if (dch == null) {
            throw new UnsupportedDataTypeException("no DCH for MIME type " + this.getShortType());
        }
        if (dch instanceof ObjectDataContentHandler && ((ObjectDataContentHandler)dch).getDCH() == null) {
            throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.getShortType());
        }
        PipedOutputStream pos = new PipedOutputStream();
        DataContentHandlerWriter dchw = new DataContentHandlerWriter(dch, this.object, this.objectMimeType, pos);
        Thread thread = new Thread((Runnable)dchw, "DataHandler.getInputStream");
        thread.start();
        return new PipedInputStream(pos);
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.dataSource != null) {
            InputStream in = this.dataSource.getInputStream();
            byte[] buf = new byte[8192];
            int len = in.read(buf);
            while (len != -1) {
                os.write(buf, 0, len);
                len = in.read(buf);
            }
            in.close();
        } else {
            DataContentHandler dch = this.getDataContentHandler();
            dch.writeTo(this.object, this.objectMimeType, os);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dataSource != null) {
            return this.dataSource.getOutputStream();
        }
        return null;
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        if (factory != this.oldFactory || this.transferFlavors == NO_FLAVORS) {
            DataContentHandler dch = this.getDataContentHandler();
            this.transferFlavors = dch.getTransferDataFlavors();
        }
        return this.transferFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        DataContentHandler dch = this.getDataContentHandler();
        return dch.getTransferData(flavor, this.dataSource);
    }

    public synchronized void setCommandMap(CommandMap commandMap) {
        if (commandMap != this.currentCommandMap || commandMap == null) {
            this.transferFlavors = NO_FLAVORS;
            this.dataContentHandler = null;
            this.currentCommandMap = commandMap;
        }
    }

    public CommandInfo[] getPreferredCommands() {
        CommandMap commandMap = this.getCommandMap();
        return commandMap.getPreferredCommands(this.getShortType());
    }

    public CommandInfo[] getAllCommands() {
        CommandMap commandMap = this.getCommandMap();
        return commandMap.getAllCommands(this.getShortType());
    }

    public CommandInfo getCommand(String cmdName) {
        CommandMap commandMap = this.getCommandMap();
        return commandMap.getCommand(this.getShortType(), cmdName);
    }

    public Object getContent() throws IOException {
        DataContentHandler dch = this.getDataContentHandler();
        return dch.getContent(this.getDataSource());
    }

    public Object getBean(CommandInfo cmdInfo) {
        try {
            return cmdInfo.getCommandObject(this, this.getClass().getClassLoader());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static synchronized void setDataContentHandlerFactory(DataContentHandlerFactory newFactory) {
        block7: {
            if (factory != null) {
                throw new Error("DataContentHandlerFactory already defined");
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                try {
                    security.checkSetFactory();
                }
                catch (SecurityException e) {
                    if (newFactory == null) break block7;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("javax.activation.DataHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.getClassLoader() == newFactory.getClass().getClassLoader()) break block7;
                    throw e;
                }
            }
        }
        factory = newFactory;
    }

    private synchronized String getShortType() {
        if (this.shortType == null) {
            String contentType = this.getContentType();
            try {
                MimeType mimeType = new MimeType(contentType);
                this.shortType = mimeType.getBaseType();
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                this.shortType = contentType;
            }
        }
        return this.shortType;
    }

    private synchronized CommandMap getCommandMap() {
        if (this.currentCommandMap != null) {
            return this.currentCommandMap;
        }
        return CommandMap.getDefaultCommandMap();
    }

    private synchronized DataContentHandler getDataContentHandler() {
        if (factory != this.oldFactory) {
            this.oldFactory = factory;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = NO_FLAVORS;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        String mimeType = this.getShortType();
        if (this.factoryDCH == null && factory != null) {
            this.factoryDCH = factory.createDataContentHandler(mimeType);
        }
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            CommandMap commandMap = this.getCommandMap();
            this.dataContentHandler = commandMap.createDataContentHandler(mimeType);
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    static class DataContentHandlerWriter
    implements Runnable {
        DataContentHandler dch;
        Object object;
        String mimeType;
        OutputStream out;

        DataContentHandlerWriter(DataContentHandler dch, Object object, String mimeType, OutputStream out) {
            this.dch = dch;
            this.object = object;
            this.mimeType = mimeType;
            this.out = out;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.dch.writeTo(this.object, this.mimeType, this.out);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                try {
                    this.out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            this.out.close();
        }
    }
}

