/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;

public class MailcapCommandMap
extends CommandMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static boolean debug = false;
    private Map[] mailcaps;

    static {
        try {
            String d = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(d);
        }
        catch (SecurityException securityException) {}
    }

    public MailcapCommandMap() {
        this.init(null);
    }

    public MailcapCommandMap(String fileName) throws IOException {
        FileReader in = null;
        try {
            in = new FileReader(fileName);
        }
        catch (IOException iOException) {}
        this.init(in);
        if (in != null) {
            try {
                ((Reader)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    public MailcapCommandMap(InputStream is) {
        this.init(new InputStreamReader(is));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(Reader in) {
        block29: {
            block28: {
                block26: {
                    this.mailcaps = new Map[5];
                    i = 0;
                    while (true) {
                        if (i >= this.mailcaps.length) {
                            if (in != null) {
                                if (MailcapCommandMap.debug) {
                                    System.out.println("MailcapCommandMap: load PROG");
                                }
                                ** try [egrp 0[TRYBLOCK] [0 : 56->70)] { 
lbl9:
                                // 1 sources

                                break;
                            }
                            break block26;
                        }
                        this.mailcaps[i] = new HashMap<K, V>();
                        ++i;
                    }
                    {
                        this.parse(this.mailcaps[0], in);
                    }
lbl16:
                    // 1 sources

                    catch (IOException v0) {}
                }
                if (MailcapCommandMap.debug) {
                    System.out.println("MailcapCommandMap: load HOME");
                }
                try {
                    home = System.getProperty("user.home");
                    if (home != null) {
                        this.parseFile(this.mailcaps[1], home + File.separatorChar + ".mailcap");
                    }
                }
                catch (SecurityException v1) {}
                if (MailcapCommandMap.debug) {
                    System.out.println("MailcapCommandMap: load SYS");
                }
                try {
                    this.parseFile(this.mailcaps[2], System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + "mailcap");
                }
                catch (SecurityException v2) {}
                if (MailcapCommandMap.debug) {
                    System.out.println("MailcapCommandMap: load JAR");
                }
                if ((len = (systemResources = this.getSystemResources("META-INF/mailcap")).size()) <= 0) break block28;
                i = 0;
                while (i < len) {
                    block27: {
                        urlIn = null;
                        url = (URL)systemResources.get(i);
                        try {
                            try {
                                if (MailcapCommandMap.debug) {
                                    System.out.println("\t" + url.toString());
                                }
                                urlIn = new InputStreamReader(url.openStream());
                                this.parse(this.mailcaps[3], urlIn);
                            }
                            catch (IOException e) {
                                if (MailcapCommandMap.debug) {
                                    System.out.println(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
                                }
                            }
                        }
                        catch (Throwable var9_11) {
                            var8_10 = null;
                            if (urlIn == null) throw var9_11;
                            try {
                                urlIn.close();
                                throw var9_11;
                            }
                            catch (IOException v3) {}
                            throw var9_11;
                        }
                        {
                            var8_10 = null;
                            if (urlIn == null) break block27;
                        }
                        try {}
                        catch (IOException v4) {}
                        urlIn.close();
                    }
                    ++i;
                }
                break block29;
            }
            this.parseResource(this.mailcaps[3], "/META-INF/mailcap");
        }
        if (MailcapCommandMap.debug) {
            System.out.println("MailcapCommandMap: load DEF");
        }
        this.parseResource(this.mailcaps[4], "/META-INF/mailcap.default");
    }

    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        ArrayList<String> verbList = new ArrayList<String>();
        int i = 0;
        while (i < this.mailcaps.length) {
            Map map = this.getCommands(this.mailcaps[i], mimeType);
            if (map != null) {
                Iterator j = map.keySet().iterator();
                while (j.hasNext()) {
                    String verb = (String)j.next();
                    if (verbList.contains(verb)) continue;
                    List classNames = (List)map.get(verb);
                    String className = (String)classNames.get(0);
                    CommandInfo cmd = new CommandInfo(verb, className);
                    cmdList.add(cmd);
                    verbList.add(verb);
                }
            }
            ++i;
        }
        CommandInfo[] cmds = new CommandInfo[cmdList.size()];
        cmdList.toArray(cmds);
        return cmds;
    }

    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        int i = 0;
        while (i < this.mailcaps.length) {
            Map map = this.getCommands(this.mailcaps[i], mimeType);
            if (map != null) {
                Iterator j = map.keySet().iterator();
                while (j.hasNext()) {
                    String verb = (String)j.next();
                    List classNames = (List)map.get(verb);
                    int len = classNames.size();
                    int k = 0;
                    while (k < len) {
                        String className = (String)classNames.get(k);
                        CommandInfo cmd = new CommandInfo(verb, className);
                        cmdList.add(cmd);
                        ++k;
                    }
                }
            }
            ++i;
        }
        CommandInfo[] cmds = new CommandInfo[cmdList.size()];
        cmdList.toArray(cmds);
        return cmds;
    }

    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        int i = 0;
        while (i < this.mailcaps.length) {
            Map map = this.getCommands(this.mailcaps[i], mimeType);
            if (map != null) {
                List classNames = (List)map.get(cmdName);
                if (classNames == null) {
                    classNames = (List)map.get("x-java-" + cmdName);
                }
                if (classNames != null) {
                    String className = (String)classNames.get(0);
                    return new CommandInfo(cmdName, className);
                }
            }
            ++i;
        }
        return null;
    }

    public synchronized void addMailcap(String mail_cap) {
        if (debug) {
            System.out.println("MailcapCommandMap: add to PROG");
        }
        try {
            this.parse(this.mailcaps[0], new StringReader(mail_cap));
        }
        catch (IOException iOException) {}
    }

    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        if (debug) {
            System.out.println("MailcapCommandMap: createDataContentHandler for " + mimeType);
        }
        int i = 0;
        while (i < this.mailcaps.length) {
            block13: {
                Map map;
                if (debug) {
                    System.out.println("  search DB #" + i);
                }
                if ((map = this.getCommands(this.mailcaps[i], mimeType)) != null) {
                    List classNames = (List)map.get("content-handler");
                    if (classNames == null) {
                        classNames = (List)map.get("x-java-content-handler");
                    }
                    if (classNames != null) {
                        String className = (String)classNames.get(0);
                        if (debug) {
                            System.out.println("  In " + MailcapCommandMap.nameOf(i) + ", content-handler=" + className);
                        }
                        try {
                            Class<?> clazz = Class.forName(className);
                            return (DataContentHandler)clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            if (debug) {
                                e.printStackTrace();
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (debug) {
                                e.printStackTrace();
                            }
                        }
                        catch (InstantiationException e) {
                            if (!debug) break block13;
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static String nameOf(int mailcap) {
        switch (mailcap) {
            case 0: {
                return "PROG";
            }
            case 1: {
                return "HOME";
            }
            case 2: {
                return "SYS";
            }
            case 3: {
                return "JAR";
            }
            case 4: {
                return "DEF";
            }
        }
        return "ERR";
    }

    /*
     * Exception decompiling
     */
    private void parseFile(Map mailcap, String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 123->127)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void parseResource(Map mailcap, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 139->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parse(Map mailcap, Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        StringBuffer buf = null;
        String line = br.readLine();
        while (line != null) {
            int len = (line = line.trim()).length();
            if (len != 0 && line.charAt(0) != '#') {
                if (line.charAt(len - 1) == '\\') {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(line.substring(0, len - 1));
                } else if (buf != null) {
                    buf.append(line);
                    this.parseEntry(mailcap, buf.toString());
                    buf = null;
                } else {
                    this.parseEntry(mailcap, line);
                }
            }
            line = br.readLine();
        }
    }

    private void parseEntry(Map mailcap, String line) {
        char[] chars = line.toCharArray();
        int len = chars.length;
        boolean inQuotedString = false;
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> fields = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            char c = chars[i];
            if (c == '\\') {
                c = chars[++i];
            }
            if (c == ';' && !inQuotedString) {
                fields.add(buffer.toString().trim());
                buffer.setLength(0);
            } else {
                if (c == '\"') {
                    inQuotedString = !inQuotedString;
                }
                buffer.append(c);
            }
            ++i;
        }
        fields.add(buffer.toString().trim());
        len = fields.size();
        if (len < 2) {
            if (debug) {
                System.err.println("Invalid mailcap entry: " + line);
            }
            return;
        }
        String mimeType = (String)fields.get(0);
        this.addField(mailcap, mimeType, "view-command", (String)fields.get(1));
        int i2 = 2;
        while (i2 < len) {
            this.addField(mailcap, mimeType, null, (String)fields.get(i2));
            ++i2;
        }
    }

    private void addField(Map mailcap, String mimeType, String verb, String command) {
        ArrayList<String> classNames;
        int ei;
        if (verb == null && (ei = command.indexOf(61)) != -1) {
            verb = command.substring(0, ei);
            command = command.substring(ei + 1);
        }
        if (command.length() == 0 || verb == null || verb.length() == 0) {
            return;
        }
        HashMap<String, ArrayList<String>> commands = (HashMap<String, ArrayList<String>>)mailcap.get(mimeType);
        if (commands == null) {
            commands = new HashMap<String, ArrayList<String>>();
            mailcap.put(mimeType, commands);
        }
        if ((classNames = (ArrayList<String>)commands.get(verb)) == null) {
            classNames = new ArrayList<String>();
            commands.put(verb, classNames);
        }
        classNames.add(command);
    }

    private Map getCommands(Map mailcap, String mimeType) {
        int si = mimeType.indexOf(47);
        String genericMimeType = mimeType.substring(0, si) + '/' + '*';
        Map specific = (Map)mailcap.get(mimeType);
        Map generic = (Map)mailcap.get(genericMimeType);
        if (generic == null) {
            return specific;
        }
        if (specific == null) {
            return generic;
        }
        HashMap<String, List> combined = new HashMap<String, List>();
        combined.putAll(specific);
        Iterator i = generic.keySet().iterator();
        while (i.hasNext()) {
            String verb = (String)i.next();
            List genericClassNames = (List)generic.get(verb);
            List classNames = (List)combined.get(verb);
            if (classNames == null) {
                combined.put(verb, genericClassNames);
                continue;
            }
            classNames.addAll(genericClassNames);
        }
        return combined;
    }

    private List getSystemResources(String name) {
        ArrayList<URL> acc = new ArrayList<URL>();
        try {
            Enumeration<URL> i = ClassLoader.getSystemResources(name);
            while (i.hasMoreElements()) {
                acc.add(i.nextElement());
            }
        }
        catch (IOException iOException) {}
        return acc;
    }
}

