/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;

public class MimeType
implements Externalizable {
    static final String TSPECIALS = "()<>@,;:/[]?=\\\"";
    private String primaryType;
    private String subType;
    private MimeTypeParameterList parameters;

    public MimeType() {
        this.primaryType = "application";
        this.subType = "*";
        this.parameters = new MimeTypeParameterList();
    }

    public MimeType(String rawdata) throws MimeTypeParseException {
        this.parse(rawdata);
    }

    public MimeType(String primary, String sub) throws MimeTypeParseException {
        MimeType.checkValidity(primary, "Primary type is invalid");
        MimeType.checkValidity(sub, "Sub type is invalid");
        this.primaryType = primary.toLowerCase();
        this.subType = sub.toLowerCase();
        this.parameters = new MimeTypeParameterList();
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String primary) throws MimeTypeParseException {
        MimeType.checkValidity(primary, "Primary type is invalid");
        this.primaryType = primary.toLowerCase();
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String sub) throws MimeTypeParseException {
        MimeType.checkValidity(sub, "Sub type is invalid");
        this.subType = sub.toLowerCase();
    }

    public MimeTypeParameterList getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.set(name, value);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public String toString() {
        return this.primaryType + '/' + this.subType + this.parameters.toString();
    }

    public String getBaseType() {
        return this.primaryType + '/' + this.subType;
    }

    public boolean match(MimeType type) {
        String primary2 = type.getPrimaryType();
        String sub2 = type.getSubType();
        return this.primaryType.equals(primary2) && (this.subType.equals(sub2) || "*".equals(this.subType) || "*".equals(sub2));
    }

    public boolean match(String rawdata) throws MimeTypeParseException {
        return this.match(new MimeType(rawdata));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.toString());
        out.flush();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.parse(in.readUTF());
        }
        catch (MimeTypeParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void parse(String rawdata) throws MimeTypeParseException {
        int si = rawdata.indexOf(47);
        int pi = rawdata.indexOf(59);
        if (si == -1) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (pi == -1) {
            this.primaryType = rawdata.substring(0, si).toLowerCase().trim();
            this.subType = rawdata.substring(si + 1).toLowerCase().trim();
            this.parameters = new MimeTypeParameterList();
        } else if (si < pi) {
            this.primaryType = rawdata.substring(0, si).toLowerCase().trim();
            this.subType = rawdata.substring(si + 1, pi).toLowerCase().trim();
            this.parameters = new MimeTypeParameterList(rawdata.substring(pi));
        } else {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        MimeType.checkValidity(this.primaryType, "Primary type is invalid");
        MimeType.checkValidity(this.subType, "Sub type is invalid");
    }

    static void checkValidity(String token, String message) throws MimeTypeParseException {
        int len = token.length();
        if (len == 0) {
            throw new MimeTypeParseException(message, token);
        }
        int i = 0;
        while (i < len) {
            char c = token.charAt(i);
            if (!MimeType.isValidChar(c)) {
                throw new MimeTypeParseException(message, token);
            }
            ++i;
        }
    }

    static boolean isValidChar(char c) {
        return c > ' ' && c <= '~' && TSPECIALS.indexOf(c) == -1;
    }
}

