/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";
    private List parameterNames = new ArrayList();
    private Map parameterValues = new HashMap();

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this.parse(parameterList);
    }

    protected void parse(String parameterList) throws MimeTypeParseException {
        if (parameterList == null) {
            return;
        }
        char[] chars = parameterList.toCharArray();
        int len = chars.length;
        boolean inQuotedString = false;
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            char c = chars[i];
            if (c == ';' && !inQuotedString) {
                String param = buffer.toString().trim();
                if (param.length() > 0) {
                    params.add(param);
                }
                buffer.setLength(0);
            } else {
                if (c == '\"') {
                    inQuotedString = !inQuotedString;
                }
                buffer.append(c);
            }
            ++i;
        }
        String param = buffer.toString().trim();
        if (param.length() > 0) {
            params.add(param);
        }
        Iterator i2 = params.iterator();
        while (i2.hasNext()) {
            param = (String)i2.next();
            int ei = param.indexOf(61);
            if (ei == -1) {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            String name = param.substring(0, ei).trim();
            MimeType.checkValidity(name, "Parameter name is invalid");
            String value = param.substring(ei + 1).trim();
            len = value.length();
            if (len > 1 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
                value = MimeTypeParameterList.unquote(value);
            } else {
                MimeType.checkValidity(name, "Parameter value is invalid");
            }
            this.parameterNames.add(name);
            this.parameterValues.put(name.toLowerCase(), value);
        }
    }

    public synchronized int size() {
        return this.parameterNames.size();
    }

    public synchronized boolean isEmpty() {
        return this.parameterNames.isEmpty();
    }

    public synchronized String get(String name) {
        name = name.trim();
        return (String)this.parameterValues.get(name.toLowerCase());
    }

    public synchronized void set(String name, String value) {
        name = name.trim();
        boolean exists = false;
        Iterator i = this.parameterNames.iterator();
        while (i.hasNext()) {
            String pname = (String)i.next();
            if (!name.equalsIgnoreCase(pname)) continue;
            exists = true;
        }
        if (!exists) {
            this.parameterNames.add(name);
        }
        this.parameterValues.put(name.toLowerCase(), value);
    }

    public synchronized void remove(String name) {
        name = name.trim();
        Iterator i = this.parameterNames.iterator();
        while (i.hasNext()) {
            String pname = (String)i.next();
            if (!name.equalsIgnoreCase(pname)) continue;
            i.remove();
        }
        this.parameterValues.remove(name.toLowerCase());
    }

    public synchronized Enumeration getNames() {
        return new IteratorEnumeration(this.parameterNames.iterator());
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.parameterNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)this.parameterValues.get(name.toLowerCase());
            if (buffer.length() > 0) {
                buffer.append(';');
                buffer.append(' ');
            }
            buffer.append(name);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote(value));
        }
        return buffer.toString();
    }

    private static String quote(String value) {
        boolean needsQuoting = false;
        int len = value.length();
        int i = 0;
        while (i < len) {
            if (!MimeType.isValidChar(value.charAt(i))) {
                needsQuoting = true;
                break;
            }
            ++i;
        }
        if (needsQuoting) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('\"');
            int i2 = 0;
            while (i2 < len) {
                char c = value.charAt(i2);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
                ++i2;
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value;
    }

    private static String unquote(String value) {
        int len = value.length();
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        while (i < len - 1) {
            char c = value.charAt(i);
            if (c == '\\' && ++i < len - 1 && (c = value.charAt(i)) != '\\' && c != '\"') {
                buffer.append('\\');
            }
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    static class IteratorEnumeration
    implements Enumeration {
        final Iterator iterator;

        IteratorEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

