/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import com.jcraft.jsch.Channel;
import expectj.Executor;
import expectj.ProcessSpawn;
import expectj.Spawn;
import expectj.Spawnable;
import expectj.SshSpawn;
import expectj.TelnetSpawn;
import java.io.IOException;

public class ExpectJ {
    private long m_lDefaultTimeOutSeconds = -1L;

    public ExpectJ(long defaultTimeoutSeconds) {
        this.m_lDefaultTimeOutSeconds = defaultTimeoutSeconds;
    }

    public ExpectJ() {
    }

    public Spawn spawn(Spawnable spawnable) throws IOException {
        return new Spawn(spawnable, this.m_lDefaultTimeOutSeconds);
    }

    public Spawn spawn(final String command) throws IOException {
        return this.spawn(new ProcessSpawn(new Executor(){

            public Process execute() throws IOException {
                return Runtime.getRuntime().exec(command);
            }

            public String toString() {
                return command;
            }
        }));
    }

    public Spawn spawn(Executor executor) throws IOException {
        return this.spawn(new ProcessSpawn(executor));
    }

    public Spawn spawn(String hostName, int port) throws IOException {
        return this.spawn(new TelnetSpawn(hostName, port));
    }

    public Spawn spawn(Channel channel) throws IOException {
        return this.spawn(new SshSpawn(channel));
    }

    public Spawn spawn(String remoteHostName, int remotePort, String userName, String password) throws IOException {
        return this.spawn(new SshSpawn(remoteHostName, remotePort, userName, password));
    }
}

