/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import expectj.AbstractSpawnable;
import expectj.Executor;
import expectj.ExpectJException;
import expectj.Spawnable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessSpawn
extends AbstractSpawnable
implements Spawnable {
    private static final Log LOG = LogFactory.getLog(ProcessSpawn.class);
    private ProcessThread processThread = null;

    ProcessSpawn(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("Executor is null, must get something to run");
        }
        this.processThread = new ProcessThread(executor);
    }

    public void stop() {
        this.processThread.stop();
    }

    public void start() throws IOException {
        this.processThread.start();
    }

    public InputStream getStdout() {
        return this.processThread.process.getInputStream();
    }

    public OutputStream getStdin() {
        return this.processThread.process.getOutputStream();
    }

    public InputStream getStderr() {
        return this.processThread.process.getErrorStream();
    }

    public boolean isClosed() {
        return this.processThread.isClosed;
    }

    public int getExitValue() throws ExpectJException {
        if (!this.isClosed()) {
            throw new ExpectJException("Process is still running");
        }
        return this.processThread.exitValue;
    }

    class ProcessThread
    implements Runnable {
        private Process process = null;
        private Thread thread = null;
        private volatile boolean isClosed = false;
        private int exitValue;
        private Executor executor;

        public ProcessThread(Executor executor) {
            this.executor = executor;
        }

        public void start() throws IOException {
            LOG.debug("Starting process '" + this.executor + "'");
            this.thread = new Thread((Runnable)this, "ExpectJ: " + this.executor);
            this.process = this.executor.execute();
            this.thread.start();
        }

        public void run() {
            try {
                this.process.waitFor();
                this.exitValue = this.process.exitValue();
                this.isClosed = true;
                ProcessSpawn.this.onClose();
            }
            catch (Exception e) {
                LOG.error("Failed waiting for process termination", e);
            }
        }

        public void stop() {
            LOG.debug("Process '" + this.executor + "' killed");
            this.process.destroy();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted waiting for process supervisor thread to finish", e);
            }
        }
    }
}

