/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import expectj.ExpectJException;
import expectj.ProcessSpawn;
import expectj.Spawnable;
import expectj.SpawnableHelper;
import expectj.StreamPiper;
import expectj.TimeoutException;
import expectj.Timer;
import expectj.TimerEventListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.Selector;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Spawn {
    private static final Log LOG = LogFactory.getLog(ProcessSpawn.class);
    private long m_lDefaultTimeOutSeconds = -1L;
    private BufferedWriter toStdin = null;
    private SpawnableHelper slave = null;
    private volatile boolean continueReading = true;
    private StreamPiper interactIn = null;
    private StreamPiper interactOut = null;
    private StreamPiper interactErr = null;
    private Selector stdoutSelector;
    private Selector stderrSelector;
    private final Object doneWaitingForClose = new Object();

    Spawn(Spawnable spawn, long lDefaultTimeOutSeconds) throws IOException {
        if (lDefaultTimeOutSeconds < -1L) {
            throw new IllegalArgumentException("Timeout must be >= -1, was " + lDefaultTimeOutSeconds);
        }
        this.m_lDefaultTimeOutSeconds = lDefaultTimeOutSeconds;
        this.slave = new SpawnableHelper(spawn, lDefaultTimeOutSeconds);
        this.slave.start();
        LOG.debug("Spawned Process: " + spawn);
        if (this.slave.getStdin() != null) {
            this.toStdin = new BufferedWriter(new OutputStreamWriter(this.slave.getStdin()));
        }
        this.stdoutSelector = Selector.open();
        this.slave.getStdoutChannel().register(this.stdoutSelector, 1);
        if (this.slave.getStderrChannel() != null) {
            this.stderrSelector = Selector.open();
            this.slave.getStderrChannel().register(this.stderrSelector, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void timerTimedOut() {
        this.continueReading = false;
        this.stdoutSelector.wakeup();
        if (this.stderrSelector != null) {
            this.stderrSelector.wakeup();
        }
        Object object = this.doneWaitingForClose;
        synchronized (object) {
            this.doneWaitingForClose.notify();
        }
    }

    private void timerInterrupted(InterruptedException reason) {
        this.timerTimedOut();
    }

    public void expect(String pattern, long timeOutSeconds) throws IOException, TimeoutException {
        this.expect(pattern, timeOutSeconds, this.stdoutSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expectClose(long timeOutSeconds) throws TimeoutException, ExpectJException {
        if (timeOutSeconds < -1L) {
            throw new IllegalArgumentException("Timeout must be >= -1, was " + timeOutSeconds);
        }
        LOG.debug("Waiting for spawn to close connection...");
        Timer tm = null;
        this.slave.setCloseListener(new Spawnable.CloseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClose() {
                Object object = Spawn.this.doneWaitingForClose;
                synchronized (object) {
                    Spawn.this.doneWaitingForClose.notify();
                }
            }
        });
        if (timeOutSeconds != -1L) {
            tm = new Timer(timeOutSeconds, new TimerEventListener(){

                public void timerTimedOut() {
                    Spawn.this.timerTimedOut();
                }

                public void timerInterrupted(InterruptedException reason) {
                    Spawn.this.timerInterrupted(reason);
                }
            });
            tm.startTimer();
        }
        this.continueReading = true;
        boolean closed = false;
        Object object = this.doneWaitingForClose;
        synchronized (object) {
            while (this.continueReading) {
                if (this.slave.isClosed()) {
                    closed = true;
                    break;
                }
                try {
                    this.doneWaitingForClose.wait(500L);
                }
                catch (InterruptedException e) {
                    throw new ExpectJException("Interrupted waiting for spawn to finish", e);
                }
            }
        }
        if (tm != null) {
            tm.close();
        }
        if (closed) {
            LOG.debug("Connection to spawn closed, continueReading=" + this.continueReading);
        } else {
            LOG.debug("Timed out waiting for spawn to close, continueReading=" + this.continueReading);
        }
        if (tm != null) {
            LOG.debug("Timer Status:" + tm.getStatus());
        }
        if (!this.continueReading) {
            throw new TimeoutException("Timeout waiting for spawn to finish");
        }
        this.freeResources();
    }

    private void freeResources() {
        try {
            this.slave.close();
            if (this.interactIn != null) {
                this.interactIn.stopProcessing();
            }
            if (this.interactOut != null) {
                this.interactOut.stopProcessing();
            }
            if (this.interactErr != null) {
                this.interactErr.stopProcessing();
            }
            if (this.stderrSelector != null) {
                this.stderrSelector.close();
            }
            if (this.stdoutSelector != null) {
                this.stdoutSelector.close();
            }
            if (this.toStdin != null) {
                this.toStdin.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Failed cleaning up after spawn done", e);
        }
    }

    public void expectClose() throws ExpectJException, TimeoutException {
        this.expectClose(this.m_lDefaultTimeOutSeconds);
    }

    private void expect(String pattern, long lTimeOutSeconds, Selector selector) throws IOException, TimeoutException {
        if (lTimeOutSeconds < -1L) {
            throw new IllegalArgumentException("Timeout must be >= -1, was " + lTimeOutSeconds);
        }
        if (selector.keys().size() != 1) {
            throw new IllegalArgumentException("Selector key set size must be 1, was " + selector.keys().size());
        }
        Pipe.SourceChannel readMe = (Pipe.SourceChannel)selector.keys().iterator().next().channel();
        LOG.debug("Expecting '" + pattern + "'");
        this.continueReading = true;
        boolean found = false;
        StringBuilder line = new StringBuilder();
        Date runUntil = null;
        if (lTimeOutSeconds > 0L) {
            runUntil = new Date(new Date().getTime() + lTimeOutSeconds * 1000L);
        }
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (this.continueReading) {
            if (runUntil == null) {
                selector.select();
            } else {
                long msLeft = runUntil.getTime() - new Date().getTime();
                if (msLeft > 0L) {
                    selector.select(msLeft);
                } else {
                    this.continueReading = false;
                    break;
                }
            }
            if (selector.selectedKeys().size() == 0) continue;
            buffer.rewind();
            if (readMe.read(buffer) == -1) {
                throw new IOException("End of stream reached, no match found");
            }
            buffer.rewind();
            for (int i = 0; i < buffer.limit(); ++i) {
                line.append((char)buffer.get(i));
            }
            if (line.toString().trim().toUpperCase().indexOf(pattern.toUpperCase()) != -1) {
                LOG.debug("Found match for " + pattern + ":" + line);
                found = true;
                break;
            }
            while (line.indexOf("\n") != -1) {
                line.delete(0, line.indexOf("\n") + 1);
            }
        }
        if (found) {
            LOG.debug("Match found, continueReading=" + this.continueReading);
        } else {
            LOG.debug("Timed out waiting for match, continueReading=" + this.continueReading);
        }
        if (!this.continueReading) {
            throw new TimeoutException("Timeout trying to match \"" + pattern + "\"");
        }
    }

    public void expectErr(String pattern, long timeOutSeconds) throws IOException, TimeoutException {
        this.expect(pattern, timeOutSeconds, this.stderrSelector);
    }

    public void expect(String pattern) throws IOException, TimeoutException {
        this.expect(pattern, this.m_lDefaultTimeOutSeconds);
    }

    public void expectErr(String pattern) throws IOException, TimeoutException {
        this.expectErr(pattern, this.m_lDefaultTimeOutSeconds);
    }

    public boolean isClosed() {
        return this.slave.isClosed();
    }

    public int getExitValue() throws ExpectJException {
        return this.slave.getExitValue();
    }

    public void send(String string) throws IOException {
        LOG.debug("Sending '" + string + "'");
        this.toStdin.write(string);
        this.toStdin.flush();
    }

    public void interact() {
        this.interactIn = new StreamPiper(null, System.in, this.slave.getStdin());
        this.interactIn.start();
        this.interactOut = new StreamPiper(null, Channels.newInputStream(this.slave.getStdoutChannel()), System.out);
        this.interactOut.start();
        this.interactErr = new StreamPiper(null, Channels.newInputStream(this.slave.getStderrChannel()), System.err);
        this.interactErr.start();
        this.slave.stopPipingToStandardOut();
    }

    public void stop() {
        this.slave.stop();
        this.freeResources();
    }

    public String getCurrentStandardOutContents() {
        return this.slave.getCurrentStandardOutContents();
    }

    public String getCurrentStandardErrContents() {
        return this.slave.getCurrentStandardErrContents();
    }
}

