/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import expectj.ExpectJException;
import expectj.Spawnable;
import expectj.StreamPiper;
import expectj.Timer;
import expectj.TimerEventListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SpawnableHelper
implements TimerEventListener {
    private static final Log LOG = LogFactory.getLog(SpawnableHelper.class);
    private Spawnable spawnable;
    private Timer timer = null;
    private Pipe systemOut;
    private Pipe systemErr;
    private StreamPiper spawnOutToSystemOut = null;
    private StreamPiper spawnErrToSystemErr = null;

    SpawnableHelper(Spawnable runMe, long timeOutSeconds) {
        if (timeOutSeconds < -1L) {
            throw new IllegalArgumentException("Time-out is invalid");
        }
        if (timeOutSeconds != -1L) {
            this.timer = new Timer(timeOutSeconds, this);
        }
        this.spawnable = runMe;
    }

    SpawnableHelper(Spawnable runMe) {
        this(runMe, -1L);
    }

    public void timerTimedOut() {
        this.stop();
    }

    void stop() {
        this.spawnOutToSystemOut.stopProcessing();
        if (this.spawnErrToSystemErr != null) {
            this.spawnErrToSystemErr.stopProcessing();
        }
        this.spawnable.stop();
        this.close();
    }

    public void timerInterrupted(InterruptedException reason) {
        LOG.error("Timer interrupted", reason);
    }

    synchronized void stopPipingToStandardOut() {
        this.spawnOutToSystemOut.stopPipingToStandardOut();
        if (this.spawnErrToSystemErr != null) {
            this.spawnErrToSystemErr.stopPipingToStandardOut();
        }
    }

    synchronized void startPipingToStandardOut() {
        this.spawnOutToSystemOut.startPipingToStandardOut();
        if (this.spawnErrToSystemErr != null) {
            this.spawnErrToSystemErr.startPipingToStandardOut();
        }
    }

    void start() throws IOException {
        this.spawnable.start();
        if (this.timer != null) {
            this.timer.startTimer();
        }
        this.systemOut = Pipe.open();
        this.systemOut.source().configureBlocking(false);
        this.spawnOutToSystemOut = new StreamPiper(System.out, this.spawnable.getStdout(), Channels.newOutputStream(this.systemOut.sink()));
        this.spawnOutToSystemOut.start();
        if (this.spawnable.getStderr() != null) {
            this.systemErr = Pipe.open();
            this.systemErr.source().configureBlocking(false);
            this.spawnErrToSystemErr = new StreamPiper(System.err, this.spawnable.getStderr(), Channels.newOutputStream(this.systemErr.sink()));
            this.spawnErrToSystemErr.start();
        }
    }

    void close() {
        if (this.spawnErrToSystemErr != null) {
            this.spawnErrToSystemErr.stopProcessing();
        }
        if (this.spawnOutToSystemOut != null) {
            this.spawnOutToSystemOut.stopProcessing();
        }
        if (this.systemOut != null) {
            try {
                this.systemOut.sink().close();
            }
            catch (IOException e) {
                LOG.warn("Closing stdout sink failed", e);
            }
            try {
                this.systemOut.source().close();
            }
            catch (IOException e) {
                LOG.warn("Closing stdout source failed", e);
            }
        }
        if (this.systemErr != null) {
            try {
                this.systemErr.sink().close();
            }
            catch (IOException e) {
                LOG.warn("Closing stderr sink failed", e);
            }
            try {
                this.systemErr.source().close();
            }
            catch (IOException e) {
                LOG.warn("Closing stderr source failed", e);
            }
        }
    }

    Pipe.SourceChannel getStdoutChannel() {
        return this.systemOut.source();
    }

    OutputStream getStdin() {
        return this.spawnable.getStdin();
    }

    Pipe.SourceChannel getStderrChannel() {
        if (this.systemErr == null) {
            return null;
        }
        return this.systemErr.source();
    }

    boolean isClosed() {
        return this.spawnable.isClosed();
    }

    int getExitValue() throws ExpectJException {
        if (!this.isClosed()) {
            throw new ExpectJException("Spawn is still running");
        }
        return this.spawnable.getExitValue();
    }

    String getCurrentStandardOutContents() {
        return this.spawnOutToSystemOut.getCurrentContents();
    }

    String getCurrentStandardErrContents() {
        if (this.spawnErrToSystemErr == null) {
            return null;
        }
        return this.spawnErrToSystemErr.getCurrentContents();
    }

    void setCloseListener(Spawnable.CloseListener closeListener) {
        this.spawnable.setCloseListener(closeListener);
    }
}

