/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import expectj.AbstractSpawnable;
import expectj.Spawnable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SshSpawn
extends AbstractSpawnable
implements Spawnable {
    private String m_remoteHost;
    private int m_remotePort;
    private Session m_session = null;
    private OutputStream m_fromSocket;
    private InputStream m_toSocket;
    private String m_username = null;
    private String m_password = null;
    private Channel m_channel = null;

    public SshSpawn(String remoteHostName, int remotePort, String username, String password) {
        this.m_remotePort = remotePort;
        this.m_remoteHost = remoteHostName;
        this.m_username = username;
        this.m_password = password;
    }

    public SshSpawn(Channel channel) throws IOException {
        if (!channel.isConnected()) {
            try {
                channel.connect();
            }
            catch (JSchException e) {
                throw new IOException("Failed connecting the channel", e);
            }
        }
        this.m_channel = channel;
        this.m_toSocket = this.m_channel.getInputStream();
        this.m_fromSocket = this.m_channel.getOutputStream();
    }

    public void start() throws IOException {
        if (this.m_toSocket != null) {
            return;
        }
        try {
            this.m_session = new JSch().getSession(this.m_username, this.m_remoteHost, this.m_remotePort);
            this.m_session.setPassword(this.m_password);
            this.m_session.setConfig("StrictHostKeyChecking", "no");
            this.m_session.connect();
            this.m_channel = this.m_session.openChannel("shell");
            this.m_channel.connect();
        }
        catch (JSchException e) {
            throw new IOException("Unable to establish SSH session/channel", e);
        }
        this.m_toSocket = this.m_channel.getInputStream();
        this.m_fromSocket = this.m_channel.getOutputStream();
    }

    public InputStream getStdout() {
        return this.m_toSocket;
    }

    public OutputStream getStdin() {
        return this.m_fromSocket;
    }

    public InputStream getStderr() {
        return null;
    }

    public boolean isClosed() {
        if (this.m_channel != null && this.m_channel.isClosed()) {
            this.stop();
        }
        return this.m_channel == null;
    }

    public int getExitValue() {
        return 0;
    }

    public void stop() {
        if (this.m_channel == null) {
            return;
        }
        this.m_channel.disconnect();
        this.m_channel = null;
        if (this.m_session != null) {
            this.m_session.disconnect();
            this.m_session = null;
        }
        this.m_toSocket = null;
        this.m_fromSocket = null;
    }
}

