/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StreamPiper
extends Thread
implements Runnable {
    private static final Log LOG = LogFactory.getLog(StreamPiper.class);
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private PrintStream copyStream = null;
    boolean pipingPaused = false;
    private boolean continueProcessing = true;
    private volatile StringBuffer sCurrentOut = new StringBuffer();

    private synchronized boolean getPipingPaused() {
        return this.pipingPaused;
    }

    StreamPiper(PrintStream copyStream, InputStream pi, OutputStream po) {
        if (pi == null) {
            throw new NullPointerException("Input stream must not be null");
        }
        this.inputStream = pi;
        this.outputStream = po;
        this.copyStream = copyStream;
        this.setDaemon(true);
        this.setName("ExpectJ Stream Piper");
    }

    public synchronized void stopPipingToStandardOut() {
        this.pipingPaused = true;
    }

    public synchronized void startPipingToStandardOut() {
        this.pipingPaused = false;
    }

    public synchronized void stopProcessing() {
        this.continueProcessing = false;
    }

    private synchronized boolean getContinueProcessing() {
        return this.continueProcessing;
    }

    synchronized String getCurrentContents() {
        return this.sCurrentOut.toString();
    }

    public void run() {
        block5: {
            byte[] buffer = new byte[512];
            try {
                while (this.getContinueProcessing()) {
                    int bytes_read = this.inputStream.read(buffer);
                    if (bytes_read == -1) {
                        LOG.debug("Stream ended, closing");
                        this.inputStream.close();
                        this.outputStream.close();
                        return;
                    }
                    this.outputStream.write(buffer, 0, bytes_read);
                    this.sCurrentOut.append(new String(buffer, 0, bytes_read));
                    if (this.copyStream != null && !this.getPipingPaused()) {
                        this.copyStream.write(buffer, 0, bytes_read);
                        this.copyStream.flush();
                    }
                    this.outputStream.flush();
                }
            }
            catch (IOException e) {
                if (!this.getContinueProcessing()) break block5;
                LOG.error("Trouble while pushing data between streams", e);
            }
        }
    }
}

