/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import expectj.AbstractSpawnable;
import expectj.Spawnable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

class TelnetSpawn
extends AbstractSpawnable
implements Spawnable {
    private InetAddress m_remoteHost;
    private int m_remotePort;
    private Socket m_socket;
    private InputStream m_fromSocket;
    private OutputStream m_toSocket;

    public TelnetSpawn(String remoteHostName, int remotePort) throws UnknownHostException {
        this.m_remotePort = remotePort;
        this.m_remoteHost = InetAddress.getByName(remoteHostName);
    }

    public void start() throws IOException {
        this.m_socket = new Socket(this.m_remoteHost, this.m_remotePort);
        this.m_fromSocket = this.m_socket.getInputStream();
        this.m_toSocket = this.m_socket.getOutputStream();
    }

    public InputStream getStdout() {
        return this.m_fromSocket;
    }

    public OutputStream getStdin() {
        return this.m_toSocket;
    }

    public InputStream getStderr() {
        return null;
    }

    public boolean isClosed() {
        if (this.m_socket != null && this.m_socket.isClosed()) {
            this.stop();
        }
        return this.m_socket == null;
    }

    public int getExitValue() {
        return 0;
    }

    public void stop() {
        if (this.m_socket == null) {
            return;
        }
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_socket = null;
        this.m_fromSocket = null;
        this.m_toSocket = null;
    }
}

