/*
 * Decompiled with CFR 0.152.
 */
package expectj;

import expectj.TimerEventListener;

class Timer
implements Runnable {
    private long timeOut = 0L;
    private TimerEventListener listener = null;
    private Thread thread = null;
    public static final int NOT_STARTED = 0;
    public static final int STARTED = 1;
    public static final int TIMEDOUT = 2;
    public static final int INTERRUPTED = 3;
    private int currentStatus = 0;
    private boolean done = false;

    public Timer(long timeOut, TimerEventListener listener) {
        if (timeOut < 1L) {
            throw new IllegalArgumentException("Time-Out value cannot be < 1");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.timeOut = timeOut * 1000L;
        this.listener = listener;
    }

    public void startTimer() {
        this.thread = new Thread((Runnable)this, "ExpectJ Timer Thread, " + this.timeOut + "ms");
        this.currentStatus = 1;
        this.thread.start();
    }

    public int getStatus() {
        return this.currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Timer timer = this;
        synchronized (timer) {
            this.done = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Timer timer = this;
            synchronized (timer) {
                this.wait(this.timeOut);
                if (this.done) {
                    return;
                }
                this.currentStatus = 2;
                this.listener.timerTimedOut();
            }
        }
        catch (InterruptedException iexp) {
            this.currentStatus = 3;
            this.listener.timerInterrupted(iexp);
        }
    }
}

