/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.KBIPrompt;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgUserAuthInfoResponse
extends SshMessage {
    public static final int SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
    private KBIPrompt[] prompts;
    String[] responses;

    public SshMsgUserAuthInfoResponse() {
        super(61);
    }

    public SshMsgUserAuthInfoResponse(KBIPrompt[] kBIPromptArray) {
        super(61);
        if (kBIPromptArray != null) {
            this.responses = new String[kBIPromptArray.length];
            for (int i = 0; i < this.responses.length; ++i) {
                this.responses[i] = kBIPromptArray[i].getResponse();
            }
        }
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_INFO_RESPONSE";
    }

    public String[] getResponses() {
        return this.responses;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            if (this.responses == null) {
                byteArrayWriter.writeInt(0);
            } else {
                byteArrayWriter.writeInt(this.responses.length);
                for (int i = 0; i < this.responses.length; ++i) {
                    byteArrayWriter.writeString(this.responses[i]);
                }
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Failed to write message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            int n = (int)byteArrayReader.readInt();
            if (n > 0) {
                this.responses = new String[n];
                for (int i = 0; i < this.responses.length; ++i) {
                    this.responses[i] = byteArrayReader.readString();
                }
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Failed to read message data");
        }
    }
}

