/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.XTextField;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericTextField
extends XTextField {
    private Color positiveBackground;
    private DecimalFormatSymbols symbols;
    private NumberFormat numberFormat;
    private boolean selectAllOnFocusGain;
    private int wColumnWidth;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;

    public NumericTextField(Number number, Number number2) {
        this(number, number2, number);
    }

    public NumericTextField(Number number, Number number2, Number number3, boolean bl) {
        this(number, number2, number3, bl, null);
    }

    public NumericTextField(Number number, Number number2, Number number3) {
        this(number, number2, number3, true);
    }

    public NumericTextField(Number number, Number number2, Number number3, boolean bl, NumberFormat numberFormat) {
        super(Math.max(number.toString().length(), number2.toString().length()));
        this.setNumberFormat(numberFormat);
        if (!number.getClass().equals(number2.getClass()) || !number2.getClass().equals(number3.getClass())) {
            throw new IllegalArgumentException("All arguments must be of the same class");
        }
        this.setDocument(new ADocument(number, number2));
        this.setValue(number3);
        this.setRightJustify(bl);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!focusEvent.isTemporary()) {
            switch (focusEvent.getID()) {
                case 1005: {
                    if (this.getNumberFormat() == null) break;
                    String string = this.getNumberFormat().format(this.getValue()).toString();
                    if (this.getText().equals(string)) break;
                    this.setText(string);
                    break;
                }
                case 1004: {
                    if (!this.isSelectAllOnFocusGain()) break;
                    this.selectAll();
                }
            }
        }
    }

    public boolean isSelectAllOnFocusGain() {
        return this.selectAllOnFocusGain;
    }

    public void setSelectAllOnFocusGain(boolean bl) {
        this.selectAllOnFocusGain = bl;
    }

    public void setMaximum(Number number) {
        ((ADocument)this.getDocument()).setMaximum(number);
    }

    public Number getMaximum() {
        return ((ADocument)this.getDocument()).max;
    }

    public void setMinimum(Number number) {
        ((ADocument)this.getDocument()).setMinimum(number);
    }

    public Number getMinimum() {
        return ((ADocument)this.getDocument()).min;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.symbols = numberFormat instanceof DecimalFormat ? ((DecimalFormat)numberFormat).getDecimalFormatSymbols() : new DecimalFormatSymbols();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setRightJustify(boolean bl) {
        this.setHorizontalAlignment(bl ? 4 : 2);
    }

    public boolean isRightJustify() {
        return this.getHorizontalAlignment() == 4;
    }

    public void setText(String string) {
        ADocument aDocument = (ADocument)this.getDocument();
        Number number = aDocument.currentVal;
        try {
            aDocument.currentVal = aDocument.parse(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (number != aDocument.currentVal) {
            aDocument.checkingEnabled = false;
            super.setText(string);
            aDocument.checkingEnabled = true;
        }
    }

    public void setValue(Number number) {
        this.setText(number.toString());
    }

    public Number getValue() {
        return ((ADocument)this.getDocument()).getValue();
    }

    class ADocument
    extends PlainDocument {
        Number currentVal;
        Number max;
        Number min;
        boolean checkingEnabled = true;
        boolean rightJustify = true;

        public ADocument(Number number, Number number2) {
            this.min = number;
            this.max = number2;
            this.currentVal = number.getClass().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumericTextField.class$("java.lang.Byte")) : class$java$lang$Byte) ? (Number)new Byte(0) : (Number)(number.getClass().equals(class$java$lang$Short == null ? (class$java$lang$Short = NumericTextField.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short(0) : (Number)(number.getClass().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumericTextField.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(0) : (Number)(number.getClass().equals(class$java$lang$Long == null ? (class$java$lang$Long = NumericTextField.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(0L) : (Number)(number.getClass().equals(class$java$lang$Float == null ? (class$java$lang$Float = NumericTextField.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(0.0f) : (Number)new Double(0.0)))));
        }

        public void setMaximum(Number number) {
            this.max = number;
        }

        public void setMinimum(Number number) {
            this.min = number;
        }

        public void setRightJustify(boolean bl) {
            this.rightJustify = bl;
        }

        public boolean isRightJustify() {
            return this.rightJustify;
        }

        public Number getValue() {
            return this.currentVal;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (!this.checkingEnabled) {
                super.insertString(n, string, attributeSet);
                return;
            }
            String string2 = null;
            if (this.getLength() == 0) {
                string2 = string;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.getText(0, this.getLength()));
                stringBuffer.insert(n, string);
                string2 = stringBuffer.toString();
            }
            try {
                this.currentVal = this.parse(string2);
                super.insertString(n, string, attributeSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Number parse(String string) throws NumberFormatException {
            Double d = new Double(0.0);
            if (!string.equals(String.valueOf(NumericTextField.this.symbols.getMinusSign())) && string.length() != 0) {
                if (NumericTextField.this.getNumberFormat() != null) {
                    int n;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < string.length(); ++i) {
                        n = string.charAt(i);
                        if (n != NumericTextField.this.symbols.getDecimalSeparator() && (n < 48 || n > 57)) continue;
                        stringBuffer.append((char)n);
                    }
                    String string2 = stringBuffer.toString();
                    for (n = 0; n < string2.length() && string2.charAt(n) != NumericTextField.this.symbols.getDecimalSeparator(); ++n) {
                    }
                    int n2 = n;
                    int n3 = 0;
                    if (n2 < string2.length()) {
                        n3 = string2.length() - n - 1;
                    }
                    if (n2 > NumericTextField.this.getNumberFormat().getMaximumIntegerDigits()) {
                        throw new NumberFormatException("More digits BEFORE the decimal separator than allowed:" + string);
                    }
                    if (n3 > NumericTextField.this.getNumberFormat().getMaximumFractionDigits()) {
                        throw new NumberFormatException("More digits AFTER the decimal separator than allowed:" + string);
                    }
                    try {
                        d = new Double(NumericTextField.this.getNumberFormat().parse(string).doubleValue());
                    }
                    catch (ParseException parseException) {
                        throw new NumberFormatException("Failed to parse. " + string + parseException.getMessage());
                    }
                } else {
                    d = new Double(string);
                }
            }
            if (d >= this.min.doubleValue() && d <= this.max.doubleValue()) {
                if (this.min.getClass().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumericTextField.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return new Byte(d.byteValue());
                }
                if (this.min.getClass().equals(class$java$lang$Short == null ? (class$java$lang$Short = NumericTextField.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return new Short(d.shortValue());
                }
                if (this.min.getClass().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumericTextField.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return new Integer(d.intValue());
                }
                if (this.min.getClass().equals(class$java$lang$Long == null ? (class$java$lang$Long = NumericTextField.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return new Long(d.longValue());
                }
                if (this.min.getClass().equals(class$java$lang$Float == null ? (class$java$lang$Float = NumericTextField.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return new Float(d.floatValue());
                }
                return d;
            }
            throw new NumberFormatException(d + " Is out of range. Minimum is " + this.min.doubleValue() + ", Maximum is " + this.max.doubleValue());
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (!this.checkingEnabled) {
                super.remove(n, n2);
                return;
            }
            String string = this.getText(0, this.getLength());
            String string2 = string.substring(0, n);
            String string3 = string.substring(n2 + n, string.length());
            String string4 = string2 + string3;
            try {
                this.currentVal = this.parse(string4);
                super.remove(n, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

