/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StatusBar
extends JPanel {
    public static final Icon GREEN_LED_ON = new ResourceIcon(StatusBar.class, "greenledon.png");
    public static final Icon GREEN_LED_OFF = new ResourceIcon(StatusBar.class, "greenledoff.png");
    public static final Icon RED_LED_ON = new ResourceIcon(StatusBar.class, "redledon.png");
    public static final Icon RED_LED_OFF = new ResourceIcon(StatusBar.class, "redledoff.png");
    private StatusLabel connected;
    private StatusLabel statusText;
    private StatusLabel host;
    private StatusLabel user;
    private StatusLabel rid;
    private JLabel sending;
    private JLabel receiving;
    private Timer sendingTimer;
    private Timer receivingTimer;

    public StatusBar() {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        this.connected = new StatusLabel(RED_LED_OFF);
        this.connected.setHorizontalAlignment(0);
        UIUtil.jGridBagAdd(this, this.connected, gridBagConstraints, 1);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.sending = new JLabel(GREEN_LED_OFF);
        this.sending.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.sending.setHorizontalAlignment(0);
        this.receiving = new JLabel(GREEN_LED_OFF);
        this.receiving.setHorizontalAlignment(0);
        jPanel.add(this.sending);
        jPanel.add(this.receiving);
        gridBagConstraints.weightx = 0.0;
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        gridBagConstraints.weightx = 1.5;
        this.host = new StatusLabel();
        UIUtil.jGridBagAdd(this, this.host, gridBagConstraints, 1);
        this.user = new StatusLabel();
        UIUtil.jGridBagAdd(this, this.user, gridBagConstraints, 1);
        this.rid = new StatusLabel();
        UIUtil.jGridBagAdd(this, this.rid, gridBagConstraints, 1);
        this.statusText = new StatusLabel();
        gridBagConstraints.weightx = 4.0;
        UIUtil.jGridBagAdd(this, this.statusText, gridBagConstraints, -1);
        gridBagConstraints.weightx = 0.0;
        UIUtil.jGridBagAdd(this, jPanel, gridBagConstraints, 0);
    }

    public void setReceiving(boolean bl) {
        this.receiving.setIcon(bl ? GREEN_LED_ON : GREEN_LED_OFF);
    }

    public void setSending(boolean bl) {
        this.sending.setIcon(bl ? GREEN_LED_ON : GREEN_LED_OFF);
    }

    public void setConnected(boolean bl) {
        this.connected.setIcon(bl ? RED_LED_ON : RED_LED_OFF);
    }

    public void setStatusText(String string) {
        this.statusText.setText(string);
    }

    public void setHost(String string) {
        this.host.setText(string);
    }

    public void setHost(String string, int n) {
        this.host.setText(string + ":" + String.valueOf(n));
    }

    public void setRemoteId(String string) {
        this.rid.setText(string);
    }

    public void setUser(String string) {
        this.user.setText(string);
    }

    class StatusLabel
    extends JLabel {
        StatusLabel(Icon icon) {
            super(icon);
            this.init();
        }

        StatusLabel() {
            this.init();
        }

        void init() {
            this.setFont(this.getFont().deriveFont(10.0f));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        }
    }
}

