/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import data.Resource;
import data.Server;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;

public class DCMArchiveCreate
implements ConfigurationCaller {
    private DCMInventoryServer inventoryReference;
    private RrdDef rrdDef;
    private RrdDb rrdDb;
    private ArrayList<Resource> resourcesList;
    private Resource resource;
    private Configuration configuration = new Configuration(this);
    private String rrdHostDirString;
    private File rrdHostDir;
    private String rrdArchiveFileString;
    private File rrdArchiveFile;

    public DCMArchiveCreate(DCMInventoryServer inventoryReferenceParam, Server server) {
        this.inventoryReference = inventoryReferenceParam;
        this.rrdHostDirString = this.configuration.getArchiveDBDir() + server.getHost().getHostname() + this.configuration.getFileSeparator();
        this.rrdHostDir = new File(this.rrdHostDirString);
        if (!this.rrdHostDir.exists()) {
            this.rrdHostDir.mkdir();
            this.log("Action:  DCMArchiveCreate: Creating missing directory: " + this.rrdHostDirString, false, true, true);
        }
        int sampleTime = 60;
        int heartBeat = 120;
        Double minValue = 0.0;
        Double maxValue = Double.MAX_VALUE;
        String consulFunction = "AVERAGE";
        Double xff = 0.1;
        int pdp = 1;
        int mpy = 525600;
        int totalArchives = server.getResourceList().size();
        int archiveCounter = 1;
        this.log("Action:  DCMArchiveCreate: Creating " + totalArchives + " archives for host: " + server.getHost().getHostname() + ". Please wait...", true, true, true);
        for (Resource resource : server.getResourceList()) {
            this.rrdArchiveFileString = this.rrdHostDirString + resource.getRRDFile();
            this.rrdArchiveFile = new File(this.rrdArchiveFileString);
            if (!this.rrdArchiveFile.exists()) {
                this.log("Action:  DCMArchiveCreate: Creating " + totalArchives + " archives for host: " + server.getHost().getHostname() + ". Please wait... (" + archiveCounter + "/" + totalArchives + ") " + Math.round((double)archiveCounter / ((double)totalArchives * 0.01)) + "%", true, false, false);
                try {
                    this.rrdDef = new RrdDef(this.rrdHostDirString + resource.getRRDFile());
                }
                catch (RrdException ex) {
                    this.inventoryReference.rrdCreateFailureResponse(" Error: RrdException: RRDCreate: new RrdDef(resource.getRRDFile() " + ex.getMessage());
                }
                this.rrdDef.setStartTime(Long.valueOf(Calendar.getInstance().getTimeInMillis()) / 1000L);
                this.rrdDef.setStep((long)sampleTime);
                try {
                    this.rrdDef.addDatasource(resource.getResource(), resource.getCounterType(), (long)heartBeat, minValue.doubleValue(), maxValue.doubleValue());
                }
                catch (RrdException ex) {
                    this.inventoryReference.rrdCreateFailureResponse("Error: RrdException: RRDCreate: addDatasource " + ex.getMessage());
                }
                try {
                    this.rrdDef.addArchive(consulFunction, xff.doubleValue(), pdp, resource.getRetentionTime() * 525600);
                }
                catch (RrdException ex) {
                    this.inventoryReference.rrdCreateFailureResponse(" Error: RrdException: RRDCreate: addArchive " + ex.getMessage());
                }
                try {
                    this.rrdDb = new RrdDb(this.rrdDef);
                }
                catch (RrdException ex) {
                    this.inventoryReference.rrdCreateFailureResponse("Error:  DCMArchiveCreate: RrdException: RRDCreate: new RrdDb(rrdDef) " + ex.getMessage());
                }
                catch (IOException ex) {
                    this.inventoryReference.rrdCreateFailureResponse("Error:  DCMArchiveCreate: IOException: RRDCreate: new RrdDb(rrdDef) " + ex.getMessage());
                }
                try {
                    this.rrdDb.close();
                }
                catch (IOException ex) {
                    this.inventoryReference.rrdCreateFailureResponse(" Error: IOException: RRDCreate: rrdDb.close() " + ex.getMessage());
                }
            }
            ++archiveCounter;
        }
        this.log("Action:  DCMArchiveCreate: Creating " + totalArchives + " archives for host: " + server.getHost().getHostname() + " finished.", true, true, true);
    }

    @Override
    public void log(String messageParam, boolean logToStatus, boolean logApplication, boolean logToFile) {
        this.inventoryReference.log(messageParam, logToStatus, logApplication, logToFile);
    }
}

