/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import data.Resource;
import data.Server;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;

public class DCMArchiveUpdate
implements ConfigurationCaller {
    private DCMPollServer pollerReference;
    private RrdDef rrdDef;
    private RrdDb rrdDb;
    private ArrayList<Resource> resourcesList;
    private Resource resource;
    private Configuration configuration = new Configuration(this);
    private String rrdHostDirString;
    private File rrdHostDir;
    private String rrdArchiveFileString;
    private File rrdArchiveFile;

    public DCMArchiveUpdate(DCMPollServer pollerReferenceParam, final Server server) {
        this.pollerReference = pollerReferenceParam;
        this.rrdHostDirString = this.configuration.getArchiveDBDir() + server.getHost().getHostname() + this.configuration.getFileSeparator();
        this.rrdHostDir = new File(this.rrdHostDirString);
        Thread rrdUpdateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!DCMArchiveUpdate.this.rrdHostDir.exists()) {
                    DCMArchiveUpdate.this.rrdHostDir.mkdir();
                    DCMArchiveUpdate.this.log("Warning: Creating missing directory: " + DCMArchiveUpdate.this.rrdHostDirString, false, true, true);
                }
                for (Resource resource : server.getResourceList()) {
                    DCMArchiveUpdate.this.rrdArchiveFileString = DCMArchiveUpdate.this.rrdHostDirString + resource.getRRDFile();
                    DCMArchiveUpdate.this.rrdArchiveFile = new File(DCMArchiveUpdate.this.rrdArchiveFileString);
                    if (DCMArchiveUpdate.this.rrdArchiveFile.exists()) {
                        try {
                            DCMArchiveUpdate.this.rrdDb = new RrdDb(DCMArchiveUpdate.this.rrdArchiveFileString);
                        }
                        catch (RrdException ex) {
                            DCMArchiveUpdate.this.pollerReference.rrdUpdateFailureResponse("Error:  DCMArchiveUpdate: RrdException: RRDUpdate: new RrdDb(rrdArchiveFileString) " + ex.getMessage());
                        }
                        catch (IOException ex) {
                            DCMArchiveUpdate.this.pollerReference.rrdUpdateFailureResponse("Error:  DCMArchiveUpdate: IOException: RRDUpdate: new RrdDb(rrdArchiveFileString) " + ex.getMessage());
                        }
                        Sample sample = null;
                        try {
                            sample = DCMArchiveUpdate.this.rrdDb.createSample();
                        }
                        catch (IOException ex) {
                            DCMArchiveUpdate.this.pollerReference.rrdUpdateFailureResponse("Error:  DCMArchiveUpdate: IOException: RRDUpdate: rrdDb.createSample() " + ex.getMessage());
                        }
                        sample.setTime(Long.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L).longValue());
                        try {
                            sample.setValue(0, resource.getLastValue().doubleValue());
                        }
                        catch (RrdException ex) {
                            DCMArchiveUpdate.this.pollerReference.rrdUpdateFailureResponse("Error:  DCMArchiveUpdate: RrdException: RRDUpdate: sample.setValue(..) " + ex.getMessage());
                        }
                        try {
                            sample.update();
                        }
                        catch (IOException ex) {
                            DCMArchiveUpdate.this.pollerReference.rrdUpdateFailureResponse("Error:  DCMArchiveUpdate: IOException: RRDUpdate: sample.update() " + ex.getMessage());
                        }
                        catch (RrdException ex) {
                            DCMArchiveUpdate.this.pollerReference.rrdUpdateFailureResponse("Error:  DCMArchiveUpdate: RrdException: RRDUpdate: sample.update() " + ex.getMessage());
                        }
                        try {
                            DCMArchiveUpdate.this.rrdDb.close();
                        }
                        catch (IOException ex) {
                            DCMArchiveUpdate.this.pollerReference.rrdUpdateFailureResponse(" Error: IOException: RRDUpdate: rrdDb.close() " + ex.getMessage());
                        }
                        continue;
                    }
                    DCMArchiveUpdate.this.log("Action:  DCMArchiveUpdate: Skipping: RRD Archive: " + DCMArchiveUpdate.this.rrdHostDirString + resource.getRRDFile() + ": does not exists !", true, true, true);
                }
                DCMArchiveUpdate.this.log("Status:  DCMArchiveUpdate: Finished updating RRD Archives for host: " + server.getHost().getHostname(), true, true, true);
            }
        });
        rrdUpdateThread.setName("rrdUpdateThread");
        rrdUpdateThread.setDaemon(false);
        rrdUpdateThread.setPriority(5);
        rrdUpdateThread.start();
    }

    @Override
    public void log(String messageParam, boolean logToStatus, boolean logApplication, boolean logToFile) {
        this.pollerReference.log(messageParam, true, true, true);
    }
}

