/*
 * Decompiled with CFR 0.152.
 */
import data.DCMPreset;
import data.DCMUser;
import data.Host;
import data.RMIMessage;
import data.Resource;
import data.Server;
import data.ValueLimits;
import java.awt.Color;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ImageIcon;

public class DCMClientRMI
implements Serializable {
    private DCMServerRMI dcmServerRMI;
    String rmiserver;
    private static Registry registry;
    private boolean rmiOK = true;
    private DCMClient dcmClient;
    private DCMClientRMI dcmClientRMI = this;
    private ArrayList<RMIMessage> rmiMessageList;

    public DCMClientRMI(DCMClient dcmClientParam) {
        this.dcmClient = dcmClientParam;
        this.rmiMessageList = new ArrayList();
    }

    public boolean connect(final String serverParam, final String portParam) {
        Thread rmiConnectThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMClientRMI.this.rmiOK = true;
                System.getProperties().put("java.rmi.server.hostname", serverParam);
                try {
                    registry = LocateRegistry.getRegistry(serverParam, Integer.parseInt(portParam));
                }
                catch (RemoteException ex) {
                    DCMClientRMI.this.dcmClient.log("Error: Client(,,): RemoteException: LocateRegistry.getRegistry(); " + ex.getMessage(), true, true, true);
                    DCMClientRMI.this.rmiOK = false;
                }
                try {
                    DCMClientRMI.this.dcmServerRMI = (DCMServerRMI)registry.lookup("ServerRMI");
                }
                catch (RemoteException ex) {
                    DCMClientRMI.this.dcmClient.log("Error: Client(,,): RemoteException: registry.lookup(\"ServerRMI\")); " + ex.getMessage(), true, true, true);
                    DCMClientRMI.this.rmiOK = false;
                }
                catch (NotBoundException ex) {
                    DCMClientRMI.this.dcmClient.log("Error: Client(,,): NotBoundException: registry.lookup(\"ServerRMI\")); " + ex.getMessage(), true, true, true);
                    DCMClientRMI.this.rmiOK = false;
                }
            }
        });
        rmiConnectThread.setName("rmiConnectThread");
        rmiConnectThread.setDaemon(false);
        rmiConnectThread.setPriority(5);
        rmiConnectThread.start();
        try {
            rmiConnectThread.join(60000L);
        }
        catch (InterruptedException ex) {
            System.out.println("Error: DCManagerClientRMI: connect(,,): InterruptedException: \")); " + ex.getMessage());
            this.rmiOK = false;
        }
        return this.rmiOK;
    }

    public boolean authenticate(String usernameParam, String passwordParam) {
        boolean authenticated = false;
        try {
            authenticated = this.dcmServerRMI.authenticate(usernameParam, passwordParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: authenticate " + ex.getMessage(), true, true, true);
        }
        return authenticated;
    }

    public DCMUser getDCMUser(long idParam) {
        DCMUser dcmUser = null;
        try {
            dcmUser = this.dcmServerRMI.getDCMUser(idParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getDCMUser " + ex.getMessage(), true, true, true);
        }
        return dcmUser;
    }

    public DCMUser getDCMUserByUsername(String usernameParam) {
        DCMUser dcmUser = null;
        try {
            dcmUser = this.dcmServerRMI.getDCMUserByUsername(usernameParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getDCMUserByUsername " + ex.getMessage(), true, true, true);
        }
        return dcmUser;
    }

    public ArrayList<DCMUser> getDCMUserList() {
        ArrayList<DCMUser> dcmUserList = new ArrayList();
        try {
            dcmUserList = this.dcmServerRMI.getDCMUserList();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getDCMUserList " + ex.getMessage(), true, true, true);
        }
        return dcmUserList;
    }

    public ArrayList<RMIMessage> addDCMUser(DCMUser userParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.addDCMUser(userParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: addDCMUser " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> updateDCMUser(DCMUser userParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.updateDCMUser(userParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: updateDCMUser " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> deleteDCMUser(long idParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.dcmServerRMI.deleteDCMUser(idParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getDCMUser " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public Server getServerById(long idParam) {
        Server server = null;
        try {
            server = this.dcmServerRMI.getServerById(idParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: getServerById: RemoteException: getServerById " + ex.getMessage(), true, true, true);
        }
        return server;
    }

    public Server getServerByHostname(String hostnameParam) {
        Server server = null;
        try {
            server = this.dcmServerRMI.getServerByHostname(hostnameParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getServerByHostname " + ex.getMessage(), true, true, true);
        }
        return server;
    }

    public ArrayList<Server> getServerList() throws CloneNotSupportedException {
        ArrayList<Server> serverList = new ArrayList();
        try {
            serverList = this.dcmServerRMI.getServerList();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getServerList " + ex.getMessage(), true, true, true);
        }
        return serverList;
    }

    public ArrayList<RMIMessage> inventoryServer(long instanceParam, Host hostParam, int retentionTimeParam, int timeoutParam, int retryMaxParam, boolean debugParam) {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.inventoryServer(instanceParam, hostParam, retentionTimeParam, timeoutParam, retryMaxParam, debugParam);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> enableHost(Host hostParam, boolean enableParam) {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.enableHost(hostParam, enableParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: enableServer " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> deleteServer(Server serverParam, boolean deleteArchivesParam) {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.deleteServer(serverParam, deleteArchivesParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: deleteServer " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> deleteServers(boolean deleteArchivesParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.deleteServers(deleteArchivesParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: deleteServers " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> deleteServerByHostname(String hostnameParam) {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.deleteServerByHostname(hostnameParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: deleteServerByHostname " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> updateHost(Host hostParam, boolean generateScriptParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.updateHost(hostParam, generateScriptParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: updateHost(Host hostParam) " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public Host getHostById(long idParam) throws CloneNotSupportedException {
        Host host = new Host();
        try {
            host = this.dcmServerRMI.getHostById(idParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getHostById " + ex.getMessage(), true, true, true);
        }
        return host;
    }

    public Host getHostByHostname(String hostnameParam) {
        Host host = new Host();
        try {
            host = this.dcmServerRMI.getHostByHostname(hostnameParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getHostByHostname " + ex.getMessage(), true, true, true);
        }
        return host;
    }

    public Resource getResourceById(long idParam) {
        Resource resource = null;
        try {
            resource = this.dcmServerRMI.getResourceById(idParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getResourceById " + ex.getMessage(), true, true, true);
        }
        return resource;
    }

    public ArrayList<RMIMessage> updateResource(Resource resourceParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.updateResource(resourceParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: updateResource " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public boolean hostnameChangedInHostTable(String oldHostnameParam, String newHostnameParam) {
        boolean succeeded = false;
        try {
            succeeded = this.dcmServerRMI.hostnameChangedInHostTable(oldHostnameParam, newHostnameParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: hostnameChangedInHostTable " + ex.getMessage(), true, true, true);
        }
        return succeeded;
    }

    public void exportInventory() {
        try {
            this.dcmServerRMI.exportInventory();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: exportInventory " + ex.getMessage(), true, true, true);
        }
    }

    public void importInventory() {
        try {
            this.dcmServerRMI.importInventory();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: importInventory " + ex.getMessage(), true, true, true);
        }
    }

    public DCMPreset getDCMPreset(long idParam) {
        DCMPreset dcmPreset = null;
        try {
            dcmPreset = this.dcmServerRMI.getDCMPreset(idParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getDCMPreset " + ex.getMessage(), true, true, true);
        }
        return dcmPreset;
    }

    public ArrayList<DCMPreset> getDCMPresetList() {
        ArrayList<DCMPreset> dcmPresetList = new ArrayList();
        try {
            dcmPresetList = this.dcmServerRMI.getDCMPresetList();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getDCMPresetList " + ex.getMessage(), true, true, true);
        }
        return dcmPresetList;
    }

    public ArrayList<RMIMessage> insertDCMPreset(DCMPreset dcmPresetParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.insertDCMPreset(dcmPresetParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: insertDCMPreset " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> updateDCMPreset(DCMPreset dcmPresetParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.updateDCMPreset(dcmPresetParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: updateDCMPreset " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public ArrayList<RMIMessage> deleteDCMPreset(DCMPreset dcmPresetParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.deleteDCMPreset(dcmPresetParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: deleteDCMPreset " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public String searchExactResources(String searchString, ArrayList<Server> serverList) {
        String selectedResources = "";
        try {
            selectedResources = this.dcmServerRMI.searchExactResources(searchString, serverList);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: searchExact " + ex.getMessage(), true, true, true);
        }
        return selectedResources;
    }

    public String searchNonExactResources(String searchString, ArrayList<Server> serverList) {
        String selectedResources = "";
        try {
            selectedResources = this.dcmServerRMI.searchNonExactResources(searchString, serverList);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: searchNonExact " + ex.getMessage(), true, true, true);
        }
        return selectedResources;
    }

    public ValueLimits manualValueMode(Calendar startCalendar, Calendar endCalendar, String selectedResources) {
        ValueLimits valueLimits = new ValueLimits();
        try {
            valueLimits = this.dcmServerRMI.manualValueMode(startCalendar, endCalendar, selectedResources);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: manualValueMode " + ex.getMessage(), true, true, true);
        }
        return valueLimits;
    }

    public ImageIcon getTrend(ArrayList<Color> lineColorList, int imageWidth, int imageHeight, boolean manualValueMode, Calendar startCalendar, Calendar endCalendar, ValueLimits valueLimits, String selectedResources, Float lineType) throws CloneNotSupportedException {
        ImageIcon imageIcon = null;
        try {
            imageIcon = this.dcmServerRMI.getTrend(lineColorList, imageWidth, imageHeight, manualValueMode, startCalendar, endCalendar, valueLimits, selectedResources, lineType);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getTrend " + ex.getMessage(), true, true, true);
        }
        return imageIcon;
    }

    public StringBuffer getData(Calendar startCalendar, Calendar endCalendar, String selectedResources) throws CloneNotSupportedException {
        StringBuffer returnData = null;
        try {
            returnData = this.dcmServerRMI.getData(startCalendar, endCalendar, selectedResources);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getData " + ex.getMessage(), true, true, true);
        }
        return returnData;
    }

    public void applyReceiveVergunning(String activatCode, String vergCode) {
        try {
            this.dcmServerRMI.applyReceiveVergunning(activatCode, vergCode);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: applyReceiveVergunning " + ex.getMessage(), true, true, true);
        }
    }

    public String updateVergunning(int serversInLicenseParam, Calendar selectedDateParam, String vergunningPeriodParam) {
        String vergunningCode = "";
        try {
            vergunningCode = this.dcmServerRMI.updateVergunning(serversInLicenseParam, selectedDateParam, vergunningPeriodParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: orderVergunningCode " + ex.getMessage(), true, true, true);
        }
        return vergunningCode;
    }

    public boolean vergunningIsValid() {
        boolean vergunningIsValid = false;
        try {
            vergunningIsValid = this.dcmServerRMI.vergunningIsValid();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: controleerVergunning " + ex.getMessage(), true, true, true);
        }
        return vergunningIsValid;
    }

    public String[] getAK() {
        String[] status = new String[2];
        try {
            status = this.dcmServerRMI.getAK();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getAK " + ex.getMessage(), true, true, true);
        }
        return status;
    }

    public String getVergunningPeriod() {
        String vergunningPeriod = "";
        try {
            vergunningPeriod = this.dcmServerRMI.getVergunningPeriod();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningPeriod " + ex.getMessage(), true, true, true);
        }
        return vergunningPeriod;
    }

    public String getVergunningStartDateString() {
        String startDateString = "";
        try {
            startDateString = this.dcmServerRMI.getVergunningStartDateString();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningStartDateString " + ex.getMessage(), true, true, true);
        }
        return startDateString;
    }

    public String getVergunningEndDateString() {
        String endDateString = "";
        try {
            endDateString = this.dcmServerRMI.getVergunningEndDateString();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningEndDateString " + ex.getMessage(), true, true, true);
        }
        return endDateString;
    }

    public Calendar getVergunningStartDate() {
        Calendar startDate = Calendar.getInstance();
        try {
            startDate = this.dcmServerRMI.getVergunningStartDate();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningStartDate " + ex.getMessage(), true, true, true);
        }
        return startDate;
    }

    public Calendar getVergunningEndDate() {
        Calendar endDate = Calendar.getInstance();
        try {
            endDate = this.dcmServerRMI.getVergunningEndDate();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningEndDate " + ex.getMessage(), true, true, true);
        }
        return endDate;
    }

    public int getServersInLicense() {
        int serversInLicense = 0;
        try {
            serversInLicense = this.dcmServerRMI.getServersInLicense();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getServersInLicense " + ex.getMessage(), true, true, true);
        }
        return serversInLicense;
    }

    public int getHostCount() {
        int hostCount = 0;
        try {
            hostCount = this.dcmServerRMI.getHostCount();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getHostCount " + ex.getMessage(), true, true, true);
        }
        return hostCount;
    }

    public int getResourceCount() {
        int resourceCount = 0;
        try {
            resourceCount = this.dcmServerRMI.getResourceCount();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getResourceCount " + ex.getMessage(), true, true, true);
        }
        return resourceCount;
    }

    public String getServerVersion() {
        String serverVersion = "";
        try {
            serverVersion = this.dcmServerRMI.getServerVersion();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getServerVersion " + ex.getMessage(), true, true, true);
        }
        return serverVersion;
    }

    public ArrayList<String[]> getJVMStaticPropertiesList() {
        ArrayList<String[]> staticPropertiesList = new ArrayList();
        try {
            staticPropertiesList = this.dcmServerRMI.getJVMStaticPropertiesList();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getJVMStaticPropertiesList " + ex.getMessage(), true, true, true);
        }
        return staticPropertiesList;
    }

    public ArrayList<String[]> getJVMDynamicPropertiesList() {
        ArrayList<String[]> dynamicPropertiesList = new ArrayList();
        try {
            dynamicPropertiesList = this.dcmServerRMI.getJVMDynamicPropertiesList();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getJVMDynamicPropertiesList " + ex.getMessage(), true, true, true);
        }
        return dynamicPropertiesList;
    }

    public String getActivationCode() {
        String activationCode = "";
        try {
            activationCode = this.dcmServerRMI.getActivationCode();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getActivationCode " + ex.getMessage(), true, true, true);
        }
        return activationCode;
    }

    public String getVergunningCode() {
        String vergunningCode = "";
        try {
            vergunningCode = this.dcmServerRMI.getVergunningCode();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningCode " + ex.getMessage(), true, true, true);
        }
        return vergunningCode;
    }

    public String getVergunningInvalidAdvice() {
        String invalidAdvice = "";
        try {
            invalidAdvice = this.dcmServerRMI.getVergunningInvalidAdvice();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningInvalidAdvice " + ex.getMessage(), true, true, true);
        }
        return invalidAdvice;
    }

    public String getVergunningInvalidReason() {
        String invalidReason = "";
        try {
            invalidReason = this.dcmServerRMI.getVergunningInvalidReason();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getVergunningInvalidReason " + ex.getMessage(), true, true, true);
        }
        return invalidReason;
    }

    public void setVergunningOrderInProgress(boolean inProgress) {
        try {
            this.dcmServerRMI.setVergunningOrderInProgress(inProgress);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setVergunningOrderInProgress " + ex.getMessage(), true, true, true);
        }
    }

    public void setVergunningValid(boolean validParam) {
        try {
            this.dcmServerRMI.setVergunningValid(validParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setVergunningValid " + ex.getMessage(), true, true, true);
        }
    }

    public void setDefaultServersInLicense() {
        try {
            this.dcmServerRMI.setDefaultServersInLicense();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setVergunningValid " + ex.getMessage(), true, true, true);
        }
    }

    public void reloadVergunning() {
        try {
            this.dcmServerRMI.reloadVergunning();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: reloadV " + ex.getMessage(), true, true, true);
        }
    }

    public Calendar getDCMTijd() {
        Calendar last = Calendar.getInstance();
        try {
            last = this.dcmServerRMI.getDCMTijd();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: getDCMTijd " + ex.getMessage(), true, true, true);
        }
        return last;
    }

    public void setDCMTijd(Calendar nowParam) {
        try {
            this.dcmServerRMI.setDCMTijd(nowParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setDCMTijd " + ex.getMessage(), true, true, true);
        }
    }

    public void setVergunningPeriod(String vergunningPeriodParam) {
        try {
            this.dcmServerRMI.setVergunningPeriod(vergunningPeriodParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setVergunningPeriod " + ex.getMessage(), true, true, true);
        }
    }

    public void setVergunningStartDate(Calendar startDateParam) {
        try {
            this.dcmServerRMI.setVergunningStartDate(startDateParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setVergunningStartDate " + ex.getMessage(), true, true, true);
        }
    }

    public void setVergunningEndDate(Calendar endDateParam) {
        try {
            this.dcmServerRMI.setVergunningEndDate(endDateParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setVergunningEndDate " + ex.getMessage(), true, true, true);
        }
    }

    public void setServersInLicense(int serversInLicenseParam) {
        try {
            this.dcmServerRMI.setServersInLicense(serversInLicenseParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setServersInLicense " + ex.getMessage(), true, true, true);
        }
    }

    public void setActivationCode(String activationCodeParam) {
        try {
            this.dcmServerRMI.setActivationCode(activationCodeParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setActivationCode " + ex.getMessage(), true, true, true);
        }
    }

    public void setVergunningCode(String vergunningCodeParam) {
        try {
            this.dcmServerRMI.setVergunningCode(vergunningCodeParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: setVergunningCode " + ex.getMessage(), true, true, true);
        }
    }

    public boolean vergunningReachedLimit() {
        boolean vergunningReachedLimit = false;
        try {
            vergunningReachedLimit = this.dcmServerRMI.vergunningReachedLimit();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: vergunningReachedLimit " + ex.getMessage(), true, true, true);
        }
        return vergunningReachedLimit;
    }

    public ArrayList<RMIMessage> pushPollScript(Server serverParam) {
        this.rmiMessageList.clear();
        try {
            this.rmiMessageList = this.dcmServerRMI.pushPollScript(serverParam);
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: pushPollScript " + ex.getMessage(), true, true, true);
        }
        return this.rmiMessageList;
    }

    public void startPoller() {
        try {
            this.dcmServerRMI.startPoller();
        }
        catch (RemoteException ex) {
            this.dcmClient.log("Error: : RemoteException: startPoller " + ex.getMessage(), true, true, true);
        }
    }
}

