/*
 * Decompiled with CFR 0.152.
 */
import data.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DCMCommandLibraryAIX {
    private Host host;
    private String command = "";
    private InetAddress inetAddress;
    private String dcmServerIP;
    private String mpstatDataFile;
    private String iostatDataFile;
    private String psCPUFile;
    private String psMEMFile;
    private final String OS = "AIX";
    private final int AWK = 0;
    private final int BC = 1;
    private final int DF = 2;
    private final int ECHO = 3;
    private final int EGREP = 4;
    private final int GREP = 5;
    private final int HEAD = 6;
    private final int IOSTAT = 7;
    private final int MPSTAT = 8;
    private final int NETSTAT = 9;
    private final int PS = 10;
    private final int SED = 11;
    private final int SORT = 12;
    private final int SVMON = 13;
    private final int TAIL = 14;
    private final int TR = 15;
    private final int W = 16;
    private final int WC = 17;
    private final int WHO = 18;
    private static String[][] cmdArray;

    public DCMCommandLibraryAIX(Host hostParam) throws UnknownHostException {
        this.host = hostParam;
        cmdArray = new String[19][4];
        DCMCommandLibraryAIX.cmdArray[0][0] = Integer.toString(0);
        DCMCommandLibraryAIX.cmdArray[0][1] = "awk";
        DCMCommandLibraryAIX.cmdArray[0][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[0][3] = "binary " + cmdArray[0][1] + " not found, please set PATH or install from " + cmdArray[0][2];
        DCMCommandLibraryAIX.cmdArray[1][0] = Integer.toString(1);
        DCMCommandLibraryAIX.cmdArray[1][1] = "bc";
        DCMCommandLibraryAIX.cmdArray[1][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[1][3] = "binary " + cmdArray[1][1] + " not found, please set PATH or install from " + cmdArray[1][2];
        DCMCommandLibraryAIX.cmdArray[2][0] = Integer.toString(2);
        DCMCommandLibraryAIX.cmdArray[2][1] = "df";
        DCMCommandLibraryAIX.cmdArray[2][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[2][3] = "binary " + cmdArray[2][1] + " not found, please set PATH or install from " + cmdArray[2][2];
        DCMCommandLibraryAIX.cmdArray[3][0] = Integer.toString(3);
        DCMCommandLibraryAIX.cmdArray[3][1] = "echo";
        DCMCommandLibraryAIX.cmdArray[3][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[3][3] = "binary " + cmdArray[3][1] + " not found, please set PATH or install from " + cmdArray[3][2];
        DCMCommandLibraryAIX.cmdArray[4][0] = Integer.toString(4);
        DCMCommandLibraryAIX.cmdArray[4][1] = "egrep";
        DCMCommandLibraryAIX.cmdArray[4][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[4][3] = "binary " + cmdArray[4][1] + " not found, please set PATH or install from " + cmdArray[4][2];
        DCMCommandLibraryAIX.cmdArray[5][0] = Integer.toString(5);
        DCMCommandLibraryAIX.cmdArray[5][1] = "grep";
        DCMCommandLibraryAIX.cmdArray[5][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[5][3] = "binary " + cmdArray[5][1] + " not found, please set PATH or install from " + cmdArray[5][2];
        DCMCommandLibraryAIX.cmdArray[6][0] = Integer.toString(6);
        DCMCommandLibraryAIX.cmdArray[6][1] = "head";
        DCMCommandLibraryAIX.cmdArray[6][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[6][3] = "binary " + cmdArray[6][1] + " not found, please set PATH or install from " + cmdArray[6][2];
        DCMCommandLibraryAIX.cmdArray[7][0] = Integer.toString(7);
        DCMCommandLibraryAIX.cmdArray[7][1] = "iostat";
        DCMCommandLibraryAIX.cmdArray[7][2] = "AIX install media sysstat package";
        DCMCommandLibraryAIX.cmdArray[7][3] = "binary " + cmdArray[7][1] + " not found, please set PATH or install from " + cmdArray[7][2];
        DCMCommandLibraryAIX.cmdArray[8][0] = Integer.toString(8);
        DCMCommandLibraryAIX.cmdArray[8][1] = "mpstat";
        DCMCommandLibraryAIX.cmdArray[8][2] = "AIX install media sysstat package";
        DCMCommandLibraryAIX.cmdArray[8][3] = "binary " + cmdArray[8][1] + " not found, please set PATH or install from " + cmdArray[8][2];
        DCMCommandLibraryAIX.cmdArray[9][0] = Integer.toString(9);
        DCMCommandLibraryAIX.cmdArray[9][1] = "netstat";
        DCMCommandLibraryAIX.cmdArray[9][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[9][3] = "binary " + cmdArray[9][1] + " not found, please set PATH or install from " + cmdArray[9][2];
        DCMCommandLibraryAIX.cmdArray[10][0] = Integer.toString(10);
        DCMCommandLibraryAIX.cmdArray[10][1] = "ps";
        DCMCommandLibraryAIX.cmdArray[10][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[10][3] = "binary " + cmdArray[10][1] + " not found, please set PATH or install from " + cmdArray[10][2];
        DCMCommandLibraryAIX.cmdArray[11][0] = Integer.toString(11);
        DCMCommandLibraryAIX.cmdArray[11][1] = "sed";
        DCMCommandLibraryAIX.cmdArray[11][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[11][3] = "binary " + cmdArray[11][1] + " not found, please set PATH or install from " + cmdArray[11][2];
        DCMCommandLibraryAIX.cmdArray[12][0] = Integer.toString(12);
        DCMCommandLibraryAIX.cmdArray[12][1] = "sort";
        DCMCommandLibraryAIX.cmdArray[12][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[12][3] = "binary " + cmdArray[12][1] + " not found, please set PATH or install from " + cmdArray[12][2];
        DCMCommandLibraryAIX.cmdArray[13][0] = Integer.toString(13);
        DCMCommandLibraryAIX.cmdArray[13][1] = "svmon";
        DCMCommandLibraryAIX.cmdArray[13][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[13][3] = "binary " + cmdArray[13][1] + " not found, please set PATH or install from " + cmdArray[13][2];
        DCMCommandLibraryAIX.cmdArray[14][0] = Integer.toString(14);
        DCMCommandLibraryAIX.cmdArray[14][1] = "tail";
        DCMCommandLibraryAIX.cmdArray[14][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[14][3] = "binary " + cmdArray[14][1] + " not found, please set PATH or install from " + cmdArray[14][2];
        DCMCommandLibraryAIX.cmdArray[15][0] = Integer.toString(15);
        DCMCommandLibraryAIX.cmdArray[15][1] = "tr";
        DCMCommandLibraryAIX.cmdArray[15][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[15][3] = "binary " + cmdArray[15][1] + " not found, please set PATH or install from " + cmdArray[15][2];
        DCMCommandLibraryAIX.cmdArray[16][0] = Integer.toString(16);
        DCMCommandLibraryAIX.cmdArray[16][1] = "w";
        DCMCommandLibraryAIX.cmdArray[16][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[16][3] = "binary " + cmdArray[16][1] + " not found, please set PATH or install from " + cmdArray[16][2];
        DCMCommandLibraryAIX.cmdArray[17][0] = Integer.toString(17);
        DCMCommandLibraryAIX.cmdArray[17][1] = "wc";
        DCMCommandLibraryAIX.cmdArray[17][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[17][3] = "binary " + cmdArray[17][1] + " not found, please set PATH or install from " + cmdArray[17][2];
        DCMCommandLibraryAIX.cmdArray[18][0] = Integer.toString(18);
        DCMCommandLibraryAIX.cmdArray[18][1] = "who";
        DCMCommandLibraryAIX.cmdArray[18][2] = "AIX install media";
        DCMCommandLibraryAIX.cmdArray[18][3] = "binary " + cmdArray[18][1] + " not found, please set PATH or install from " + cmdArray[18][2];
        this.inetAddress = InetAddress.getLocalHost();
        this.dcmServerIP = this.inetAddress.getHostAddress();
        this.mpstatDataFile = ".dcmmpstat_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.iostatDataFile = ".dcmiostat_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psCPUFile = ".dcmpscpu_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psMEMFile = ".dcmpsmem_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
    }

    public String getPSCPUHostCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[10][1] + " -e -o pid,pcpu,comm | " + cmdArray[5][1] + " -iv \"pid\" | " + cmdArray[12][1] + " -k 2nr > " + this.psCPUFile + " \n";
        }
        return this.command;
    }

    public String getPSMEMHostCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[10][1] + " -e -o pid,pmem,comm | " + cmdArray[5][1] + " -iv \"pid\" | " + cmdArray[12][1] + " -k 2nr > " + this.psMEMFile + " \n";
        }
        return this.command;
    }

    public String getCPUHostCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[8][1] + " -a 50 1 > " + this.mpstatDataFile + " & \n";
        }
        return this.command;
    }

    public String getALLCPUHostCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[8][1] + " -a 53 1 >> " + this.mpstatDataFile + " & \n";
        }
        return this.command;
    }

    public String getCPUMinorPageFaultsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUMajorPageFaultsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUMPCSendInterruptsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $4 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUMPCReceiveInterruptsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUDeviceInterruptsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $6 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUSoftInterruptsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $7 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUDecrementerInterruptsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $8 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUPhantomInterruptsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $9 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUContextSwitchesCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $10 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUInvoluntaryContextSwitchesCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $11 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUThreadsBoundCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $12 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPURunQueueZizeCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $13 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUMigrationsStarvedCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $14 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUMigrationsOutsideD3Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $15 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUGlobalRunqueueDispatchesD3Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $16 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUThreadRedispatchesD0Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $17 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUThreadRedispatchesD1Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $18 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUThreadRedispatchesD2Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $19 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUThreadRedispatchesD3Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $20 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUThreadRedispatchesD4Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $21 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUThreadRedispatchesD5Command(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $22 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUSystemCallsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $23 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUUserCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $24 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUSysCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $25 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUWAIOCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $26 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUIDLECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $27 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUPhysicalFractionsConsumedCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $28 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUEntitledCapacityConsumedCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $39 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUInvoluntaryLogicalContextSwitchesCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $30 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUVoluntaryLogicalContextSwitchesCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $31 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPULocalThreadDispatchesCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $32 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUNearThreadDispatchesCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $33 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUFarThreadDispatchesCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[0][1] + " '{ print $34 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getWorkload() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[16][1] + " | " + cmdArray[5][1] + " -i \"average\" | " + cmdArray[0][1] + " '{ print $10 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOHostCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[7][1] + " -ld 50 1 > " + this.iostatDataFile + " & \n";
        }
        return this.command;
    }

    public String getDiskIOTimeActiveCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOBytesPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOTransfersPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[0][1] + " '{ print $4 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOKBReadPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOKBWrittenPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[4][1] + " -ie \"^" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[0][1] + " '{ print $6 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getRAMTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "ramtot=`" + cmdArray[13][1] + " -O unit=MB | " + cmdArray[5][1] + " memory | " + cmdArray[0][1] + " '{ print $2 }'`; " + cmdArray[3][1] + " $ramtot";
        }
        return this.command;
    }

    public String getRAMUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "ramused=`" + cmdArray[13][1] + " -O unit=MB | " + cmdArray[5][1] + " memory | " + cmdArray[0][1] + " '{ print $3 }'`; " + cmdArray[3][1] + " $ramused";
        }
        return this.command;
    }

    public String getRAMFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "ramfree=`" + cmdArray[13][1] + " -O unit=MB | " + cmdArray[5][1] + " memory | " + cmdArray[0][1] + " '{ print $4 }'`; " + cmdArray[3][1] + " $ramfree";
        }
        return this.command;
    }

    public String getSWAPTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "swaptot=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $3 }'`; " + cmdArray[3][1] + " $swaptot";
        }
        return this.command;
    }

    public String getSWAPUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "swapused=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $4 }'`; " + cmdArray[3][1] + " $swapused";
        }
        return this.command;
    }

    public String getSWAPFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "swaptot=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $3 }'`; swapused=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $4 }'`; swapfree=`" + cmdArray[3][1] + " \"$swaptot - $swapused\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $swapfree";
        }
        return this.command;
    }

    public String getTOTMEMCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "ramtot=`" + cmdArray[13][1] + " -O unit=MB | " + cmdArray[5][1] + " memory | " + cmdArray[0][1] + " '{ print $2 }'`; swaptot=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $3 }'`; totmem=`" + cmdArray[3][1] + " \"$ramtot + $swaptot\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totmem";
        }
        return this.command;
    }

    public String getTOTUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "ramused=`" + cmdArray[13][1] + " -O unit=MB | " + cmdArray[5][1] + " memory | " + cmdArray[0][1] + " '{ print $3 }'`; swapused=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $4 }'`; totused=`" + cmdArray[3][1] + " \"$ramused + $swapused\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totused";
        }
        return this.command;
    }

    public String getTOTFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = "ramfree=`" + cmdArray[13][1] + " -O unit=MB | " + cmdArray[5][1] + " memory | " + cmdArray[0][1] + " '{ print $4 }'`; swapused=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $4 }'`; swaptot=`" + cmdArray[13][1] + " | " + cmdArray[5][1] + " \"pg space\" | " + cmdArray[0][1] + " '{ print $3 }'`; swapfree=`" + cmdArray[3][1] + " \"$swaptot - $swapused\" | " + cmdArray[1][1] + "`; totfree=`" + cmdArray[3][1] + " \"$ramfree + $swapfree\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totfree";
        }
        return this.command;
    }

    public String getFSTOTCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[2][1] + " -Pk " + resourceParam + " | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[14][1] + " -1";
        }
        return this.command;
    }

    public String getFSUSEDCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[2][1] + " -Pk " + resourceParam + " | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[14][1] + " -1";
        }
        return this.command;
    }

    public String getFSFREECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[2][1] + " -Pk " + resourceParam + " | " + cmdArray[0][1] + " '{ print $4 }' | " + cmdArray[14][1] + " -1";
        }
        return this.command;
    }

    public String getFSUSEDPercCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[2][1] + " -Pk " + resourceParam + " | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[14][1] + " -1 | " + cmdArray[15][1] + " -d \"%\"";
        }
        return this.command;
    }

    public String getIFTINPacketsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -i | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $5 }'";
        }
        return this.command;
    }

    public String getIFINERRCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -i | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $6 }'";
        }
        return this.command;
    }

    public String getIFOUTPacketsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -i | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $7 }'";
        }
        return this.command;
    }

    public String getIFOUTERRCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -i | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $8 }'";
        }
        return this.command;
    }

    public String getIFCollisionsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -i | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $9 }'";
        }
        return this.command;
    }

    public String getTCPSTATBOUNDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"BOUND\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"CLOSED\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSINGCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"CLOSING\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSE_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"CLOSE_WAIT\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATESTABLISHEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"ESTABLISHED\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT_1Command(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"FIN_WAIT_1\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT_2Command(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"FIN_WAIT_2\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATIDLECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"IDLE\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLAST_ACKCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"LAST_ACK\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLISTENCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"LISTEN\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_RECEIVEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"SYN_RECEIVED\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_SENTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[5][1] + " \"SYN_SENT\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATTIME_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[9][1] + " -an | " + cmdArray[4][1] + " -ie \"TIME_WAIT\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFUSERSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[18][1] + " | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFPROCSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[10][1] + " -e | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getPS1CPUPIDCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -1 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1CPUCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -1 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUPIDCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -2 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -2 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUPIDCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -3 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -3 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMPIDCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -1 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -1 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2MEMPIDCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -2 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2MEMCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -2 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3MEMPIDCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -3 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3MEMCommand() {
        if (this.host.getSysinfo().contains("AIX")) {
            this.command = cmdArray[6][1] + " -3 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String[][] getCommandArray() {
        return cmdArray;
    }
}

