/*
 * Decompiled with CFR 0.152.
 */
import data.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DCMCommandLibraryDarwin {
    private Host host;
    private String command = "";
    private InetAddress inetAddress;
    private String dcmServerIP;
    private String sarDataFile;
    private String psCPUFile;
    private String psMEMFile;
    private String iostatDataFile;
    private final String OS = "Darwin";
    private final int AWK = 0;
    private final int BC = 1;
    private final int DF = 2;
    private final int ECHO = 3;
    private final int EGREP = 4;
    private final int GREP = 5;
    private final int HEAD = 6;
    private final int IOSTAT = 7;
    private final int NETSTAT = 8;
    private final int PS = 9;
    private final int SAR = 10;
    private final int SED = 11;
    private final int SORT = 12;
    private final int SYSCTL = 13;
    private final int TAIL = 14;
    private final int TOP = 15;
    private final int TR = 16;
    private final int W = 17;
    private final int WC = 18;
    private final int WHO = 19;
    private String[][] cmdArray;

    public DCMCommandLibraryDarwin(Host hostParam) throws UnknownHostException {
        this.host = hostParam;
        try {
            this.inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.dcmServerIP = this.inetAddress.getHostAddress();
        this.sarDataFile = ".dcmsar_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.iostatDataFile = ".dcmiostat_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psCPUFile = ".dcmpscpu_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psMEMFile = ".dcmpsmem_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.cmdArray = new String[20][4];
        this.cmdArray[0][0] = Integer.toString(0);
        this.cmdArray[0][1] = "awk";
        this.cmdArray[0][2] = "Darwin install media";
        this.cmdArray[0][3] = "binary " + this.cmdArray[0][1] + " not found, please set PATH or install from " + this.cmdArray[0][2];
        this.cmdArray[1][0] = Integer.toString(1);
        this.cmdArray[1][1] = "bc";
        this.cmdArray[1][2] = "Darwin install media";
        this.cmdArray[1][3] = "binary " + this.cmdArray[1][1] + " not found, please set PATH or install from " + this.cmdArray[1][2];
        this.cmdArray[2][0] = Integer.toString(2);
        this.cmdArray[2][1] = "df";
        this.cmdArray[2][2] = "Darwin install media";
        this.cmdArray[2][3] = "binary " + this.cmdArray[2][1] + " not found, please set PATH or install from " + this.cmdArray[2][2];
        this.cmdArray[3][0] = Integer.toString(3);
        this.cmdArray[3][1] = "echo";
        this.cmdArray[3][2] = "Darwin install media";
        this.cmdArray[3][3] = "binary " + this.cmdArray[3][1] + " not found, please set PATH or install from " + this.cmdArray[3][2];
        this.cmdArray[4][0] = Integer.toString(4);
        this.cmdArray[4][1] = "egrep";
        this.cmdArray[4][2] = "Darwin install media";
        this.cmdArray[4][3] = "binary " + this.cmdArray[4][1] + " not found, please set PATH or install from " + this.cmdArray[4][2];
        this.cmdArray[5][0] = Integer.toString(5);
        this.cmdArray[5][1] = "grep";
        this.cmdArray[5][2] = "Darwin install media";
        this.cmdArray[5][3] = "binary " + this.cmdArray[5][1] + " not found, please set PATH or install from " + this.cmdArray[5][2];
        this.cmdArray[6][0] = Integer.toString(6);
        this.cmdArray[6][1] = "head";
        this.cmdArray[6][2] = "Darwin install media";
        this.cmdArray[6][3] = "binary " + this.cmdArray[6][1] + " not found, please set PATH or install from " + this.cmdArray[6][2];
        this.cmdArray[7][0] = Integer.toString(7);
        this.cmdArray[7][1] = "iostat";
        this.cmdArray[7][2] = "Darwin install media sysstat package";
        this.cmdArray[7][3] = "binary " + this.cmdArray[7][1] + " not found, please set PATH or install from " + this.cmdArray[7][2];
        this.cmdArray[8][0] = Integer.toString(8);
        this.cmdArray[8][1] = "netstat";
        this.cmdArray[8][2] = "Darwin install media";
        this.cmdArray[8][3] = "binary " + this.cmdArray[8][1] + " not found, please set PATH or install from " + this.cmdArray[8][2];
        this.cmdArray[9][0] = Integer.toString(9);
        this.cmdArray[9][1] = "ps";
        this.cmdArray[9][2] = "Darwin install media";
        this.cmdArray[9][3] = "binary " + this.cmdArray[9][1] + " not found, please set PATH or install from " + this.cmdArray[9][2];
        this.cmdArray[10][0] = Integer.toString(10);
        this.cmdArray[10][1] = "sar";
        this.cmdArray[10][2] = "Darwin install media sysstat package";
        this.cmdArray[10][3] = "binary " + this.cmdArray[10][1] + " not found, please set PATH or install from " + this.cmdArray[10][2];
        this.cmdArray[11][0] = Integer.toString(11);
        this.cmdArray[11][1] = "sed";
        this.cmdArray[11][2] = "Darwin install media";
        this.cmdArray[11][3] = "binary " + this.cmdArray[11][1] + " not found, please set PATH or install from " + this.cmdArray[11][2];
        this.cmdArray[3][0] = Integer.toString(3);
        this.cmdArray[3][1] = "echo";
        this.cmdArray[3][2] = "Darwin install media";
        this.cmdArray[3][3] = "binary " + this.cmdArray[3][1] + " not found, please set PATH or install from " + this.cmdArray[3][2];
        this.cmdArray[12][0] = Integer.toString(12);
        this.cmdArray[12][1] = "sort";
        this.cmdArray[12][2] = "Darwin install media";
        this.cmdArray[12][3] = "binary " + this.cmdArray[12][1] + " not found, please set PATH or install from " + this.cmdArray[12][2];
        this.cmdArray[13][0] = Integer.toString(13);
        this.cmdArray[13][1] = "sysctl";
        this.cmdArray[13][2] = "Darwin install media";
        this.cmdArray[13][3] = "binary " + this.cmdArray[13][1] + " not found, please set PATH or install from " + this.cmdArray[13][2];
        this.cmdArray[14][0] = Integer.toString(14);
        this.cmdArray[14][1] = "tail";
        this.cmdArray[14][2] = "Darwin install media";
        this.cmdArray[14][3] = "binary " + this.cmdArray[14][1] + " not found, please set PATH or install from " + this.cmdArray[14][2];
        this.cmdArray[15][0] = Integer.toString(15);
        this.cmdArray[15][1] = "top";
        this.cmdArray[15][2] = "Darwin install media";
        this.cmdArray[15][3] = "binary " + this.cmdArray[15][1] + " not found, please set PATH or install from " + this.cmdArray[15][2];
        this.cmdArray[16][0] = Integer.toString(16);
        this.cmdArray[16][1] = "tr";
        this.cmdArray[16][2] = "Darwin install media";
        this.cmdArray[16][3] = "binary " + this.cmdArray[16][1] + " not found, please set PATH or install from " + this.cmdArray[16][2];
        this.cmdArray[17][0] = Integer.toString(17);
        this.cmdArray[17][1] = "w";
        this.cmdArray[17][2] = "Darwin install media";
        this.cmdArray[17][3] = "binary " + this.cmdArray[17][1] + " not found, please set PATH or install from " + this.cmdArray[17][2];
        this.cmdArray[18][0] = Integer.toString(18);
        this.cmdArray[18][1] = "wc";
        this.cmdArray[18][2] = "Darwin install media";
        this.cmdArray[18][3] = "binary " + this.cmdArray[18][1] + " not found, please set PATH or install from " + this.cmdArray[18][2];
        this.cmdArray[19][0] = Integer.toString(19);
        this.cmdArray[19][1] = "who";
        this.cmdArray[19][2] = "Darwin install media";
        this.cmdArray[19][3] = "binary " + this.cmdArray[19][1] + " not found, please set PATH or install from " + this.cmdArray[19][2];
    }

    public String getPSCPUHostCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[9][1] + " -e -o pid,pcpu,comm | " + this.cmdArray[5][1] + " -iv \"pid\" | " + this.cmdArray[12][1] + " -k 2nr > " + this.psCPUFile + " \n";
        }
        return this.command;
    }

    public String getPSMEMHostCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[9][1] + " -e -o pid,pmem,comm | " + this.cmdArray[5][1] + " -iv \"pid\" | " + this.cmdArray[12][1] + " -k 2nr > " + this.psMEMFile + " \n";
        }
        return this.command;
    }

    public String getCPUHostCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[10][1] + " -u 25 1 > " + this.sarDataFile + " & \n";
        }
        return this.command;
    }

    public String getCPUUSERCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[4][1] + " -ie \"^.+: +\" " + this.sarDataFile + " | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUSYSCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[4][1] + " -ie \"^.+: +\" " + this.sarDataFile + " | " + this.cmdArray[0][1] + " '{ print $4 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUIDLECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[4][1] + " -ie \"^.+: +\" " + this.sarDataFile + " | " + this.cmdArray[0][1] + " '{ print $5 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getWorkload() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[17][1] + " | " + this.cmdArray[5][1] + " -i \"average\" | " + this.cmdArray[0][1] + " '{ print $10 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOHostCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[7][1] + " -c 2 -w 50 -K -d > " + this.iostatDataFile + " & \n";
        }
        return this.command;
    }

    public String getDiskIOKBPerTransferCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[14][1] + " -1 " + this.iostatDataFile + " | " + this.cmdArray[0][1] + " '{ print $1 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOTransfersPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[14][1] + " -1 " + this.iostatDataFile + " | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOMBPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[14][1] + " -1 " + this.iostatDataFile + " | " + this.cmdArray[0][1] + " '{ print $3 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getRAMTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "ramtot=`" + this.cmdArray[13][1] + " -n hw.memsize`; ramtot=$((ramtot/(1024*1024))); " + this.cmdArray[3][1] + " $ramtot";
        }
        return this.command;
    }

    public String getRAMUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "ramused=`" + this.cmdArray[15][1] + " -l 1 -n 0 | head -7 | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $8 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; " + this.cmdArray[3][1] + " $ramused";
        }
        return this.command;
    }

    public String getRAMFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "ramfree=`" + this.cmdArray[15][1] + " -l 1 -n 0 | head -7 | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $10 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; " + this.cmdArray[3][1] + " $ramfree";
        }
        return this.command;
    }

    public String getSWAPTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "swaptot=`" + this.cmdArray[13][1] + " -n vm.swapusage | " + this.cmdArray[0][1] + " '{ print $3 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; " + this.cmdArray[3][1] + " $swaptot";
        }
        return this.command;
    }

    public String getSWAPUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "swapused=`" + this.cmdArray[13][1] + " -n vm.swapusage | " + this.cmdArray[0][1] + " '{ print $6 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; " + this.cmdArray[3][1] + " $swapused";
        }
        return this.command;
    }

    public String getSWAPFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "swapfree=`" + this.cmdArray[13][1] + " -n vm.swapusage | " + this.cmdArray[0][1] + " '{ print $9 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; " + this.cmdArray[3][1] + " $swapfree";
        }
        return this.command;
    }

    public String getTOTMEMCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "ramtot=`" + this.cmdArray[13][1] + " -n hw.memsize`; ramtot=$((ramtot/(1024*1024))); swaptot=`" + this.cmdArray[13][1] + " -n vm.swapusage | " + this.cmdArray[0][1] + " '{ print $3 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; totmem=`" + this.cmdArray[3][1] + " \"$ramtot + $swaptot\" | " + this.cmdArray[1][1] + "`; " + this.cmdArray[3][1] + " $totmem";
        }
        return this.command;
    }

    public String getTOTUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "ramused=`" + this.cmdArray[15][1] + " -l 1 -n 0 | head -7 | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $8 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; swapused=`" + this.cmdArray[13][1] + " -n vm.swapusage | " + this.cmdArray[0][1] + " '{ print $6 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; totused=`" + this.cmdArray[3][1] + " \"$ramused + $swapused\" | " + this.cmdArray[1][1] + "`; " + this.cmdArray[3][1] + " $totused";
        }
        return this.command;
    }

    public String getTOTFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = "ramfree=`" + this.cmdArray[15][1] + " -l 1 -n 0 | head -7 | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $10 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; swapfree=`" + this.cmdArray[13][1] + " -n vm.swapusage | " + this.cmdArray[0][1] + " '{ print $9 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`; totfree=`" + this.cmdArray[3][1] + " \"$ramfree + $swapfree\" | " + this.cmdArray[1][1] + "`; " + this.cmdArray[3][1] + " $totfree";
        }
        return this.command;
    }

    public String getFSTOTCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[2][1] + " -m " + resourceParam + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $2 }'";
        }
        return this.command;
    }

    public String getFSUSEDCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[2][1] + " -m " + resourceParam + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $3 }'";
        }
        return this.command;
    }

    public String getFSFREECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[2][1] + " -m " + resourceParam + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $4 }'";
        }
        return this.command;
    }

    public String getFSUSEDPercCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[2][1] + " -m " + resourceParam + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $5 }' | " + this.cmdArray[16][1] + " -d \"%\"";
        }
        return this.command;
    }

    public String getIFTXPacketsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -I " + resourceParam + " -ni | " + this.cmdArray[5][1] + " Link | " + this.cmdArray[0][1] + " '{ print $7 }'";
        }
        return this.command;
    }

    public String getIFRXPacketsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -I " + resourceParam + " -ni | " + this.cmdArray[5][1] + " Link | " + this.cmdArray[0][1] + " '{ print $5 }'";
        }
        return this.command;
    }

    public String getIFTXErrCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -I " + resourceParam + " -ni | " + this.cmdArray[5][1] + " Link | " + this.cmdArray[0][1] + " '{ print $8 }'";
        }
        return this.command;
    }

    public String getIFRXErrCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -I " + resourceParam + " -ni | " + this.cmdArray[5][1] + " Link | " + this.cmdArray[0][1] + " '{ print $6 }'";
        }
        return this.command;
    }

    public String getIFCollisionCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -I " + resourceParam + " -ni | " + this.cmdArray[5][1] + " Link | " + this.cmdArray[0][1] + " '{ print $9 }'";
        }
        return this.command;
    }

    public String getTCPSTATESTABLISHEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+ESTABLISHED\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_SENTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+SYN_SENT\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_RECVCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+SYN_RECV\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT1Command(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+FIN_WAIT1\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT2Command(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+FIN_WAIT2\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATTIME_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+TIME_WAIT\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+CLOSED\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSE_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+CLOSE_WAIT\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLAST_ACKCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+LAST_ACK\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLISTENCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+LISTEN\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSINGCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+CLOSING\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATUNKNOWNCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[8][1] + " -an | " + this.cmdArray[4][1] + " \"tcp.+UNKNOWN\" | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFUSERSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[19][1] + " | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFPROCSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[9][1] + " -e | " + this.cmdArray[18][1] + " -l | " + this.cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getPS1CPUPIDCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -1 " + this.psCPUFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $1 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1CPUCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -1 " + this.psCPUFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUPIDCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -2 " + this.psCPUFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $1 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -2 " + this.psCPUFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUPIDCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -3 " + this.psCPUFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $1 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -3 " + this.psCPUFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMPIDCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -1 " + this.psMEMFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $1 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -1 " + this.psMEMFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2MEMPIDCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -2 " + this.psMEMFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $1 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2MEMCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -2 " + this.psMEMFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3MEMPIDCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -3 " + this.psMEMFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $1 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3MEMCommand() {
        if (this.host.getSysinfo().contains("Darwin")) {
            this.command = this.cmdArray[6][1] + " -3 " + this.psMEMFile + " | " + this.cmdArray[14][1] + " -1 | " + this.cmdArray[0][1] + " '{ print $2 }' | " + this.cmdArray[11][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String[][] getCommandArray() {
        return this.cmdArray;
    }
}

