/*
 * Decompiled with CFR 0.152.
 */
import data.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DCMCommandLibraryHPUX {
    private Host host;
    private String command = "";
    private InetAddress inetAddress;
    private String dcmServerIP;
    private String sarDataFile;
    private String iostatDataFile;
    private String psCPUFile;
    private String psMEMFile;
    private final String OS = "HP-UX";
    private final int AWK = 0;
    private final int BC = 1;
    private final int DF = 2;
    private final int ECHO = 3;
    private final int EGREP = 4;
    private final int GREP = 5;
    private final int HEAD = 6;
    private final int IOSTAT = 7;
    private final int SAR = 8;
    private final int MACHINFO = 9;
    private final int NETSTAT = 10;
    private final int PS = 11;
    private final int SED = 12;
    private final int SORT = 13;
    private final int SWAPINFO = 14;
    private final int TAIL = 15;
    private final int TR = 16;
    private final int VMSTAT = 17;
    private final int W = 18;
    private final int WC = 19;
    private final int WHO = 20;
    private static String[][] cmdArray;

    public DCMCommandLibraryHPUX(Host hostParam) throws UnknownHostException {
        this.host = hostParam;
        try {
            this.inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.dcmServerIP = this.inetAddress.getHostAddress();
        this.sarDataFile = ".dcmsar_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.iostatDataFile = ".dcmiostat_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psCPUFile = ".dcmpscpu_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psMEMFile = ".dcmpsmem_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        cmdArray = new String[21][4];
        DCMCommandLibraryHPUX.cmdArray[0][0] = Integer.toString(0);
        DCMCommandLibraryHPUX.cmdArray[0][1] = "awk";
        DCMCommandLibraryHPUX.cmdArray[0][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[0][3] = "binary " + cmdArray[0][1] + " not found, please set PATH or install from " + cmdArray[0][2];
        DCMCommandLibraryHPUX.cmdArray[1][0] = Integer.toString(1);
        DCMCommandLibraryHPUX.cmdArray[1][1] = "bc";
        DCMCommandLibraryHPUX.cmdArray[1][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[1][3] = "binary " + cmdArray[1][1] + " not found, please set PATH or install from " + cmdArray[1][2];
        DCMCommandLibraryHPUX.cmdArray[2][0] = Integer.toString(2);
        DCMCommandLibraryHPUX.cmdArray[2][1] = "df";
        DCMCommandLibraryHPUX.cmdArray[2][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[2][3] = "binary " + cmdArray[2][1] + " not found, please set PATH or install from " + cmdArray[2][2];
        DCMCommandLibraryHPUX.cmdArray[3][0] = Integer.toString(3);
        DCMCommandLibraryHPUX.cmdArray[3][1] = "echo";
        DCMCommandLibraryHPUX.cmdArray[3][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[3][3] = "binary " + cmdArray[3][1] + " not found, please set PATH or install from " + cmdArray[3][2];
        DCMCommandLibraryHPUX.cmdArray[4][0] = Integer.toString(4);
        DCMCommandLibraryHPUX.cmdArray[4][1] = "egrep";
        DCMCommandLibraryHPUX.cmdArray[4][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[4][3] = "binary " + cmdArray[4][1] + " not found, please set PATH or install from " + cmdArray[4][2];
        DCMCommandLibraryHPUX.cmdArray[5][0] = Integer.toString(5);
        DCMCommandLibraryHPUX.cmdArray[5][1] = "grep";
        DCMCommandLibraryHPUX.cmdArray[5][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[5][3] = "binary " + cmdArray[5][1] + " not found, please set PATH or install from " + cmdArray[5][2];
        DCMCommandLibraryHPUX.cmdArray[6][0] = Integer.toString(6);
        DCMCommandLibraryHPUX.cmdArray[6][1] = "head";
        DCMCommandLibraryHPUX.cmdArray[6][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[6][3] = "binary " + cmdArray[6][1] + " not found, please set PATH or install from " + cmdArray[6][2];
        DCMCommandLibraryHPUX.cmdArray[7][0] = Integer.toString(7);
        DCMCommandLibraryHPUX.cmdArray[7][1] = "iostat";
        DCMCommandLibraryHPUX.cmdArray[7][2] = "HP-UX install media sysstat package";
        DCMCommandLibraryHPUX.cmdArray[7][3] = "binary " + cmdArray[7][1] + " not found, please set PATH or install from " + cmdArray[7][2];
        DCMCommandLibraryHPUX.cmdArray[8][0] = Integer.toString(8);
        DCMCommandLibraryHPUX.cmdArray[8][1] = "sar";
        DCMCommandLibraryHPUX.cmdArray[8][2] = "HP-UX install media sysstat package";
        DCMCommandLibraryHPUX.cmdArray[8][3] = "binary " + cmdArray[8][1] + " not found, please set PATH or install from " + cmdArray[8][2];
        DCMCommandLibraryHPUX.cmdArray[9][0] = Integer.toString(9);
        DCMCommandLibraryHPUX.cmdArray[9][1] = "/usr/contrib/bin/machinfo";
        DCMCommandLibraryHPUX.cmdArray[9][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[9][3] = "binary " + cmdArray[9][1] + " not found, please set PATH or install from " + cmdArray[9][2];
        DCMCommandLibraryHPUX.cmdArray[10][0] = Integer.toString(10);
        DCMCommandLibraryHPUX.cmdArray[10][1] = "netstat";
        DCMCommandLibraryHPUX.cmdArray[10][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[10][3] = "binary " + cmdArray[10][1] + " not found, please set PATH or install from " + cmdArray[10][2];
        DCMCommandLibraryHPUX.cmdArray[11][0] = Integer.toString(11);
        DCMCommandLibraryHPUX.cmdArray[11][1] = "ps";
        DCMCommandLibraryHPUX.cmdArray[11][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[11][3] = "binary " + cmdArray[11][1] + " not found, please set PATH or install from " + cmdArray[11][2];
        DCMCommandLibraryHPUX.cmdArray[12][0] = Integer.toString(12);
        DCMCommandLibraryHPUX.cmdArray[12][1] = "sed";
        DCMCommandLibraryHPUX.cmdArray[12][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[12][3] = "binary " + cmdArray[12][1] + " not found, please set PATH or install from " + cmdArray[12][2];
        DCMCommandLibraryHPUX.cmdArray[13][0] = Integer.toString(13);
        DCMCommandLibraryHPUX.cmdArray[13][1] = "sort";
        DCMCommandLibraryHPUX.cmdArray[13][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[13][3] = "binary " + cmdArray[13][1] + " not found, please set PATH or install from " + cmdArray[13][2];
        DCMCommandLibraryHPUX.cmdArray[14][0] = Integer.toString(14);
        DCMCommandLibraryHPUX.cmdArray[14][1] = "/usr/sbin/swapinfo";
        DCMCommandLibraryHPUX.cmdArray[14][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[14][3] = "binary " + cmdArray[14][1] + " not found, please set PATH or install from " + cmdArray[14][2];
        DCMCommandLibraryHPUX.cmdArray[15][0] = Integer.toString(15);
        DCMCommandLibraryHPUX.cmdArray[15][1] = "tail";
        DCMCommandLibraryHPUX.cmdArray[15][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[15][3] = "binary " + cmdArray[15][1] + " not found, please set PATH or install from " + cmdArray[15][2];
        DCMCommandLibraryHPUX.cmdArray[16][0] = Integer.toString(16);
        DCMCommandLibraryHPUX.cmdArray[16][1] = "tr";
        DCMCommandLibraryHPUX.cmdArray[16][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[16][3] = "binary " + cmdArray[16][1] + " not found, please set PATH or install from " + cmdArray[16][2];
        DCMCommandLibraryHPUX.cmdArray[17][0] = Integer.toString(17);
        DCMCommandLibraryHPUX.cmdArray[17][1] = "vmstat";
        DCMCommandLibraryHPUX.cmdArray[17][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[17][3] = "binary " + cmdArray[17][1] + " not found, please set PATH or install from " + cmdArray[17][2];
        DCMCommandLibraryHPUX.cmdArray[18][0] = Integer.toString(18);
        DCMCommandLibraryHPUX.cmdArray[18][1] = "w";
        DCMCommandLibraryHPUX.cmdArray[18][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[18][3] = "binary " + cmdArray[18][1] + " not found, please set PATH or install from " + cmdArray[18][2];
        DCMCommandLibraryHPUX.cmdArray[19][0] = Integer.toString(19);
        DCMCommandLibraryHPUX.cmdArray[19][1] = "wc";
        DCMCommandLibraryHPUX.cmdArray[19][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[19][3] = "binary " + cmdArray[19][1] + " not found, please set PATH or install from " + cmdArray[19][2];
        DCMCommandLibraryHPUX.cmdArray[20][0] = Integer.toString(20);
        DCMCommandLibraryHPUX.cmdArray[20][1] = "who";
        DCMCommandLibraryHPUX.cmdArray[20][2] = "HP-UX install media";
        DCMCommandLibraryHPUX.cmdArray[20][3] = "binary " + cmdArray[20][1] + " not found, please set PATH or install from " + cmdArray[20][2];
    }

    public String getPSCPUHostCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[11][1] + " -e -o pid,pcpu,comm | " + cmdArray[5][1] + " -iv \"pid\" | " + cmdArray[13][1] + " -k 2nr > " + this.psCPUFile + " \n";
        }
        return this.command;
    }

    public String getPSMEMHostCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[11][1] + " -e -o pid,vsz,comm | " + cmdArray[5][1] + " -iv \"pid\" | " + cmdArray[13][1] + " -k 2nr > " + this.psMEMFile + " \n";
        }
        return this.command;
    }

    public String getCPUHostCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "kill `ps -u \\`id -u\\` | grep sadc | awk '{ print $1 }'`; " + cmdArray[8][1] + " -M 25 2 > " + this.sarDataFile + " & \n";
        }
        return this.command;
    }

    public String getCPUUserCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[12][1] + " -e 's/system/all/' " + this.sarDataFile + " | " + cmdArray[4][1] + " -ie \"^average +" + resourceParam + " +\" | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUSystemCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[12][1] + " -e 's/system/all/' " + this.sarDataFile + " | " + cmdArray[4][1] + " -ie \"^average +" + resourceParam + " +\" | " + cmdArray[0][1] + " '{ print $4 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUWIOCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[12][1] + " -e 's/system/all/' " + this.sarDataFile + " | " + cmdArray[4][1] + " -ie \"^average +" + resourceParam + " +\" | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUIDLECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[12][1] + " -e 's/system/all/' " + this.sarDataFile + " | " + cmdArray[4][1] + " -ie \"^average +" + resourceParam + " +\" | " + cmdArray[0][1] + " '{ print $6 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getWorkload() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[18][1] + " | " + cmdArray[5][1] + " -i \"average\" | " + cmdArray[0][1] + " '{ print $10 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOHostCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[7][1] + " 25 2 > " + this.iostatDataFile + " & \n";
        }
        return this.command;
    }

    public String getDiskIOKBTransferedPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[5][1] + " " + resourceParam + " " + this.iostatDataFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOSeeksPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[5][1] + " " + resourceParam + " " + this.iostatDataFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOmSecPerAverageSeekCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[5][1] + " " + resourceParam + " " + this.iostatDataFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $4 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getRAMTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramtot=`" + cmdArray[9][1] + " | " + cmdArray[5][1] + " -i memory | " + cmdArray[0][1] + " '{ print $3 }'`; " + cmdArray[3][1] + " $ramtot";
        }
        return this.command;
    }

    public String getRAMUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramused=`" + cmdArray[17][1] + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $5*0.004 }'`; " + cmdArray[3][1] + " $ramused";
        }
        return this.command;
    }

    public String getRAMFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramtot=`" + cmdArray[9][1] + " | " + cmdArray[5][1] + " -i memory | " + cmdArray[0][1] + " '{ print $3 }'`; ramused=`" + cmdArray[17][1] + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $5*0.004 }'`; ramfree=`" + cmdArray[3][1] + " \"$ramtot - $ramused\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $ramfree";
        }
        return this.command;
    }

    public String getSWAPTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "swaptot=`" + cmdArray[14][1] + " -m | " + cmdArray[5][1] + " -i \"memory\" | " + cmdArray[0][1] + " '{ print $2 }'`; " + cmdArray[3][1] + " $swaptot";
        }
        return this.command;
    }

    public String getSWAPUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "swapused=`" + cmdArray[14][1] + " -m | " + cmdArray[5][1] + " -i \"memory\" | " + cmdArray[0][1] + " '{ print $3 }'`; " + cmdArray[3][1] + " $swapused";
        }
        return this.command;
    }

    public String getSWAPFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "swapfree=`" + cmdArray[14][1] + " -m | " + cmdArray[5][1] + " -i \"memory\" | " + cmdArray[0][1] + " '{ print $4 }'`; " + cmdArray[3][1] + " $swapfree";
        }
        return this.command;
    }

    public String getTOTMEMCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramtot=`" + cmdArray[9][1] + " | " + cmdArray[5][1] + " -i memory | " + cmdArray[0][1] + " '{ print $3 }'`; swaptot=`" + cmdArray[14][1] + " -m | " + cmdArray[5][1] + " -i \"memory\" | " + cmdArray[0][1] + " '{ print $2 }'`; totmem=`" + cmdArray[3][1] + " \"$ramtot + $swaptot\" | " + cmdArray[1][1] + "`;  " + cmdArray[3][1] + " $totmem";
        }
        return this.command;
    }

    public String getTOTUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramused=`" + cmdArray[17][1] + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $5*0.004 }'`; swapused=`" + cmdArray[14][1] + " -m | " + cmdArray[5][1] + " -i \"memory\" | " + cmdArray[0][1] + " '{ print $3 }'`; totused=`" + cmdArray[3][1] + " \"$ramused + $swapused\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totused";
        }
        return this.command;
    }

    public String getTOTFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramtot=`" + cmdArray[9][1] + " | " + cmdArray[5][1] + " -i memory | " + cmdArray[0][1] + " '{ print $3 }'`; ramused=`" + cmdArray[17][1] + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $5*0.004 }'`; ramfree=`" + cmdArray[3][1] + " \"$ramtot - $ramused\" | " + cmdArray[1][1] + "`; swapfree=`" + cmdArray[14][1] + " -m | " + cmdArray[5][1] + " -i \"memory\" | " + cmdArray[0][1] + " '{ print $4 }'`;  totfree=`" + cmdArray[3][1] + " \"$ramfree + $swapfree\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totfree";
        }
        return this.command;
    }

    public String getFSTOTCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[2][1] + " -kP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $2/1024 }' | " + cmdArray[15][1] + " -1";
        }
        return this.command;
    }

    public String getFSUSEDCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[2][1] + " -kP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $3/1024 }' | " + cmdArray[15][1] + " -1";
        }
        return this.command;
    }

    public String getFSFREECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[2][1] + " -kP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $4/1024 }' | " + cmdArray[15][1] + " -1";
        }
        return this.command;
    }

    public String getFSUSEDPercCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[2][1] + " -kP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[15][1] + " -1 | " + cmdArray[16][1] + " -d \"%\"";
        }
        return this.command;
    }

    public String getIFTINPacketsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -in | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $5 }'";
        }
        return this.command;
    }

    public String getIFINERRCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -in | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $6 }'";
        }
        return this.command;
    }

    public String getIFOUTPacketsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -in | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $7 }'";
        }
        return this.command;
    }

    public String getIFOUTERRCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -in | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $8 }'";
        }
        return this.command;
    }

    public String getIFCollisionsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -in | " + cmdArray[5][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $9 }'";
        }
        return this.command;
    }

    public String getTCPSTATBOUNDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"BOUND\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"CLOSED\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSINGCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"CLOSING\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSE_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"CLOSE_WAIT\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATESTABLISHEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"ESTABLISHED\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT_1Command(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"FIN_WAIT_1\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT_2Command(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"FIN_WAIT_2\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATIDLECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"IDLE\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLAST_ACKCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"LAST_ACK\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLISTENCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"LISTEN\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_RECEIVEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"SYN_RECEIVED\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_SENTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[5][1] + " \"SYN_SENT\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATTIME_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"TIME_WAIT\" | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFUSERSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[20][1] + " | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFPROCSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[11][1] + " -e | " + cmdArray[19][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getPS1CPUPIDCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -1 " + this.psCPUFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1CPUCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -1 " + this.psCPUFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUPIDCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -2 " + this.psCPUFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -2 " + this.psCPUFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUPIDCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -3 " + this.psCPUFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -3 " + this.psCPUFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMPIDCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -1 " + this.psMEMFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramtotm=`" + cmdArray[9][1] + " | " + cmdArray[5][1] + " -i memory | " + cmdArray[0][1] + " '{ print $3 }'`; ramtotk=$(( ramtotm * 1024 )); ";
        }
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = this.command + "psusedk=`" + cmdArray[6][1] + " -1 " + this.psMEMFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`;";
        }
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = this.command + "psusedperc=`" + cmdArray[3][1] + " \"$psusedk / ($ramtotk / 100)\" | " + cmdArray[1][1] + " -l`; " + cmdArray[3][1] + " $psusedperc";
        }
        return this.command;
    }

    public String getPS2MEMPIDCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -2 " + this.psMEMFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2MEMCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramtotm=`" + cmdArray[9][1] + " | " + cmdArray[5][1] + " -i memory | " + cmdArray[0][1] + " '{ print $3 }'`; ramtotk=$(( ramtotm * 1024 )); ";
        }
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = this.command + "psusedk=`" + cmdArray[6][1] + " -2 " + this.psMEMFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`;";
        }
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = this.command + "psusedperc=`" + cmdArray[3][1] + " \"$psusedk / ($ramtotk / 100)\" | " + cmdArray[1][1] + " -l`; " + cmdArray[3][1] + " $psusedperc";
        }
        return this.command;
    }

    public String getPS3MEMPIDCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = cmdArray[6][1] + " -3 " + this.psMEMFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3MEMCommand() {
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = "ramtotm=`" + cmdArray[9][1] + " | " + cmdArray[5][1] + " -i memory | " + cmdArray[0][1] + " '{ print $3 }'`; ramtotk=$(( ramtotm * 1024 )); ";
        }
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = this.command + "psusedk=`" + cmdArray[6][1] + " -3 " + this.psMEMFile + " | " + cmdArray[15][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'`;";
        }
        if (this.host.getSysinfo().contains("HP-UX")) {
            this.command = this.command + "psusedperc=`" + cmdArray[3][1] + " \"$psusedk / ($ramtotk / 100)\" | " + cmdArray[1][1] + " -l`; " + cmdArray[3][1] + " $psusedperc";
        }
        return this.command;
    }

    public String[][] getCommandArray() {
        return cmdArray;
    }
}

