/*
 * Decompiled with CFR 0.152.
 */
import data.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DCMCommandLibraryLinux {
    private Host host;
    private String command = "";
    private InetAddress inetAddress;
    private String dcmServerIP;
    private String mpstatDataFile;
    private String iostatDataFile;
    private String psCPUFile;
    private String psMEMFile;
    private final String OS = "Linux";
    private final int AWK = 0;
    private final int BC = 1;
    private final int DF = 2;
    private final int ECHO = 3;
    private final int EGREP = 4;
    private final int FREE = 5;
    private final int GREP = 6;
    private final int HEAD = 7;
    private final int IOSTAT = 8;
    private final int MPSTAT = 9;
    private final int NETSTAT = 10;
    private final int PS = 11;
    private final int SED = 12;
    private final int SORT = 13;
    private final int TAIL = 14;
    private final int TR = 15;
    private final int W = 16;
    private final int WC = 17;
    private final int WHO = 18;
    private static String[][] cmdArray;

    public DCMCommandLibraryLinux(Host hostParam) throws UnknownHostException {
        this.host = hostParam;
        try {
            this.inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.dcmServerIP = this.inetAddress.getHostAddress();
        this.mpstatDataFile = ".dcmmpstat_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.iostatDataFile = ".dcmiostat_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psCPUFile = ".dcmpscpu_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        this.psMEMFile = ".dcmpsmem_" + this.dcmServerIP + "_" + this.host.getHostname() + ".dat";
        cmdArray = new String[19][4];
        DCMCommandLibraryLinux.cmdArray[0][0] = Integer.toString(0);
        DCMCommandLibraryLinux.cmdArray[0][1] = "awk";
        DCMCommandLibraryLinux.cmdArray[0][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[0][3] = "binary " + cmdArray[0][1] + " not found, please set PATH or install from " + cmdArray[0][2];
        DCMCommandLibraryLinux.cmdArray[1][0] = Integer.toString(1);
        DCMCommandLibraryLinux.cmdArray[1][1] = "bc";
        DCMCommandLibraryLinux.cmdArray[1][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[1][3] = "binary " + cmdArray[1][1] + " not found, please set PATH or install from " + cmdArray[1][2];
        DCMCommandLibraryLinux.cmdArray[2][0] = Integer.toString(2);
        DCMCommandLibraryLinux.cmdArray[2][1] = "df";
        DCMCommandLibraryLinux.cmdArray[2][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[2][3] = "binary " + cmdArray[2][1] + " not found, please set PATH or install from " + cmdArray[2][2];
        DCMCommandLibraryLinux.cmdArray[3][0] = Integer.toString(3);
        DCMCommandLibraryLinux.cmdArray[3][1] = "echo";
        DCMCommandLibraryLinux.cmdArray[3][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[3][3] = "binary " + cmdArray[3][1] + " not found, please set PATH or install from " + cmdArray[3][2];
        DCMCommandLibraryLinux.cmdArray[4][0] = Integer.toString(4);
        DCMCommandLibraryLinux.cmdArray[4][1] = "egrep";
        DCMCommandLibraryLinux.cmdArray[4][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[4][3] = "binary " + cmdArray[4][1] + " not found, please set PATH or install from " + cmdArray[4][2];
        DCMCommandLibraryLinux.cmdArray[5][0] = Integer.toString(5);
        DCMCommandLibraryLinux.cmdArray[5][1] = "free";
        DCMCommandLibraryLinux.cmdArray[5][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[5][3] = "binary " + cmdArray[5][1] + " not found, please set PATH or install from " + cmdArray[5][2];
        DCMCommandLibraryLinux.cmdArray[6][0] = Integer.toString(6);
        DCMCommandLibraryLinux.cmdArray[6][1] = "grep";
        DCMCommandLibraryLinux.cmdArray[6][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[6][3] = "binary " + cmdArray[6][1] + " not found, please set PATH or install from " + cmdArray[6][2];
        DCMCommandLibraryLinux.cmdArray[7][0] = Integer.toString(7);
        DCMCommandLibraryLinux.cmdArray[7][1] = "head";
        DCMCommandLibraryLinux.cmdArray[7][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[7][3] = "binary " + cmdArray[7][1] + " not found, please set PATH or install from " + cmdArray[7][2];
        DCMCommandLibraryLinux.cmdArray[8][0] = Integer.toString(8);
        DCMCommandLibraryLinux.cmdArray[8][1] = "iostat";
        DCMCommandLibraryLinux.cmdArray[8][2] = "Linux install media sysstat package";
        DCMCommandLibraryLinux.cmdArray[8][3] = "binary " + cmdArray[8][1] + " not found, please set PATH or install from " + cmdArray[8][2];
        DCMCommandLibraryLinux.cmdArray[9][0] = Integer.toString(9);
        DCMCommandLibraryLinux.cmdArray[9][1] = "mpstat";
        DCMCommandLibraryLinux.cmdArray[9][2] = "Linux install media sysstat package";
        DCMCommandLibraryLinux.cmdArray[9][3] = "binary " + cmdArray[9][1] + " not found, please set PATH or install from " + cmdArray[9][2];
        DCMCommandLibraryLinux.cmdArray[10][0] = Integer.toString(10);
        DCMCommandLibraryLinux.cmdArray[10][1] = "netstat";
        DCMCommandLibraryLinux.cmdArray[10][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[10][3] = "binary " + cmdArray[10][1] + " not found, please set PATH or install from " + cmdArray[10][2];
        DCMCommandLibraryLinux.cmdArray[11][0] = Integer.toString(11);
        DCMCommandLibraryLinux.cmdArray[11][1] = "ps";
        DCMCommandLibraryLinux.cmdArray[11][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[11][3] = "binary " + cmdArray[11][1] + " not found, please set PATH or install from " + cmdArray[11][2];
        DCMCommandLibraryLinux.cmdArray[12][0] = Integer.toString(12);
        DCMCommandLibraryLinux.cmdArray[12][1] = "sed";
        DCMCommandLibraryLinux.cmdArray[12][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[12][3] = "binary " + cmdArray[12][1] + " not found, please set PATH or install from " + cmdArray[12][2];
        DCMCommandLibraryLinux.cmdArray[13][0] = Integer.toString(13);
        DCMCommandLibraryLinux.cmdArray[13][1] = "sort";
        DCMCommandLibraryLinux.cmdArray[13][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[13][3] = "binary " + cmdArray[13][1] + " not found, please set PATH or install from " + cmdArray[13][2];
        DCMCommandLibraryLinux.cmdArray[14][0] = Integer.toString(14);
        DCMCommandLibraryLinux.cmdArray[14][1] = "tail";
        DCMCommandLibraryLinux.cmdArray[14][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[14][3] = "binary " + cmdArray[14][1] + " not found, please set PATH or install from " + cmdArray[14][2];
        DCMCommandLibraryLinux.cmdArray[15][0] = Integer.toString(15);
        DCMCommandLibraryLinux.cmdArray[15][1] = "tr";
        DCMCommandLibraryLinux.cmdArray[15][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[15][3] = "binary " + cmdArray[15][1] + " not found, please set PATH or install from " + cmdArray[15][2];
        DCMCommandLibraryLinux.cmdArray[16][0] = Integer.toString(16);
        DCMCommandLibraryLinux.cmdArray[16][1] = "w";
        DCMCommandLibraryLinux.cmdArray[16][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[16][3] = "binary " + cmdArray[16][1] + " not found, please set PATH or install from " + cmdArray[16][2];
        DCMCommandLibraryLinux.cmdArray[17][0] = Integer.toString(17);
        DCMCommandLibraryLinux.cmdArray[17][1] = "wc";
        DCMCommandLibraryLinux.cmdArray[17][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[17][3] = "binary " + cmdArray[17][1] + " not found, please set PATH or install from " + cmdArray[17][2];
        DCMCommandLibraryLinux.cmdArray[18][0] = Integer.toString(18);
        DCMCommandLibraryLinux.cmdArray[18][1] = "who";
        DCMCommandLibraryLinux.cmdArray[18][2] = "Linux install media";
        DCMCommandLibraryLinux.cmdArray[18][3] = "binary " + cmdArray[18][1] + " not found, please set PATH or install from " + cmdArray[18][2];
    }

    public String getPSCPUHostCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[11][1] + " -e -o pid,pcpu,comm | " + cmdArray[6][1] + " -iv \"pid\" | " + cmdArray[13][1] + " -k 2nr > " + this.psCPUFile + " \n";
        }
        return this.command;
    }

    public String getPSMEMHostCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[11][1] + " -e -o pid,pmem,comm | " + cmdArray[6][1] + " -iv \"pid\" | " + cmdArray[13][1] + " -k 2nr > " + this.psMEMFile + " \n";
        }
        return this.command;
    }

    public String getCPUHostCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[9][1] + " -P ALL 50 1 > " + this.mpstatDataFile + " & \n";
        }
        return this.command;
    }

    public String getCPUUSERCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^.+:\\s+" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[7][1] + " -1 | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUSYSCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^.+:\\s+" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[7][1] + " -1 | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUIDLECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^.+:\\s+" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[7][1] + " -1 | " + cmdArray[0][1] + " '{ print $11 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getCPUWIOCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^.+:\\s+" + resourceParam + " +\" " + this.mpstatDataFile + " | " + cmdArray[7][1] + " -1 | " + cmdArray[0][1] + " '{ print $6 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getWorkload() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[16][1] + " | " + cmdArray[6][1] + " -i \"average\" | " + cmdArray[0][1] + " '{ print $10 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOHostCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[8][1] + " -x -d 50 2 > " + this.iostatDataFile + " & \n";
        }
        return this.command;
    }

    public String getDiskIOReadsPerSecondQuedCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOWritesPerSecondQuedCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOReadPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $4 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOWritesPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOKBReadPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $6 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOKBWritesPerSecondCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $7 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOAverageTranscationSectorsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $8 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOAverageQueueLengthCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $9 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOAverageTranscationResponseTimeMiliSecondsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $10 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOAverageTranscationServiceTimeMiliSecondsCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $11 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getDiskIOTransactionCPUUtilizationPercentageCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[4][1] + " -ie \"^ *" + resourceParam + " +\" " + this.iostatDataFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $12 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getRAMTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[5][1] + " -m | " + cmdArray[6][1] + " Mem | " + cmdArray[0][1] + " '{ print $2 }'";
        }
        return this.command;
    }

    public String getRAMUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[5][1] + " -m | " + cmdArray[6][1] + " 'buffers/cache' | " + cmdArray[0][1] + " '{ print $3 }'";
        }
        return this.command;
    }

    public String getRAMFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[5][1] + " -m | " + cmdArray[6][1] + " 'buffers/cache' | " + cmdArray[0][1] + " '{ print $4 }'";
        }
        return this.command;
    }

    public String getSWAPTOTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[5][1] + " -m | " + cmdArray[6][1] + " Swap | " + cmdArray[0][1] + " '{ print $2 }'";
        }
        return this.command;
    }

    public String getSWAPUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[5][1] + " -m | " + cmdArray[6][1] + " Swap | " + cmdArray[0][1] + " '{ print $3 }'";
        }
        return this.command;
    }

    public String getSWAPFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[5][1] + " -m | " + cmdArray[6][1] + " Swap | " + cmdArray[0][1] + " '{ print $4 }'";
        }
        return this.command;
    }

    public String getTOTMEMCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = "ramtot=`free -m | " + cmdArray[6][1] + " Mem | " + cmdArray[0][1] + " '{ print $2 }'`; swaptot=`free -m | " + cmdArray[6][1] + " Swap | " + cmdArray[0][1] + " '{ print $2 }'` totmem=`" + cmdArray[3][1] + " \"$ramtot + $swaptot\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totmem";
        }
        return this.command;
    }

    public String getTOTUSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = "ramused=`free -m | " + cmdArray[6][1] + " \"buffers/cache\" | " + cmdArray[0][1] + " '{ print $3 }'`; swapused=`free -m | " + cmdArray[6][1] + " Swap | " + cmdArray[0][1] + " '{ print $3 }'`; totused=`" + cmdArray[3][1] + " \"$ramused + $swapused\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totused";
        }
        return this.command;
    }

    public String getTOTFREECommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = "ramfree=`free -m | " + cmdArray[6][1] + " \"buffers/cache\" | " + cmdArray[0][1] + " '{ print $4 }'`; swapfree=`free -m | " + cmdArray[6][1] + " Swap | " + cmdArray[0][1] + " '{ print $4 }'` totfree=`" + cmdArray[3][1] + " \"$ramfree + $swapfree\" | " + cmdArray[1][1] + "`; " + cmdArray[3][1] + " $totfree";
        }
        return this.command;
    }

    public String getFSTOTCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[2][1] + " -mP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[14][1] + " -1";
        }
        return this.command;
    }

    public String getFSUSEDCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[2][1] + " -mP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $3 }' | " + cmdArray[14][1] + " -1";
        }
        return this.command;
    }

    public String getFSFREECommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[2][1] + " -mP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $4 }' | " + cmdArray[14][1] + " -1";
        }
        return this.command;
    }

    public String getFSUSEDPercCommand(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[2][1] + " -mP " + resourceParam + " | " + cmdArray[0][1] + " '{ print $5 }' | " + cmdArray[14][1] + " -1 | " + cmdArray[15][1] + " -d \"%\"";
        }
        return this.command;
    }

    public String getIF_RX_OK_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $4 }'";
        }
        return this.command;
    }

    public String getIF_RX_ERR_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $5 }'";
        }
        return this.command;
    }

    public String getIF_RX_Drop_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $6 }'";
        }
        return this.command;
    }

    public String getIF_RX_OVR_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $7 }'";
        }
        return this.command;
    }

    public String getIF_TX_OK_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $8 }'";
        }
        return this.command;
    }

    public String getIF_TX_ERR_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $9 }'";
        }
        return this.command;
    }

    public String getIF_TX_Drop_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $10 }'";
        }
        return this.command;
    }

    public String getIF_TX_OVR_Command(String resourceParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -i | " + cmdArray[6][1] + " \"" + resourceParam + "\" | " + cmdArray[0][1] + " '{ print $11 }'";
        }
        return this.command;
    }

    public String getTCPSTATESTABLISHEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+ESTABLISHED\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_SENTCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+SYN_SENT\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATSYN_RECVCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+SYN_RECV\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT1Command(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+FIN_WAIT1\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATFIN_WAIT2Command(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+FIN_WAIT2\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATTIME_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+TIME_WAIT\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSEDCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+CLOSED\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSE_WAITCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+CLOSE_WAIT\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLAST_ACKCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+LAST_ACK\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATLISTENCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+LISTEN\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATCLOSINGCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+CLOSING\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getTCPSTATUNKNOWNCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[10][1] + " -an | " + cmdArray[4][1] + " -ie \"tcp.+UNKNOWN\" | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFUSERSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[18][1] + " | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getNUMOFPROCSCommand(Host hostParam) {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[11][1] + " -e | " + cmdArray[17][1] + " -l | " + cmdArray[0][1] + " '{ print $1 }'";
        }
        return this.command;
    }

    public String getPS1CPUPIDCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -1 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1CPUCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -1 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUPIDCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -2 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2CPUCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -2 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUPIDCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -3 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3CPUCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -3 " + this.psCPUFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMPIDCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -1 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS1MEMCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -1 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2MEMPIDCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -2 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS2MEMCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -2 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3MEMPIDCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -3 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $1 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String getPS3MEMCommand() {
        if (this.host.getSysinfo().contains("Linux")) {
            this.command = cmdArray[7][1] + " -3 " + this.psMEMFile + " | " + cmdArray[14][1] + " -1 | " + cmdArray[0][1] + " '{ print $2 }' | " + cmdArray[12][1] + " -e 's/,/./' -e 's/[^0-9.]//' -e 's/\\.$//'";
        }
        return this.command;
    }

    public String[][] getCommandArray() {
        return cmdArray;
    }
}

