/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import data.Host;
import data.Server;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;

public class DCMCommanderClient
extends JFrame
implements ConfigurationCaller,
DCMRemoteCommandCaller {
    private Server host;
    private ArrayList<Host> hostList;
    private StringBuffer command;
    private int sessionTimeout = 5;
    private int superuserPasswordsCounter = 0;
    private long totalCounter = 0L;
    private int serversCounter = 0;
    private int commandCounter = 0;
    private int lastCommandCounter = 0;
    private int serverInstanceCounter = 0;
    private String scriptTip = "# Commands or Script to Execute";
    private ArrayList<Server> serverList;
    private final int CMDSTAGE = 2;
    private boolean dcmDBClientIsReady = false;
    private String text;
    private static final String THISPRODUCT = "DCMCommanderClient";
    private final Configuration configuration;
    private DCMRemoteCommandCaller dcmRemoteCommandCaller;
    private ConfigurationCaller configurationCaller;
    private boolean debug = false;
    private boolean threaded = false;
    protected DCMCommanderClientRMI dcmCommanderClientRMI;
    private JEditorPane commandField;
    private JPanel commandPanel;
    private JLabel copyrightLabel;
    private JButton executeParallelButton;
    private JButton executeSequentialButton;
    private JTextArea outputArea;
    private JPanel outputPanel;
    private JScrollPane outputScroller;
    private JProgressBar progressBar;
    private JButton searchExactButton;
    private JTextField searchField;
    private JButton searchNonExactButton;
    private JPanel searchServerPanel;
    private JScrollPane searchStatsScroller;
    private JTable searchStatsTable;
    private JScrollPane selectionScroller;
    private JTextArea serversList;
    private JTextField spawnSpeed;
    private JSplitPane splitter;
    private JTextField timeoutField;
    private JScrollPane topScroller;

    public DCMCommanderClient(String dcmServerNameParam, String dcmServerPort, boolean debugParam) {
        this.debug = debugParam;
        if (!this.debug) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilteredStream filteredStream = new FilteredStream(byteArrayOutputStream);
            PrintStream aPrintStream = new PrintStream(filteredStream);
            System.setOut(aPrintStream);
            System.setErr(aPrintStream);
        } else {
            this.log("DCMCommanderClient debugging enabled...", true, true, true);
        }
        this.dcmCommanderClientRMI = new DCMCommanderClientRMI(this);
        this.setMinimumSize(new Dimension(849, 750));
        this.initComponents();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException byteArrayOutputStream) {
        }
        catch (InstantiationException byteArrayOutputStream) {
        }
        catch (IllegalAccessException byteArrayOutputStream) {
        }
        catch (UnsupportedLookAndFeelException byteArrayOutputStream) {
            // empty catch block
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
        this.dcmRemoteCommandCaller = this;
        this.configuration = new Configuration(this.configurationCaller);
        this.setTitle(DCMLicense.getProcuct() + " " + DCMLicense.getVersion());
        if (this.dcmCommanderClientRMI.connect(dcmServerNameParam, dcmServerPort)) {
            this.outputArea.append("Connected to DCMServer");
        } else {
            this.outputArea.append("Could NOT connect to DCMServer !!!");
        }
        this.commandField.setText(this.scriptTip);
        this.updateSearchStatsTable("0", "0", "0");
        this.serversListValidation();
        this.commandFieldValidation();
    }

    private void initComponents() {
        this.searchServerPanel = new JPanel();
        this.searchExactButton = new JButton();
        this.searchField = new JTextField();
        this.searchNonExactButton = new JButton();
        this.selectionScroller = new JScrollPane();
        this.serversList = new JTextArea();
        this.searchStatsScroller = new JScrollPane();
        this.searchStatsTable = new JTable();
        this.executeSequentialButton = new JButton();
        this.executeParallelButton = new JButton();
        this.timeoutField = new JTextField();
        this.spawnSpeed = new JTextField();
        this.progressBar = new JProgressBar();
        this.splitter = new JSplitPane();
        this.commandPanel = new JPanel();
        this.topScroller = new JScrollPane();
        this.commandField = new JEditorPane();
        this.outputPanel = new JPanel();
        this.outputScroller = new JScrollPane();
        this.outputArea = new JTextArea();
        this.copyrightLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(204, 204, 204));
        this.setFont(new Font("Arial", 0, 10));
        ResourceBundle bundle = ResourceBundle.getBundle(THISPRODUCT);
        this.searchServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bundle.getString("DCMCommanderClient.searchServerPanel.border.title"), 2, 2, new Font("Lucida Grande", 0, 12), new Color(102, 102, 102)));
        this.searchServerPanel.setFont(this.searchServerPanel.getFont());
        this.searchServerPanel.setOpaque(false);
        this.searchServerPanel.setPreferredSize(new Dimension(190, 314));
        this.searchExactButton.setFont(this.searchExactButton.getFont().deriveFont((float)this.searchExactButton.getFont().getSize() - 3.0f));
        this.searchExactButton.setText(bundle.getString("DCMCommanderClient.searchExactButton.text"));
        this.searchExactButton.setToolTipText(bundle.getString("DCMCommanderClient.searchExactButton.toolTipText"));
        this.searchExactButton.setHorizontalTextPosition(0);
        this.searchExactButton.setMaximumSize(new Dimension(80, 10));
        this.searchExactButton.setMinimumSize(new Dimension(80, 10));
        this.searchExactButton.setPreferredSize(new Dimension(80, 10));
        this.searchExactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMCommanderClient.this.searchExactButtonActionPerformed(evt);
            }
        });
        this.searchField.setFont(this.searchField.getFont().deriveFont((float)this.searchField.getFont().getSize() - 3.0f));
        this.searchField.setForeground(new Color(102, 102, 102));
        this.searchField.setHorizontalAlignment(0);
        this.searchField.setToolTipText(bundle.getString("DCMCommanderClient.searchField.toolTipText"));
        this.searchField.setMaximumSize(new Dimension(900, 20));
        this.searchField.setMinimumSize(new Dimension(14, 20));
        this.searchField.setPreferredSize(new Dimension(48, 20));
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DCMCommanderClient.this.searchFieldKeyReleased(evt);
            }
        });
        this.searchNonExactButton.setFont(this.searchNonExactButton.getFont().deriveFont((float)this.searchNonExactButton.getFont().getSize() - 3.0f));
        this.searchNonExactButton.setText(bundle.getString("DCMCommanderClient.searchNonExactButton.text"));
        this.searchNonExactButton.setToolTipText(bundle.getString("DCMCommanderClient.searchNonExactButton.toolTipText"));
        this.searchNonExactButton.setMaximumSize(new Dimension(80, 20));
        this.searchNonExactButton.setMinimumSize(new Dimension(80, 20));
        this.searchNonExactButton.setPreferredSize(new Dimension(112, 20));
        this.searchNonExactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMCommanderClient.this.searchNonExactButtonActionPerformed(evt);
            }
        });
        this.selectionScroller.setFont(this.selectionScroller.getFont());
        this.serversList.setBackground(new Color(204, 204, 204));
        this.serversList.setColumns(20);
        this.serversList.setFont(new Font("Courier New", 1, 8));
        this.serversList.setForeground(new Color(51, 51, 51));
        this.serversList.setRows(5);
        this.serversList.setToolTipText(bundle.getString("DCMCommanderClient.serversList.toolTipText"));
        this.serversList.setDoubleBuffered(true);
        this.serversList.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                DCMCommanderClient.this.serversListCaretUpdate(evt);
            }
        });
        this.selectionScroller.setViewportView(this.serversList);
        this.searchStatsScroller.setHorizontalScrollBarPolicy(31);
        this.searchStatsScroller.setVerticalScrollBarPolicy(21);
        this.searchStatsTable.setBackground(new Color(204, 204, 204));
        this.searchStatsTable.setFont(this.searchStatsTable.getFont().deriveFont((float)this.searchStatsTable.getFont().getSize() - 4.0f));
        this.searchStatsTable.setForeground(new Color(102, 102, 102));
        this.searchStatsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Tot", "Servers", "OS's"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, Long.class, Long.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.searchStatsTable.setAutoResizeMode(4);
        this.searchStatsTable.setAutoscrolls(false);
        this.searchStatsTable.setEnabled(false);
        this.searchStatsTable.setFocusable(false);
        this.searchStatsTable.setGridColor(new Color(51, 51, 51));
        this.searchStatsTable.setOpaque(false);
        this.searchStatsTable.setRowSelectionAllowed(false);
        this.searchStatsTable.setShowGrid(true);
        this.searchStatsScroller.setViewportView(this.searchStatsTable);
        this.executeSequentialButton.setFont(this.executeSequentialButton.getFont().deriveFont((float)this.executeSequentialButton.getFont().getSize() - 3.0f));
        this.executeSequentialButton.setText(bundle.getString("DCMCommanderClient.executeSequentialButton.text"));
        this.executeSequentialButton.setToolTipText(bundle.getString("DCMCommanderClient.executeSequentialButton.toolTipText"));
        this.executeSequentialButton.setEnabled(false);
        this.executeSequentialButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMCommanderClient.this.executeSequentialButtonActionPerformed(evt);
            }
        });
        this.executeParallelButton.setFont(this.executeParallelButton.getFont().deriveFont((float)this.executeParallelButton.getFont().getSize() - 3.0f));
        this.executeParallelButton.setText(bundle.getString("DCMCommanderClient.executeParallelButton.text"));
        this.executeParallelButton.setToolTipText(bundle.getString("DCMCommanderClient.executeParallelButton.toolTipText"));
        this.executeParallelButton.setActionCommand(bundle.getString("DCMCommanderClient.executeParallelButton.actionCommand"));
        this.executeParallelButton.setEnabled(false);
        this.executeParallelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMCommanderClient.this.executeParallelButtonActionPerformed(evt);
            }
        });
        this.timeoutField.setFont(this.timeoutField.getFont().deriveFont((float)this.timeoutField.getFont().getSize() - 3.0f));
        this.timeoutField.setHorizontalAlignment(0);
        this.timeoutField.setText(bundle.getString("DCMCommanderClient.timeoutField.text"));
        this.timeoutField.setToolTipText(bundle.getString("DCMCommanderClient.timeoutField.toolTipText"));
        this.timeoutField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.timeoutField.setSize(new Dimension(28, 26));
        this.spawnSpeed.setFont(this.spawnSpeed.getFont().deriveFont((float)this.spawnSpeed.getFont().getSize() - 3.0f));
        this.spawnSpeed.setHorizontalAlignment(0);
        this.spawnSpeed.setText(bundle.getString("DCMCommanderClient.spawnSpeed.text"));
        this.spawnSpeed.setToolTipText(bundle.getString("DCMCommanderClient.spawnSpeed.toolTipText"));
        this.spawnSpeed.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.spawnSpeed.setSize(new Dimension(28, 26));
        this.progressBar.setFont(this.progressBar.getFont().deriveFont((float)this.progressBar.getFont().getSize() - 3.0f));
        this.progressBar.setToolTipText(bundle.getString("DCMCommanderClient.progressBar.toolTipText"));
        this.progressBar.setStringPainted(true);
        GroupLayout searchServerPanelLayout = new GroupLayout((Container)this.searchServerPanel);
        this.searchServerPanel.setLayout((LayoutManager)searchServerPanelLayout);
        searchServerPanelLayout.setHorizontalGroup((GroupLayout.Group)searchServerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchServerPanelLayout.createSequentialGroup().add((Component)this.searchExactButton, -2, 103, -2).addPreferredGap(0).add((Component)this.searchField, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.searchNonExactButton, -2, 101, -2)).add(2, (Component)this.searchStatsScroller, -1, 864, Short.MAX_VALUE).add(2, (GroupLayout.Group)searchServerPanelLayout.createSequentialGroup().add((Component)this.timeoutField, -2, 19, -2).addPreferredGap(0).add((Component)this.spawnSpeed, -2, 35, -2).addPreferredGap(1).add((Component)this.progressBar, -2, 482, -2).addPreferredGap(0).add((Component)this.executeSequentialButton, -2, 0, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.executeParallelButton, -2, 135, -2)).add((Component)this.selectionScroller));
        searchServerPanelLayout.setVerticalGroup((GroupLayout.Group)searchServerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchServerPanelLayout.createSequentialGroup().add((GroupLayout.Group)searchServerPanelLayout.createParallelGroup(3).add((Component)this.searchField, -2, -1, -2).add((Component)this.searchExactButton, -2, 29, -2).add((Component)this.searchNonExactButton, -2, 25, -2)).addPreferredGap(0).add((Component)this.selectionScroller, -2, 115, -2).addPreferredGap(0).add((Component)this.searchStatsScroller, -2, 19, -2).addPreferredGap(0).add((GroupLayout.Group)searchServerPanelLayout.createParallelGroup(1, false).add((Component)this.executeParallelButton, 0, 0, Short.MAX_VALUE).add((Component)this.executeSequentialButton, 0, 0, Short.MAX_VALUE).add((Component)this.progressBar, 0, 0, Short.MAX_VALUE).add((Component)this.spawnSpeed).add((Component)this.timeoutField)).addContainerGap(13, Short.MAX_VALUE)));
        this.splitter.setDividerLocation(150);
        this.splitter.setDividerSize(2);
        this.splitter.setOrientation(0);
        this.splitter.setSize(new Dimension(244, 200));
        this.topScroller.setFont(this.topScroller.getFont());
        this.commandField.setFont(new Font("Courier New", 1, 10));
        this.commandField.setToolTipText(bundle.getString("DCMCommanderClient.commandField.toolTipText"));
        this.commandField.setPreferredSize(new Dimension(100, 50));
        this.commandField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DCMCommanderClient.this.commandFieldFocusGained(evt);
            }
        });
        this.commandField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DCMCommanderClient.this.commandFieldKeyReleased(evt);
            }
        });
        this.topScroller.setViewportView(this.commandField);
        GroupLayout commandPanelLayout = new GroupLayout((Container)this.commandPanel);
        this.commandPanel.setLayout((LayoutManager)commandPanelLayout);
        commandPanelLayout.setHorizontalGroup((GroupLayout.Group)commandPanelLayout.createParallelGroup(1).add(2, (Component)this.topScroller, -1, 872, Short.MAX_VALUE));
        commandPanelLayout.setVerticalGroup((GroupLayout.Group)commandPanelLayout.createParallelGroup(1).add(2, (Component)this.topScroller, -1, 148, Short.MAX_VALUE));
        this.splitter.setLeftComponent(this.commandPanel);
        this.outputScroller.setAutoscrolls(true);
        this.outputScroller.setFont(this.outputScroller.getFont());
        this.outputArea.setBackground(new Color(204, 204, 204));
        this.outputArea.setColumns(20);
        this.outputArea.setEditable(false);
        this.outputArea.setFont(new Font("Courier New", 1, 10));
        this.outputArea.setRows(5);
        this.outputArea.setToolTipText(bundle.getString("DCMCommanderClient.outputArea.toolTipText"));
        this.outputScroller.setViewportView(this.outputArea);
        GroupLayout outputPanelLayout = new GroupLayout((Container)this.outputPanel);
        this.outputPanel.setLayout((LayoutManager)outputPanelLayout);
        outputPanelLayout.setHorizontalGroup((GroupLayout.Group)outputPanelLayout.createParallelGroup(1).add(0, 872, Short.MAX_VALUE).add((GroupLayout.Group)outputPanelLayout.createParallelGroup(1).add((Component)this.outputScroller, -1, 872, Short.MAX_VALUE)));
        outputPanelLayout.setVerticalGroup((GroupLayout.Group)outputPanelLayout.createParallelGroup(1).add(0, 164, Short.MAX_VALUE).add((GroupLayout.Group)outputPanelLayout.createParallelGroup(1).add((Component)this.outputScroller, -1, 164, Short.MAX_VALUE)));
        this.splitter.setRightComponent(this.outputPanel);
        this.copyrightLabel.setBackground(new Color(153, 153, 153));
        this.copyrightLabel.setFont(new Font("STHeiti", 1, 14));
        this.copyrightLabel.setForeground(new Color(51, 51, 51));
        this.copyrightLabel.setHorizontalAlignment(0);
        this.copyrightLabel.setText(bundle.getString("DCMCommanderClient.copyrightLabel.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.searchServerPanel, -1, 876, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.splitter)).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.copyrightLabel, -1, 876, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.searchServerPanel, -2, 236, -2).addContainerGap(334, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(246, 246, 246).add((Component)this.splitter).addContainerGap())).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(556, Short.MAX_VALUE).add((Component)this.copyrightLabel))));
        this.pack();
    }

    private void searchExactButtonActionPerformed(ActionEvent evt) {
        this.setSelectionArea(this.searchExactHosts(this.searchField.getText()));
    }

    private void searchFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.searchField.getText().length() > 0) {
                this.setSelectionArea(this.searchNonExactHosts(this.searchField.getText()));
            } else {
                this.setSelectionArea("");
            }
        }
    }

    private void searchNonExactButtonActionPerformed(ActionEvent evt) {
        this.setSelectionArea(this.searchNonExactHosts(this.searchField.getText()));
    }

    private void serversListCaretUpdate(CaretEvent evt) {
        Thread selectionAreaCaretUpdateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                HashSet hostIdHash = new HashSet();
                HashSet<String> serverHash = new HashSet<String>();
                HashSet<String> ossHash = new HashSet<String>();
                String[] lineArray = new String[2];
                DCMCommanderClient.this.totalCounter = 0L;
                BufferedReader reader = new BufferedReader(new StringReader(DCMCommanderClient.this.serversList.getText()));
                String line = "";
                String output = "";
                try {
                    while ((line = reader.readLine()) != null) {
                        if (line.length() <= 4) continue;
                        lineArray = line.split("\\s+");
                        if (lineArray[0] != null && lineArray[0].length() > 0) {
                            DCMCommanderClient.this.totalCounter++;
                        }
                        if (lineArray[1] != null && lineArray[1].length() > 0) {
                            serverHash.add(lineArray[1]);
                        }
                        if (lineArray[2] == null || lineArray[2].length() <= 0) continue;
                        ossHash.add(lineArray[2]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                DCMCommanderClient.this.updateSearchStatsTable(Long.toString(DCMCommanderClient.this.totalCounter), Long.toString(serverHash.size()), Long.toString(ossHash.size()));
            }
        });
        selectionAreaCaretUpdateThread.setName("selectionAreaCaretUpdateThread");
        selectionAreaCaretUpdateThread.setDaemon(false);
        selectionAreaCaretUpdateThread.setPriority(5);
        selectionAreaCaretUpdateThread.start();
        this.serversListValidation();
    }

    private void executeParallelButtonActionPerformed(ActionEvent evt) {
        this.threaded = true;
        this.execute();
    }

    private void commandFieldFocusGained(FocusEvent evt) {
        if (this.commandField.getText().equals(this.scriptTip)) {
            this.commandField.setText("");
        }
    }

    private void commandFieldKeyReleased(KeyEvent evt) {
        this.commandFieldValidation();
    }

    private void executeSequentialButtonActionPerformed(ActionEvent evt) {
        this.threaded = false;
        this.execute();
    }

    private void setSelectionArea(String dataParam) {
        this.serversList.setText(dataParam);
    }

    private void serversListValidation() {
        this.serversCounter = 0;
        this.text = this.serversList.getText();
        for (int lineCounter = 0; lineCounter <= this.serversList.getLineCount(); ++lineCounter) {
            try {
                String line = this.text.substring(this.serversList.getLineStartOffset(lineCounter), this.serversList.getLineEndOffset(lineCounter));
                if (!this.contains(line, "[a-zA-Z0-9]+")) continue;
                ++this.serversCounter;
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (this.serversCounter == 0) {
            this.serversList.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0)));
        } else {
            this.serversList.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 0)));
        }
        this.validateForm();
    }

    private String searchExactHosts(String searchString) {
        this.serverList = new ArrayList();
        try {
            this.serverList = this.dcmCommanderClientRMI.getServerList();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        String output = "";
        ArrayList<Server> serverListLimited = new ArrayList();
        if (this.dcmCommanderClientRMI.getServersInLicense() < this.serverList.size()) {
            for (Server server : this.serverList.subList(0, this.dcmCommanderClientRMI.getServersInLicense())) {
                serverListLimited.add(server);
            }
        } else {
            serverListLimited = this.serverList;
        }
        if (searchString.length() > 0) {
            output = this.dcmCommanderClientRMI.searchExactHosts(this.searchField.getText(), serverListLimited);
        }
        return output;
    }

    private String searchNonExactHosts(String searchString) {
        this.serverList = new ArrayList();
        try {
            this.serverList = this.dcmCommanderClientRMI.getServerList();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        String output = "";
        ArrayList<Server> serverListLimited = new ArrayList();
        if (this.dcmCommanderClientRMI.getServersInLicense() < this.serverList.size()) {
            for (Server server : this.serverList.subList(0, this.dcmCommanderClientRMI.getServersInLicense())) {
                serverListLimited.add(server);
            }
        } else {
            serverListLimited = this.serverList;
        }
        if (searchString.length() > 0) {
            output = this.dcmCommanderClientRMI.searchNonExactHosts(this.searchField.getText(), serverListLimited);
        }
        return output;
    }

    private void commandFieldValidation() {
        this.commandCounter = this.contains(this.commandField.getText(), "[a-zA-Z0-9]+") && !this.commandField.getText().equals(this.scriptTip) ? 1 : 0;
        if (this.commandCounter == 0) {
            this.commandField.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0)));
        } else {
            this.commandField.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 0)));
        }
        this.validateForm();
    }

    private void validateForm() {
        if (this.commandCounter > 0 && this.serversCounter > 0) {
            this.executeParallelButton.setEnabled(true);
            this.executeSequentialButton.setEnabled(true);
            Thread blinkThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (DCMCommanderClient.this.lastCommandCounter != DCMCommanderClient.this.commandCounter) {
                        for (int i = 1; i <= 4; ++i) {
                            DCMCommanderClient.this.executeSequentialButton.setForeground(new Color(255, 255, 255));
                            DCMCommanderClient.this.executeParallelButton.setForeground(new Color(0, 0, 0));
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            DCMCommanderClient.this.executeSequentialButton.setForeground(new Color(0, 0, 0));
                            DCMCommanderClient.this.executeParallelButton.setForeground(new Color(255, 255, 255));
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        DCMCommanderClient.this.executeSequentialButton.setForeground(new Color(0, 0, 0));
                        DCMCommanderClient.this.executeParallelButton.setForeground(new Color(0, 0, 0));
                    }
                    DCMCommanderClient.this.lastCommandCounter = DCMCommanderClient.this.commandCounter;
                }
            });
            blinkThread.setName("blinkThread");
            blinkThread.setDaemon(false);
            blinkThread.setPriority(5);
            blinkThread.start();
        } else {
            this.executeParallelButton.setEnabled(false);
            this.executeSequentialButton.setEnabled(false);
            this.lastCommandCounter = this.commandCounter;
        }
    }

    private void updateSearchStatsTable(String hostIds, String serversParam, String ossParam) {
        this.searchStatsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Tot: " + hostIds, "Servers: " + serversParam, "OS's: " + ossParam}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, Long.class, Long.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.searchStatsTable.setAutoscrolls(false);
        this.searchStatsTable.setEnabled(false);
        this.searchStatsTable.setFocusable(false);
        this.searchStatsTable.setGridColor(new Color(204, 204, 204));
        this.searchStatsTable.setOpaque(false);
        this.searchStatsTable.setRowSelectionAllowed(false);
        this.searchStatsTable.setShowGrid(true);
        this.searchStatsTable.setShowHorizontalLines(true);
        this.searchStatsTable.getTableHeader().setFont(new Font("STHeiti", 0, 10));
        this.searchStatsTable.getTableHeader().setBackground(new Color(204, 204, 204));
        this.searchStatsTable.getTableHeader().setForeground(new Color(102, 102, 102));
        this.searchStatsScroller.setViewportView(this.searchStatsTable);
    }

    private void execute() {
        Thread executeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMCommanderClient.this.outputArea.setText("");
                DCMCommanderClient.this.sessionTimeout = Integer.parseInt(DCMCommanderClient.this.timeoutField.getText());
                DCMCommanderClient.this.hostList = new ArrayList();
                DCMCommanderClient.this.hostList = DCMCommanderClient.this.getHostList(DCMCommanderClient.this.serversList.getText());
                for (final Host host : DCMCommanderClient.this.hostList) {
                    DCMCommanderClient.this.log("host: " + host.getHostname(), true, true, true);
                }
                DCMCommanderClient.this.progressBar.setMaximum(DCMCommanderClient.this.hostList.size());
                DCMCommanderClient.this.command = new StringBuffer();
                DCMCommanderClient.this.command.append(DCMCommanderClient.this.commandField.getText());
                DCMCommanderClient.this.serverInstanceCounter = 0;
                for (final Host host : DCMCommanderClient.this.hostList) {
                    DCMCommanderClient.this.progressBar.setValue(DCMCommanderClient.this.serverInstanceCounter);
                    if (DCMCommanderClient.this.threaded) {
                        Thread parallelExecutionThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                String userPrivIndicator = "";
                                userPrivIndicator = host.getSuperuserPassword().length() == 0 ? "[U]" : "[S]";
                                DCMCommanderClient.this.log("============================= Host " + host.getHostname() + " " + userPrivIndicator + "============================", true, true, true);
                                String output = "";
                                try {
                                    output = DCMCommanderClient.this.dcmCommanderClientRMI.remoteCommand(2, host, DCMCommanderClient.this.command, true, DCMCommanderClient.this.sessionTimeout, DCMCommanderClient.this.debug);
                                }
                                catch (CloneNotSupportedException cloneNotSupportedException) {
                                    // empty catch block
                                }
                                DCMCommanderClient.this.outputArea.append(output);
                            }
                        });
                        parallelExecutionThread.setName("parallelExecutionThread");
                        parallelExecutionThread.setDaemon(false);
                        parallelExecutionThread.setPriority(5);
                        parallelExecutionThread.start();
                    } else {
                        String userPrivIndicator = "";
                        userPrivIndicator = host.getSuperuserPassword().length() == 0 ? "[U]" : "[S]";
                        DCMCommanderClient.this.log("============================= Host " + host.getHostname() + " " + userPrivIndicator + "============================", true, true, true);
                        String output = "";
                        try {
                            output = DCMCommanderClient.this.dcmCommanderClientRMI.remoteCommand(2, host, DCMCommanderClient.this.command, true, DCMCommanderClient.this.sessionTimeout, DCMCommanderClient.this.debug);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                        DCMCommanderClient.this.outputArea.append(output);
                    }
                    DCMCommanderClient.this.serverInstanceCounter++;
                    DCMCommanderClient.this.progressBar.setValue(DCMCommanderClient.this.serverInstanceCounter);
                    DCMCommanderClient.this.outputScroller.getVerticalScrollBar().setValue(DCMCommanderClient.this.outputScroller.getVerticalScrollBar().getMaximum());
                    try {
                        Thread.sleep(Integer.parseInt(DCMCommanderClient.this.spawnSpeed.getText()));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        executeThread.setName("executeThread");
        executeThread.setDaemon(false);
        executeThread.setPriority(5);
        executeThread.start();
    }

    public ArrayList<Host> getHostList(String hostLines) {
        ArrayList<Host> hostList = null;
        try {
            hostList = this.dcmCommanderClientRMI.getHostList(hostLines);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return hostList;
    }

    private boolean contains(String wholeString, String regexParam) {
        boolean output = false;
        Pattern pattern = Pattern.compile(regexParam);
        Matcher matcher = pattern.matcher(wholeString);
        if (matcher.find()) {
            output = true;
        }
        return output;
    }

    private String cleanString(String stringParam) {
        return stringParam.replaceAll("(\\r|\\n)", "");
    }

    public synchronized void log(int serverInstance, final String messageParam) {
        Thread feedbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMCommanderClient.this.outputArea.append(messageParam + "\n");
                DCMCommanderClient.this.outputScroller.getVerticalScrollBar().setValue(DCMCommanderClient.this.outputScroller.getVerticalScrollBar().getMaximum());
            }
        });
        feedbackThread.setName("feedbackThread");
        feedbackThread.setDaemon(false);
        feedbackThread.setPriority(5);
        feedbackThread.start();
    }

    @Override
    public void log(final String messageParam, boolean logToStatusParam, boolean logToApplicationParam, boolean logToFileParam) {
        Thread logThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (messageParam != null && DCMCommanderClient.this.outputArea != null) {
                    DCMCommanderClient.this.outputArea.append(messageParam + "\n");
                    DCMCommanderClient.this.outputScroller.getVerticalScrollBar().setValue(DCMCommanderClient.this.outputScroller.getVerticalScrollBar().getMaximum());
                }
            }
        });
        logThread.setName("logThread");
        logThread.setDaemon(false);
        logThread.setPriority(5);
        logThread.start();
    }

    public void dbClientReady() {
        this.dcmDBClientIsReady = true;
    }

    public void updatedHost() {
    }

    @Override
    public synchronized void remoteFinalCommandSuccessResponse(int stageParam, final String stdOutParam, String stdErrParam) {
        Thread remoteFinalCommandSuccessResponseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMCommanderClient.this.outputArea.append(stdOutParam + "\n");
                DCMCommanderClient.this.outputScroller.getVerticalScrollBar().setValue(DCMCommanderClient.this.outputScroller.getVerticalScrollBar().getMaximum());
            }
        });
        remoteFinalCommandSuccessResponseThread.setName("remoteFinalCommandSuccessResponseThread");
        remoteFinalCommandSuccessResponseThread.setDaemon(false);
        remoteFinalCommandSuccessResponseThread.setPriority(5);
        remoteFinalCommandSuccessResponseThread.start();
    }

    @Override
    public synchronized void remoteCommandSuccessResponse(int stageParam, final String stdOutParam, String stdErrParam) {
        Thread remoteCommandSuccessResponseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMCommanderClient.this.outputArea.append(stdOutParam + "\n");
                DCMCommanderClient.this.outputScroller.getVerticalScrollBar().setValue(DCMCommanderClient.this.outputScroller.getVerticalScrollBar().getMaximum());
            }
        });
        remoteCommandSuccessResponseThread.setName("remoteCommandSuccessResponseThread");
        remoteCommandSuccessResponseThread.setDaemon(false);
        remoteCommandSuccessResponseThread.setPriority(5);
        remoteCommandSuccessResponseThread.start();
    }

    @Override
    public synchronized void remoteCommandFailureResponse(int stageParam, final String messageParam) {
        Thread remoteCommandFailureResponseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMCommanderClient.this.outputArea.append(messageParam + "\n");
                DCMCommanderClient.this.outputScroller.getVerticalScrollBar().setValue(DCMCommanderClient.this.outputScroller.getVerticalScrollBar().getMaximum());
            }
        });
        remoteCommandFailureResponseThread.setName("remoteCommandFailureResponseThread");
        remoteCommandFailureResponseThread.setDaemon(false);
        remoteCommandFailureResponseThread.setPriority(5);
        remoteCommandFailureResponseThread.start();
    }

    @Override
    public void inventoryReady(Server serverParam) {
    }

    private static void usage() {
        System.out.println("\n");
        System.out.println("Usage:   java -cp DCManager.jar DCMCommander [--debug]\n");
        System.out.println(DCMLicense.getCopyright());
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

