/*
 * Decompiled with CFR 0.152.
 */
import data.Host;
import data.RMIMessage;
import data.Server;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;

public class DCMCommanderClientRMI
implements Serializable {
    private DCMServerRMI dcmServerRMI;
    String rmiserver;
    private static Registry registry;
    private boolean rmiOK = true;
    private DCMCommanderClient dcmCommanderClient;
    private DCMCommanderClientRMI dcmCommanderClientRMI = this;
    private ArrayList<RMIMessage> rmiMessageList;

    public DCMCommanderClientRMI(DCMCommanderClient dcmCommanderClientParam) {
        this.dcmCommanderClient = dcmCommanderClientParam;
        this.rmiMessageList = new ArrayList();
    }

    public boolean connect(final String serverParam, final String portParam) {
        Thread rmiConnectThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMCommanderClientRMI.this.rmiOK = true;
                System.getProperties().put("java.rmi.server.hostname", serverParam);
                try {
                    registry = LocateRegistry.getRegistry(serverParam, Integer.parseInt(portParam));
                }
                catch (RemoteException ex) {
                    DCMCommanderClientRMI.this.dcmCommanderClient.log("Error: Client(,,): RemoteException: LocateRegistry.getRegistry(); " + ex.getMessage(), true, true, true);
                    DCMCommanderClientRMI.this.rmiOK = false;
                }
                try {
                    DCMCommanderClientRMI.this.dcmServerRMI = (DCMServerRMI)registry.lookup("ServerRMI");
                }
                catch (RemoteException ex) {
                    DCMCommanderClientRMI.this.dcmCommanderClient.log("Error: DCMCommanderClient(,,): RemoteException: registry.lookup(\"ServerRMI\")); " + ex.getMessage(), true, true, true);
                    DCMCommanderClientRMI.this.rmiOK = false;
                }
                catch (NotBoundException ex) {
                    DCMCommanderClientRMI.this.dcmCommanderClient.log("Error: DCMCommanderClient(,,): NotBoundException: registry.lookup(\"ServerRMI\")); " + ex.getMessage(), true, true, true);
                    DCMCommanderClientRMI.this.rmiOK = false;
                }
            }
        });
        rmiConnectThread.setName("rmiConnectThread");
        rmiConnectThread.setDaemon(false);
        rmiConnectThread.setPriority(5);
        rmiConnectThread.start();
        try {
            rmiConnectThread.join(60000L);
        }
        catch (InterruptedException ex) {
            System.out.println("Error: DCMCommanderClientRMI: connect(,,): InterruptedException: \")); " + ex.getMessage());
            this.rmiOK = false;
        }
        return this.rmiOK;
    }

    public ArrayList<Host> getHostList(String hostLinesParam) throws CloneNotSupportedException {
        ArrayList<Host> hostList = new ArrayList();
        try {
            hostList = this.dcmServerRMI.getHostList(hostLinesParam);
        }
        catch (RemoteException ex) {
            this.dcmCommanderClient.log("Error: : RemoteException: getHostList " + ex.getMessage(), true, true, true);
        }
        return hostList;
    }

    public ArrayList<Server> getServerList() throws CloneNotSupportedException {
        ArrayList<Server> serverList = new ArrayList();
        try {
            serverList = this.dcmServerRMI.getServerList();
        }
        catch (RemoteException ex) {
            this.dcmCommanderClient.log("Error: : RemoteException: getServerList " + ex.getMessage(), true, true, true);
        }
        return serverList;
    }

    public String searchExactHosts(String searchString, ArrayList<Server> serverList) {
        String selectedHosts = "";
        try {
            selectedHosts = this.dcmServerRMI.searchExactHosts(searchString, serverList);
        }
        catch (RemoteException ex) {
            this.dcmCommanderClient.log("Error: : RemoteException: searchExactHosts " + ex.getMessage(), true, true, true);
        }
        return selectedHosts;
    }

    public String searchNonExactHosts(String searchString, ArrayList<Server> serverList) {
        String selectedHosts = "";
        try {
            selectedHosts = this.dcmServerRMI.searchNonExactHosts(searchString, serverList);
        }
        catch (RemoteException ex) {
            this.dcmCommanderClient.log("Error: : RemoteException: searchNonExactHosts " + ex.getMessage(), true, true, true);
        }
        return selectedHosts;
    }

    public int getServersInLicense() {
        int serversInLicense = 0;
        try {
            serversInLicense = this.dcmServerRMI.getServersInLicense();
        }
        catch (RemoteException ex) {
            this.dcmCommanderClient.log("Error: : RemoteException: getServersInLicense " + ex.getMessage(), true, true, true);
        }
        return serversInLicense;
    }

    public String remoteCommand(int cmdStage, Host hostParam, StringBuffer commandParam, boolean finalCommand, int timeoutParam, boolean debug) throws CloneNotSupportedException {
        String output = "";
        try {
            output = this.dcmServerRMI.remoteCommand(cmdStage, hostParam, commandParam, finalCommand, timeoutParam, debug);
        }
        catch (RemoteException ex) {
            this.dcmCommanderClient.log("Error: : RemoteException: getHostList " + ex.getMessage(), true, true, true);
        }
        return output;
    }
}

