/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import data.DCMPreset;
import data.DCMUser;
import data.Host;
import data.MD5Converter;
import data.RMIMessage;
import data.Resource;
import data.Server;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;

public class DCMDBClient
extends Thread
implements ConfigurationCaller {
    private boolean dbServerTest = true;
    private DCMDBClientCaller dcmDBClientCaller;
    public static final String DERBY_CLIENT_DRIVER = "org.apache.derby.jdbc.ClientDriver";
    private static final String DERBY_CLIENT_DS = "org.apache.derby.jdbc.ClientDataSource";
    String jdbcDriver = "org.apache.derby.jdbc.ClientDriver";
    String jdbcDataSource = "org.apache.derby.jdbc.ClientDataSource";
    private ArrayList statements = new ArrayList();
    private PreparedStatement psInsertServer = null;
    private PreparedStatement psUpdateServer = null;
    private PreparedStatement psInsertDCMTijd = null;
    private PreparedStatement psUpdateDCMTijd = null;
    private PreparedStatement psInsertDCMUser = null;
    private PreparedStatement psUpdateDCMUser = null;
    private PreparedStatement psInsertDCMPreset = null;
    private PreparedStatement psUpdateDCMPreset = null;
    private PreparedStatement psInsertHost = null;
    private PreparedStatement psUpdateHost = null;
    private PreparedStatement psInsertResource = null;
    private PreparedStatement psUpdateResource = null;
    private PreparedStatement psUpdateResourceValue = null;
    private PreparedStatement psExportDCMUserTable = null;
    private PreparedStatement psExportDCMPresetTable = null;
    private PreparedStatement psExportHostTable = null;
    private PreparedStatement psExportResourceTable = null;
    private PreparedStatement psImportDCMUserTable = null;
    private PreparedStatement psImportDCMPresetTable = null;
    private PreparedStatement psImportHostTable = null;
    private PreparedStatement psImportResourceTable = null;
    private final String protocol = "jdbc:derby:";
    private final String dbServerAddress = "//127.0.0.1:1527/";
    private String database = "";
    private final String attributes = ";create=false";
    private final String url = "jdbc:derby://127.0.0.1:1527/" + this.database + ";create=false";
    private final String user = "dbadmin";
    private final String toegang = "IsNwtNp4DB";
    private Thread dbServerThread;
    private ResultSetMetaData resultsetmetadata = null;
    boolean runThreadsAsDaemons = true;
    private Connection connection = null;
    private static boolean dbServerInit = false;
    private DCMShell shell = null;
    private boolean daemon = false;
    private boolean debug = false;
    private Properties props;
    private Configuration configuration;

    public DCMDBClient(DCMDBClientCaller DCMDBClientCallerParam, String databaseParam, boolean daemonParam, boolean debugParam) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, Exception {
        this.dcmDBClientCaller = DCMDBClientCallerParam;
        this.daemon = daemonParam;
        this.debug = debugParam;
        this.shell = new DCMShell(this.debug);
        this.dcmDBClientCaller.log("Action:  DCMDBClient Invoked", true, true, true);
        this.configuration = new Configuration(this);
        String[] status = new String[2];
        status = new String[2];
        this.database = databaseParam;
        System.setProperty("derby.system.home", this.configuration.getDatabasesDir());
        this.props = new Properties();
        this.props.setProperty("derby.system.home", this.configuration.getDatabasesDir());
        this.props.setProperty("databaseName", this.database);
        this.props.setProperty("user", "dbadmin");
        this.props.setProperty("password", "IsNwtNp4DB");
        this.loadDriver();
        this.connection = this.initDatabaseClientServer();
        this.test(this.connection);
        this.connection.setAutoCommit(false);
        this.checkTables();
        this.initPrepareStatements();
        this.dcmDBClientCaller.dbClientReady();
    }

    public void loadDriver() {
        try {
            Class.forName(this.jdbcDriver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client Failed Loading Driver " + this.jdbcDriver, true, true, true);
            cnfe.printStackTrace(System.err);
        }
        catch (InstantiationException ie) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client Failed Instantiate JDBC driver " + this.jdbcDriver, true, true, true);
            ie.printStackTrace(System.err);
        }
        catch (IllegalAccessException iae) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client NOT Allowed Access to JDBC Driver " + this.jdbcDriver, true, true, true);
            iae.printStackTrace(System.err);
        }
    }

    public Connection initDatabaseClientServer() {
        Connection tmpConnection = null;
        boolean dbServerStarted = false;
        boolean dbServerRunning = true;
        do {
            dbServerRunning = true;
            try {
                tmpConnection = DriverManager.getConnection(this.url, this.props);
            }
            catch (SQLException ex) {
                dbServerRunning = false;
                if (!dbServerStarted) {
                    String javaParam = "";
                    javaParam = this.daemon ? " --daemon " : "";
                    this.shell.startJavaDBServer(128, "", javaParam);
                    dbServerStarted = true;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!dbServerRunning);
        this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Connection Opened", true, true, true);
        try {
            tmpConnection.clearWarnings();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: tmpConnection.clearWarnings()", true, true, true);
        }
        return tmpConnection;
    }

    public Connection getDriverClientConnection() {
        this.loadDriver();
        boolean notConnected = false;
        Connection tmpConnection = null;
        do {
            try {
                tmpConnection = DriverManager.getConnection(this.url, this.props);
            }
            catch (SQLException ex) {
                notConnected = true;
                this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client Connection Failed: " + ex.getMessage(), true, true, true);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (notConnected);
        return tmpConnection;
    }

    public void test(Connection conn) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select count(*) from sys.systables");
            while (rs.next()) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Connection Established", true, true, true);
            }
        }
        catch (SQLException sqle) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client Connection NOT Established: " + sqle.getMessage(), true, true, true);
            throw sqle;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void shutdownDB(String databaseParam) {
        try {
            DriverManager.getConnection("jdbc:derby:" + databaseParam + ";password=" + "IsNwtNp4DB" + ";shutdown=true");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Server Failed to Shutdown: " + ex.getMessage(), true, true, true);
        }
    }

    public void dropDatabase(String databaseParam) {
        Statement statement = null;
        Object resultset = null;
        this.shutdownDB(databaseParam);
        try {
            statement.execute("Error:  DCMDBClient: DROP DATABASE " + databaseParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client Failed to Drop Database: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void exportInventory() {
        boolean success = true;
        String backupFileString = this.configuration.getBackupDir() + "DCMUser.csv";
        File backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            if (backupFile.delete()) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Removed existing backup file: " + backupFile.getName(), true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Could not remove backup file: " + backupFile.getName(), true, true, true);
            }
        }
        try {
            this.psExportDCMUserTable.setString(1, "APP");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMUserTable.setString(2, "DCMUSER");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMUserTable.setString(3, backupFileString);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMUserTable.setString(4, ",");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMUserTable.setString(5, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMUserTable.setString(6, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMUserTable.execute();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory. connection.commit(): " + ex.getMessage(), true, true, true);
        }
        if (success) {
            this.dcmDBClientCaller.log("Success: DCMDBClient: Exported backup file: " + backupFile.getName() + " (Beware: Delete this sensitive file ASAP!!!)", true, true, true);
        } else {
            this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to export backup file: " + backupFile.getName(), true, true, true);
        }
        success = true;
        backupFileString = this.configuration.getBackupDir() + "DCMPreset.csv";
        backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            if (backupFile.delete()) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Removed existing backup file: " + backupFile.getName(), true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Could not remove backup file: " + backupFile.getName(), true, true, true);
            }
        }
        try {
            this.psExportDCMPresetTable.setString(1, "APP");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMPresetTable.setString(2, "DCMPRESET");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMPresetTable.setString(3, backupFileString);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMPresetTable.setString(4, ",");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMPresetTable.setString(5, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMPresetTable.setString(6, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMPresetTable.execute();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory. connection.commit(): " + ex.getMessage(), true, true, true);
        }
        if (success) {
            this.dcmDBClientCaller.log("Success: DCMDBClient: Exported backup file: " + backupFile.getName(), true, true, true);
        } else {
            this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to export backup file: " + backupFile.getName(), true, true, true);
        }
        success = true;
        backupFileString = this.configuration.getBackupDir() + "Host.csv";
        backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            if (backupFile.delete()) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Removed existing backup file: " + backupFile.getName(), true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Could not remove backup file: " + backupFile.getName(), true, true, true);
            }
        }
        try {
            this.psExportHostTable.setString(1, "APP");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportHostTable.setString(2, "HOST");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportHostTable.setString(3, backupFileString);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportHostTable.setString(4, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportHostTable.setString(5, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportHostTable.setString(6, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportHostTable.execute();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory. connection.commit(): " + ex.getMessage(), true, true, true);
        }
        if (success) {
            this.dcmDBClientCaller.log("Success: DCMDBClient: Exported backup file: " + backupFile.getName() + " (Beware: Delete this extremely sensitive file ASAP!!!)", true, true, true);
        } else {
            this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to export backup file: " + backupFile.getName(), true, true, true);
        }
        success = true;
        backupFileString = this.configuration.getBackupDir() + "Resource.csv";
        backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            if (backupFile.delete()) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Removed existing backup file: " + backupFile.getName(), true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Could not remove backup file: " + backupFile.getName(), true, true, true);
            }
        }
        try {
            this.psExportResourceTable.setString(1, "APP");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportResourceTable.setString(2, "RESOURCE");
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportResourceTable.setString(3, backupFileString);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportResourceTable.setString(4, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportResourceTable.setString(5, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportResourceTable.setString(6, null);
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportResourceTable.execute();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            success = false;
            this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory. connection.commit(): " + ex.getMessage(), true, true, true);
        }
        if (success) {
            this.dcmDBClientCaller.log("Success: DCMDBClient: Exported backup file: " + backupFile.getName(), true, true, true);
        } else {
            this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to export backup file: " + backupFile.getName(), true, true, true);
        }
    }

    public void importInventory() {
        boolean success;
        String backupFileString = this.configuration.getBackupDir() + "DCMUser.csv";
        File backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            success = true;
            try {
                this.psImportDCMUserTable.setString(1, "APP");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMUserTable.setString(2, "DCMUSER");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMUserTable.setString(3, backupFileString);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMUserTable.setString(4, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMUserTable.setString(5, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMUserTable.setString(6, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMUserTable.setInt(7, 1);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMUserTable.execute();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory. connection.commit(): " + ex.getMessage(), true, true, true);
            }
            if (success) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Imported backup file: " + backupFile.getName() + " (Beware: Delete this sensitive file ASAP!!!)", true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to import backup file: " + backupFile.getName(), true, true, true);
            }
        } else {
            this.dcmDBClientCaller.log("Warning: DCMDBClient: Backup file: " + backupFile.getName() + " does not exist!", true, true, true);
        }
        backupFileString = this.configuration.getBackupDir() + "DCMPreset.csv";
        backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            success = true;
            try {
                this.psImportDCMPresetTable.setString(1, "APP");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMPresetTable.setString(2, "DCMPRESET");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMPresetTable.setString(3, backupFileString);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMPresetTable.setString(4, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMPresetTable.setString(5, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMPresetTable.setString(6, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMPresetTable.setInt(7, 1);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportDCMPresetTable.execute();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory. connection.commit(): " + ex.getMessage(), true, true, true);
            }
            if (success) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Imported backup file: " + backupFile.getName(), true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to import backup file: " + backupFile.getName(), true, true, true);
            }
        } else {
            this.dcmDBClientCaller.log("Warning: DCMDBClient: Backup file: " + backupFile.getName() + " does not exist!", true, true, true);
        }
        backupFileString = this.configuration.getBackupDir() + "Host.csv";
        backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            success = true;
            try {
                this.psImportHostTable.setString(1, "APP");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportHostTable.setString(2, "HOST");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportHostTable.setString(3, backupFileString);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportHostTable.setString(4, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportHostTable.setString(5, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportHostTable.setString(6, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportHostTable.setInt(7, 1);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportHostTable.execute();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory. connection.commit(): " + ex.getMessage(), true, true, true);
            }
            if (success) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Imported backup file: " + backupFile.getName() + " (Beware: Delete this extremely sensitive file ASAP!!!)", true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to import backup file: " + backupFile.getName(), true, true, true);
            }
        } else {
            this.dcmDBClientCaller.log("Warning: DCMDBClient: Backup file: " + backupFile.getName() + " does not exist!", true, true, true);
        }
        backupFileString = this.configuration.getBackupDir() + "Resource.csv";
        backupFile = new File(backupFileString);
        if (backupFile.exists()) {
            success = true;
            try {
                this.psImportResourceTable.setString(1, "APP");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportResourceTable.setString(2, "RESOURCE");
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportResourceTable.setString(3, backupFileString);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportResourceTable.setString(4, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportResourceTable.setString(5, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportResourceTable.setString(6, null);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportResourceTable.setInt(7, 1);
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psImportResourceTable.execute();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.importInventory.: " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                success = false;
                this.dcmDBClientCaller.log("Error: DCMDBClient.exportInventory. connection.commit(): " + ex.getMessage(), true, true, true);
            }
            if (success) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: Imported backup file: " + backupFile.getName(), true, true, true);
            } else {
                this.dcmDBClientCaller.log("Failure: DCMDBClient: Failed to import backup file: " + backupFile.getName(), true, true, true);
            }
        } else {
            this.dcmDBClientCaller.log("Warning: DCMDBClient: Backup file: " + backupFile.getName() + " does not exist!", true, true, true);
        }
    }

    public synchronized void createDCMTijdTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMTijdTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            this.loadDriver();
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.DCMTijd( Id BIGINT,Tijd BIGINT )");
        }
        catch (SQLException ex1) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.createDCMTijdTable(): " + ex1.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMTijdTable(): INSERT INTO APP.DCMTijd.. connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("INSERT INTO APP.DCMTijd VALUES (0, 0)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMTijdTable(): INSERT INTO APP.DCMTijd.. connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMTijdTable(): INSERT INTO APP.DCMTijd.. connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMTijdTable(): INSERT INTO APP.DCMTijd.. connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
    }

    public synchronized Calendar getDCMTijd() {
        Statement statement = null;
        ResultSet resultset = null;
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMTijdByUsername->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.DCMTijd WHERE Id = 0");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                cal.setTimeInMillis(resultset.getLong(2));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getUserByUsername : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return cal;
    }

    public synchronized void insertDCMTijd(Calendar calParam) {
        try {
            this.psInsertDCMTijd.setLong(1, 0L);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMTijd.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMTijd.setLong(2, calParam.getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMTijd.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMTijd.execute();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMTijd: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMTijd : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void updateDCMTijd(Calendar calParam) {
        ArrayList rmiMessageList = new ArrayList();
        try {
            this.psUpdateDCMTijd.setLong(1, calParam.getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMTijd.setLong(2, 0L);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMTijd.executeUpdate();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMTijd : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void deleteDCMTijd(long idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteDCMTijd(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.DCMTijd WHERE Id = 0");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteDCMTijd: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void createDCMUserTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMUserTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            this.loadDriver();
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.DCMUser( Id BIGINT generated by default as identity (START WITH 0, INCREMENT BY 1),Username VARCHAR(100) PRIMARY KEY,Password VARCHAR(100),Administrator INT )");
        }
        catch (SQLException ex1) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.createDCMUserTable(): " + ex1.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        String adminpw = MD5Converter.getMD5SumFromString("admin");
        String dcmpw = MD5Converter.getMD5SumFromString("dcm");
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMUserTable(): INSERT INTO APP.DCMUser.. connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("INSERT INTO APP.DCMUser VALUES (DEFAULT,'admin','" + adminpw + "',1)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMUserTable(): INSERT INTO APP.DCMUser.. connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMUserTable(): INSERT INTO APP.DCMUser.. connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMUserTable(): INSERT INTO APP.DCMUser.. connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("INSERT INTO APP.DCMUser VALUES (DEFAULT,'dcm','" + dcmpw + "',0)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMUserTable(): INSERT INTO APP.DCMUser.. connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMUserTable(): INSERT INTO APP.DCMUser.. connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized DCMUser getDCMUserByUsername(String hostnameParam) {
        Statement statement = null;
        ResultSet resultset = null;
        DCMUser dcmUser = new DCMUser();
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMUserByUsername->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.DCMUser WHERE Username = '" + hostnameParam + "'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                dcmUser.setId(resultset.getLong(1));
                dcmUser.setUsername(resultset.getString(2));
                dcmUser.setPassword(resultset.getString(3));
                dcmUser.setAdministrator(resultset.getInt(4) != 0);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getUserByUsername : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return dcmUser;
    }

    public synchronized DCMUser getDCMUser(long idParam) {
        Statement statement = null;
        ResultSet resultset = null;
        DCMUser dcmUser = new DCMUser();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMUserByUsername->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.DCMUser WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                dcmUser = new DCMUser();
                dcmUser.setId(resultset.getLong(1));
                dcmUser.setUsername(resultset.getString(2));
                dcmUser.setPassword(resultset.getString(3));
                dcmUser.setAdministrator(resultset.getInt(4) != 0);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getUserByUsername : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return dcmUser;
    }

    public synchronized ArrayList<DCMUser> getDCMUserList() {
        Statement statement = null;
        ResultSet resultset = null;
        ArrayList<DCMUser> dcmUserList = new ArrayList<DCMUser>();
        dcmUserList.clear();
        DCMUser user = new DCMUser();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMUserByUsername->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.DCMUser ORDER BY Id");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                user = new DCMUser();
                user.setId(resultset.getLong(1));
                user.setUsername(resultset.getString(2));
                user.setPassword(resultset.getString(3));
                user.setAdministrator(resultset.getInt(4) != 0);
                dcmUserList.add(user);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getUserByUsername : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return dcmUserList;
    }

    public synchronized boolean authenticateDCMUser(String usernameParam, String passwordParam) {
        Statement statement = null;
        ResultSet resultset = null;
        boolean authenticated = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: authenticateDCMUser->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.DCMUser WHERE Username = '" + usernameParam + "' AND Password = '" + passwordParam + "'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                authenticated = true;
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: authenticateDCMUser->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.authenticateDCMUser : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return authenticated;
    }

    public synchronized void insertDCMUser(DCMUser dcmUserParam) {
        try {
            this.psInsertDCMUser.setString(1, dcmUserParam.getUsername());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMUser.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMUser.setString(2, dcmUserParam.getPassword());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMUser.setInt(3, dcmUserParam.getAdministrator() ? 1 : 0);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMUser.execute();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMUser : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void updateDCMUser(DCMUser dcmUserParam) {
        ArrayList rmiMessageList = new ArrayList();
        try {
            this.psUpdateDCMUser.setString(1, dcmUserParam.getUsername());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMUser.setString(2, dcmUserParam.getPassword());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMUser.setInt(3, dcmUserParam.getAdministrator() ? 1 : 0);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMUser.setLong(4, dcmUserParam.getId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMUser.executeUpdate();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMUser : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void deleteDCMUser(long idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteDCMUser(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.DCMUser WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteDCMUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void dropDCMUserTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: dropDCMUserTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.DCMUser");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropDCMUserTable: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropDCMUserTable : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void createDCMPresetTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createDCMPresetTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            this.loadDriver();
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.DCMPreset( Id BIGINT generated by default as identity (START WITH 0, INCREMENT BY 1),UserId BIGINT,ViewName VARCHAR(100),ViewDescription VARCHAR(1000),StartCalendarRelative BOOLEAN,StartCalendar BIGINT,StartMonthSupplement INT,StartDaySupplement INT,StartHourSupplement INT,StartMinuteSupplement INT,EndCalendarRelative BOOLEAN,EndCalendar BIGINT,EndMonthSupplement INT,EndDaySupplement INT,EndHourSupplement INT,EndMinuteSupplement INT,EnableSearch BOOLEAN,SearchString VARCHAR(1000),SearchExact BOOLEAN,SelectedResources LONG VARCHAR,Shared BOOLEAN )");
        }
        catch (SQLException ex1) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.createDCMPresetTable(): " + ex1.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized DCMPreset getDCMPreset(long idParam) {
        Calendar cal = Calendar.getInstance();
        Statement statement = null;
        ResultSet resultset = null;
        DCMPreset DCMPreset2 = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMPresetByUsername->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.DCMPreset WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMPreset->statement.executeQuery(\"SELECT * FROM APP.DCMPreset\"): " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                DCMPreset2 = new DCMPreset();
                DCMPreset2.setId(resultset.getLong(1));
                DCMPreset2.setUserId(resultset.getLong(2));
                DCMPreset2.setPresetName(resultset.getString(3));
                DCMPreset2.setPresetDescription(resultset.getString(4));
                DCMPreset2.setStartCalendarRelative(resultset.getBoolean(5));
                cal = Calendar.getInstance();
                cal.setTimeInMillis(resultset.getLong(6));
                DCMPreset2.setStartCalendar(cal);
                DCMPreset2.setStartMonthSupplement(resultset.getInt(7));
                DCMPreset2.setStartDaySupplement(resultset.getInt(8));
                DCMPreset2.setStartHourSupplement(resultset.getInt(9));
                DCMPreset2.setStartMinuteSupplement(resultset.getInt(10));
                DCMPreset2.setEndCalendarRelative(resultset.getBoolean(11));
                cal = Calendar.getInstance();
                cal.setTimeInMillis(resultset.getLong(12));
                DCMPreset2.setEndCalendar(cal);
                DCMPreset2.setEndMonthSupplement(resultset.getInt(13));
                DCMPreset2.setEndDaySupplement(resultset.getInt(14));
                DCMPreset2.setEndHourSupplement(resultset.getInt(15));
                DCMPreset2.setEndMinuteSupplement(resultset.getInt(16));
                DCMPreset2.setEnableSearch(resultset.getBoolean(17));
                DCMPreset2.setSearchString(resultset.getString(18));
                DCMPreset2.setSearchExact(resultset.getBoolean(19));
                DCMPreset2.setSelectedResources(resultset.getString(20));
                DCMPreset2.setShared(resultset.getBoolean(21));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMPreset->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getUserByUsername : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return DCMPreset2;
    }

    public synchronized ArrayList<DCMPreset> getDCMPresetList() {
        Calendar cal = Calendar.getInstance();
        Statement statement = null;
        ResultSet resultset = null;
        ArrayList<DCMPreset> DCMPresetList = new ArrayList<DCMPreset>();
        DCMPresetList.clear();
        DCMPreset DCMPreset2 = new DCMPreset();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMUserByUsername->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.DCMPreset ORDER BY Id");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getDCMPresetList->statement.executeQuery(\"SELECT * FROM APP.DCMPreset\"): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                DCMPreset2 = new DCMPreset();
                DCMPreset2.setId(resultset.getLong(1));
                DCMPreset2.setUserId(resultset.getLong(2));
                DCMPreset2.setPresetName(resultset.getString(3));
                DCMPreset2.setPresetDescription(resultset.getString(4));
                DCMPreset2.setStartCalendarRelative(resultset.getBoolean(5));
                cal.setTimeInMillis(resultset.getLong(6));
                DCMPreset2.setStartCalendar(cal);
                DCMPreset2.setStartMonthSupplement(resultset.getInt(7));
                DCMPreset2.setStartDaySupplement(resultset.getInt(8));
                DCMPreset2.setStartHourSupplement(resultset.getInt(9));
                DCMPreset2.setStartMinuteSupplement(resultset.getInt(10));
                DCMPreset2.setEndCalendarRelative(resultset.getBoolean(11));
                cal.setTimeInMillis(resultset.getLong(12));
                DCMPreset2.setEndCalendar(cal);
                DCMPreset2.setEndMonthSupplement(resultset.getInt(13));
                DCMPreset2.setEndDaySupplement(resultset.getInt(14));
                DCMPreset2.setEndHourSupplement(resultset.getInt(15));
                DCMPreset2.setEndMinuteSupplement(resultset.getInt(16));
                DCMPreset2.setEnableSearch(resultset.getBoolean(17));
                DCMPreset2.setSearchString(resultset.getString(18));
                DCMPreset2.setSearchExact(resultset.getBoolean(19));
                DCMPreset2.setSelectedResources(resultset.getString(20));
                DCMPreset2.setShared(resultset.getBoolean(21));
                DCMPresetList.add(DCMPreset2);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getUserByUsername->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getUserByUsername : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return DCMPresetList;
    }

    public synchronized void insertDCMPreset(DCMPreset DCMPresetParam) {
        try {
            this.psInsertDCMPreset.setLong(1, DCMPresetParam.getUserId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setString(2, DCMPresetParam.getPresetName());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setString(3, DCMPresetParam.getPresetDescription());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setBoolean(4, DCMPresetParam.getStartCalendarRelative());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setLong(5, DCMPresetParam.getStartCalendar().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(6, DCMPresetParam.getStartMonthSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(7, DCMPresetParam.getStartDaySupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(8, DCMPresetParam.getStartHourSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(9, DCMPresetParam.getStartMinuteSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setBoolean(10, DCMPresetParam.getEndCalendarRelative());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setLong(11, DCMPresetParam.getEndCalendar().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(12, DCMPresetParam.getEndMonthSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(13, DCMPresetParam.getEndDaySupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(14, DCMPresetParam.getEndHourSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setInt(15, DCMPresetParam.getEndMinuteSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setBoolean(16, DCMPresetParam.getEnableSearch());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setString(17, DCMPresetParam.getSearchString());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setBoolean(18, DCMPresetParam.getSearchExact());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setString(19, DCMPresetParam.getSelectedResources());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.setBoolean(20, DCMPresetParam.getShared());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset.execute();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void updateDCMPreset(DCMPreset userViewParam) {
        ArrayList rmiMessageList = new ArrayList();
        try {
            this.psUpdateDCMPreset.setLong(1, userViewParam.getUserId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setString(2, userViewParam.getPresetName());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setString(3, userViewParam.getPresetDescription());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setBoolean(4, userViewParam.getStartCalendarRelative());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setLong(5, userViewParam.getStartCalendar().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(6, userViewParam.getStartMonthSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(7, userViewParam.getStartDaySupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(8, userViewParam.getStartHourSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(9, userViewParam.getStartMinuteSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setBoolean(10, userViewParam.getEndCalendarRelative());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setLong(11, userViewParam.getEndCalendar().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(12, userViewParam.getEndMonthSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(13, userViewParam.getEndDaySupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(14, userViewParam.getEndHourSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setInt(15, userViewParam.getEndMinuteSupplement());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setBoolean(16, userViewParam.getEnableSearch());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setString(17, userViewParam.getSearchString());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setBoolean(18, userViewParam.getSearchExact());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setString(19, userViewParam.getSelectedResources());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setBoolean(20, userViewParam.getShared());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.setLong(21, userViewParam.getId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset.execute();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateDCMPreset : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void deleteDCMPreset(long idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteDCMPreset(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.DCMPreset WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteDCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void dropDCMPresetTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: dropDCMPresetTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.DCMPreset");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropDCMPresetTable: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropDCMPresetTable : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void createHostTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createHostTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            this.loadDriver();
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Host( Id BIGINT generated by default as identity (START WITH 0, INCREMENT BY 1),Created BIGINT,Hostname VARCHAR(100),Port INT,Username VARCHAR(100),UserPassword VARCHAR(100),SuperuserPassword VARCHAR(100),Sysinfo VARCHAR(1000),Enabled BOOLEAN,ContactEmail VARCHAR(100),LastPolled BIGINT,Errors VARCHAR(4096),Command VARCHAR(4096),Comment2 VARCHAR(4096),Comment3 VARCHAR(4096) )");
        }
        catch (SQLException ex1) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.createHostTable(): " + ex1.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized int getHostCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Host");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getHostCount->statement.executeQuery(\"SELECT COUNT (*) FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient..getHostCount->resultset.next(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return numberOfRecords;
    }

    public synchronized Host selectHost(long idParam) throws CloneNotSupportedException {
        Statement statement = null;
        ResultSet resultset = null;
        Host host = new Host();
        boolean colcount = false;
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectCustomer(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Host WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHostCount->.statement.executeQuery(\"SELECT * FROM APP.Host WHERE Id = \"" + idParam + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                host.setId(resultset.getLong(1));
                cal.setTimeInMillis(resultset.getLong(2));
                host.setCreated(cal);
                host.setHostname(resultset.getString(3));
                host.setPort(resultset.getInt(4));
                host.setUsername(resultset.getString(5));
                host.setUserPassword(resultset.getString(6));
                host.setSuperuserPassword(resultset.getString(7));
                host.setSysinfo(resultset.getString(8));
                host.setEnabled(resultset.getBoolean(9));
                host.setContactEmail(resultset.getString(10));
                cal.setTimeInMillis(resultset.getLong(11));
                host.setLastPolled(cal);
                host.setErrors(resultset.getString(12));
                host.setCommand(resultset.getString(13));
                host.setComment2(resultset.getString(14));
                host.setComment3(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectHost->while (resultset.next()... " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectHost->connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return (Host)host.clone();
    }

    public synchronized ArrayList<Host> getHosts() throws CloneNotSupportedException {
        Statement statement = null;
        ResultSet resultset = null;
        Host host = new Host();
        ArrayList<Host> hostList = new ArrayList<Host>();
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Host ORDER BY Hostname");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                host.setId(resultset.getLong(1));
                cal.setTimeInMillis(resultset.getLong(2));
                host.setCreated(cal);
                host.setHostname(resultset.getString(3));
                host.setPort(resultset.getInt(4));
                host.setUsername(resultset.getString(5));
                host.setUserPassword(resultset.getString(6));
                host.setSuperuserPassword(resultset.getString(7));
                host.setSysinfo(resultset.getString(8));
                host.setEnabled(resultset.getBoolean(9));
                host.setContactEmail(resultset.getString(10));
                cal.setTimeInMillis(resultset.getLong(11));
                host.setLastPolled(cal);
                host.setErrors(resultset.getString(12));
                host.setCommand(resultset.getString(13));
                host.setComment2(resultset.getString(14));
                host.setComment3(resultset.getString(15));
                hostList.add((Host)host.clone());
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getHosts : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return hostList;
    }

    public synchronized ArrayList<Host> getHostsByHostname(String hostnameParam) throws CloneNotSupportedException {
        Statement statement = null;
        ResultSet resultset = null;
        Host host = new Host();
        ArrayList<Host> hostList = new ArrayList<Host>();
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Host WHERE Hostname = '" + hostnameParam + "'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                host.setId(resultset.getLong(1));
                cal.setTimeInMillis(resultset.getLong(2));
                host.setCreated(cal);
                host.setHostname(resultset.getString(3));
                host.setPort(resultset.getInt(4));
                host.setUsername(resultset.getString(5));
                host.setUserPassword(resultset.getString(6));
                host.setSuperuserPassword(resultset.getString(7));
                host.setSysinfo(resultset.getString(8));
                host.setEnabled(resultset.getBoolean(9));
                host.setContactEmail(resultset.getString(10));
                cal.setTimeInMillis(resultset.getLong(11));
                host.setLastPolled(cal);
                host.setErrors(resultset.getString(12));
                host.setCommand(resultset.getString(13));
                host.setComment2(resultset.getString(14));
                host.setComment3(resultset.getString(15));
                hostList.add((Host)host.clone());
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getHosts : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return hostList;
    }

    public synchronized Host getHostByHostname(String hostnameParam) throws CloneNotSupportedException {
        Statement statement = null;
        ResultSet resultset = null;
        Host host = new Host();
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Host WHERE Hostname = '" + hostnameParam + "'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                host.setId(resultset.getLong(1));
                cal.setTimeInMillis(resultset.getLong(2));
                host.setCreated(cal);
                host.setHostname(resultset.getString(3));
                host.setPort(resultset.getInt(4));
                host.setUsername(resultset.getString(5));
                host.setUserPassword(resultset.getString(6));
                host.setSuperuserPassword(resultset.getString(7));
                host.setSysinfo(resultset.getString(8));
                host.setEnabled(resultset.getBoolean(9));
                host.setContactEmail(resultset.getString(10));
                cal.setTimeInMillis(resultset.getLong(11));
                host.setLastPolled(cal);
                host.setErrors(resultset.getString(12));
                host.setCommand(resultset.getString(13));
                host.setComment2(resultset.getString(14));
                host.setComment3(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getHosts : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return host;
    }

    public synchronized void insertHost(Host hostParam) {
        this.dcmDBClientCaller.log("insertHost: " + hostParam.toString(), true, true, true);
        try {
            this.psInsertHost.setLong(1, hostParam.getCreated().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(2, hostParam.getHostname());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setInt(3, hostParam.getPort());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClientinsertHost.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(4, hostParam.getUsername());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClientinsertHost.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(5, hostParam.getUserPassword());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(6, hostParam.getSuperuserPassword());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(7, hostParam.getSysinfo());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setBoolean(8, hostParam.getEnabled());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(9, hostParam.getContactEmail());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setLong(10, hostParam.getLastPolled().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(11, hostParam.getErrors());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(12, hostParam.getCommand());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(13, hostParam.getComment2());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.setString(14, hostParam.getComment3());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertHost.execute();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.insertHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized ArrayList<RMIMessage> updateHost(Host hostParam) {
        ArrayList<RMIMessage> rmiMessageList = new ArrayList<RMIMessage>();
        try {
            this.psUpdateHost.setString(1, hostParam.getHostname());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(1, hostParam.getHostname());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setInt(2, hostParam.getPort());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setInt(2,    hostParam.getPort());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(3, hostParam.getUsername());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(3, hostParam.getUsername());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(4, hostParam.getUserPassword());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(4, hostParam.getUserPassword());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(5, hostParam.getSuperuserPassword());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(5, hostParam.getSuperuserPassword());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(6, hostParam.getSysinfo());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(6, hostParam.getSysinfo());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setBoolean(7, hostParam.getEnabled());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setBoolean(7,   hostParam.getEnabled());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(8, hostParam.getContactEmail());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(8, hostParam.getContactEmail());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setLong(9, hostParam.getLastPolled().getTimeInMillis());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setLong(9,   hostParam.getLastPolled().getTimeInMillis());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(10, hostParam.getErrors());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(10, hostParam.getErrors());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(11, hostParam.getCommand());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(11, hostParam.getComments1());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(12, hostParam.getComment2());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(12, hostParam.getComments2());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setString(13, hostParam.getComment3());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setString(13, hostParam.getComments3());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.setLong(14, hostParam.getId());
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.setInt(14, hostParam.getId());", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost.executeUpdate();
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.psUpdateHost.executeUpdate();", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            rmiMessageList.add(new RMIMessage("Error", "DCMDBClient.connection.commit();", "", false));
            this.dcmDBClientCaller.log("Error: DCMDBClient.updateHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        this.dcmDBClientCaller.updatedHost();
        return rmiMessageList;
    }

    public synchronized void enableHost(Host hostParam, boolean enableParam) throws CloneNotSupportedException {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectCustomer(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("UPDATE APP.Host SET Enabled = " + enableParam + " WHERE Id = " + hostParam.getId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHostCount->.statement.executeQuery(\"SELECT * FROM APP.Host WHERE Id = \"" + hostParam.getId() + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: enableHost->connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void deleteHosts() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHosts(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Host");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("ALTER TABLE APP.Host ALTER COLUMN Id RESTART WITH 0");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void deleteHost(long idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteCustomer(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Host WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: deleteHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void dropHostTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: dropCustomerTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Host");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropHostTable: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropHostTable : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void createResourceTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: createResourceTable connection.createStatement(): " + ex.getMessage(), true, true, true);
            this.loadDriver();
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Resource( Id BIGINT generated by default as identity (START WITH 0, INCREMENT BY 1),HostId BIGINT,Category VARCHAR(20),ResourceType VARCHAR(40),ValueType VARCHAR(20),CounterType VARCHAR(20),Resource VARCHAR(100),Enabled BOOLEAN,PollCommand VARCHAR(4069),LastValue Double,WarningLimit Double,CriticalLimit Double,AlertPolls INT,Updated BIGINT,RRDFile VARCHAR(250),RetentionTime INT )");
        }
        catch (SQLException ex1) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: createResourceTable: " + ex1.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: createResourceTable : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized int getResourceCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getResourceCount: connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.RESOURCE");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getResourceCount: " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getResourceCount: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getResourceCount: connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return numberOfRecords;
    }

    public synchronized Resource selectResource(long idParam) {
        Statement statement = null;
        ResultSet resultset = null;
        Resource resource = new Resource();
        boolean colcount = false;
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Resource WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                resource.setId(resultset.getLong(1));
                resource.setHostId(resultset.getLong(2));
                resource.setCategory(resultset.getString(3));
                resource.setResourceType(resultset.getString(4));
                resource.setValueType(resultset.getString(5));
                resource.setCounterType(resultset.getString(6));
                resource.setResource(resultset.getString(7));
                resource.setEnabled(resultset.getBoolean(8));
                resource.setPollCommand(resultset.getString(9));
                resource.setLastValue(resultset.getDouble(10));
                resource.setWarningLimit(resultset.getDouble(11));
                resource.setCriticalLimit(resultset.getDouble(12));
                resource.setAlertPolls(resultset.getInt(13));
                cal.setTimeInMillis(resultset.getLong(14));
                resource.setUpdated(cal);
                resource.setArchiveDBFile(resultset.getString(15));
                resource.setRetentionTime(resultset.getInt(16));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource()->while (resultset.next() " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return resource;
    }

    public synchronized ArrayList<String> selectDistinctResources(long idParam, String categoryParam) {
        Statement statement = null;
        ResultSet resultset = null;
        ArrayList<String> resourceList = new ArrayList<String>();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT DISTINCT Resource FROM APP.Resource WHERE HostId = " + idParam + " AND Category = '" + categoryParam + "'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources(): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                resourceList.add(resultset.getString(1));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources()->while (resultset.next() " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources(): connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return resourceList;
    }

    public synchronized ArrayList<String> selectDistinctResourceTypes(long idParam, String categoryParam) {
        Statement statement = null;
        ResultSet resultset = null;
        ArrayList<String> resourceTypeList = new ArrayList<String>();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT DISTINCT ResourceType FROM APP.Resource WHERE HostId = " + idParam + " AND Category = '" + categoryParam + "'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources(): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                resourceTypeList.add(resultset.getString(1));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources()->while (resultset.next() " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectDistinctResources(): connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return resourceTypeList;
    }

    public synchronized String convertSearchStringToResourcesText(String searchPhraseParam, ArrayList<Server> serverList, boolean exactParam) {
        String wildcard = "";
        String output = "";
        String unfilteredOutput = "";
        wildcard = exactParam ? "" : "%";
        for (String searchParam : searchPhraseParam.split("\\s*\\|\\s*")) {
            String operator = "WHERE";
            String sqlString = "SELECT App.Resource.Id, APP.Host.Hostname, App.Resource.Category, App.Resource.ResourceType, App.Resource.ValueType, App.Resource.Resource ";
            sqlString = sqlString + "FROM APP.Resource LEFT OUTER JOIN APP.Host ON App.Resource.HostId = APP.Host.Id ";
            for (String keyword : searchParam.split("\\s+")) {
                sqlString = sqlString + operator + " (UPPER(APP.Host.Hostname) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR ";
                sqlString = sqlString + " UPPER(APP.Host.Sysinfo) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR ";
                sqlString = sqlString + " UPPER(App.Resource.CATEGORY) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR ";
                sqlString = sqlString + " UPPER(App.Resource.RESOURCETYPE) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR ";
                sqlString = sqlString + " UPPER(App.Resource.COUNTERTYPE) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR ";
                sqlString = sqlString + " UPPER(App.Resource.VALUETYPE) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR ";
                sqlString = sqlString + " UPPER(App.Resource.RESOURCE) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "'))";
                operator = "AND";
            }
            sqlString = sqlString + " ORDER BY APP.Host.Hostname, APP.Resource.Id";
            if (this.debug) {
                this.dcmDBClientCaller.log(sqlString, false, true, true);
            }
            Statement statement = null;
            ResultSet resultset = null;
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                resultset = statement.executeQuery(sqlString);
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): " + ex.getMessage(), true, true, true);
            }
            try {
                while (resultset.next()) {
                    String col1 = Long.toString(resultset.getLong(1)) + " ";
                    unfilteredOutput = unfilteredOutput + col1 + " ";
                    String col2 = resultset.getString(2);
                    unfilteredOutput = unfilteredOutput + col2 + " ";
                    String col3 = resultset.getString(3);
                    unfilteredOutput = unfilteredOutput + col3 + " ";
                    String col4 = resultset.getString(4);
                    unfilteredOutput = unfilteredOutput + col4 + " ";
                    col4 = resultset.getString(5);
                    unfilteredOutput = unfilteredOutput + col4 + " ";
                    String col5 = resultset.getString(6);
                    unfilteredOutput = unfilteredOutput + col5 + "\r\n";
                }
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource()->while (resultset.next() " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): connection.commit(): " + ex.getMessage(), true, true, true);
            }
        }
        for (Server server : serverList) {
            output = output + DCMTools.contains(unfilteredOutput, " " + server.getHost().getHostname() + " ");
        }
        return output;
    }

    public synchronized String convertSearchStringToHostsText(String searchPhraseParam, ArrayList<Server> serverList, boolean exactParam) {
        String wildcard = "";
        String output = "";
        String unfilteredOutput = "";
        wildcard = exactParam ? "" : "%";
        for (String searchParam : searchPhraseParam.split("\\s*\\|\\s*")) {
            String operator = "WHERE";
            String sqlString = "SELECT DISTINCT APP.Host.Id, APP.Host.Hostname, APP.Host.Sysinfo FROM APP.Host RIGHT OUTER JOIN APP.Resource ON APP.Host.Id = App.Resource.HostId ";
            for (String keyword : searchParam.split("\\s+")) {
                sqlString = sqlString + operator + " (UPPER(APP.Host.Hostname) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR UPPER(APP.Host.Sysinfo) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR UPPER(App.Resource.CATEGORY) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR UPPER(App.Resource.RESOURCETYPE) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "') OR UPPER(App.Resource.RESOURCE) like UPPER('" + wildcard + "" + keyword + "" + wildcard + "'))";
                operator = "AND";
            }
            sqlString = sqlString + " ORDER BY APP.Host.Id";
            Statement statement = null;
            ResultSet resultset = null;
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                resultset = statement.executeQuery(sqlString);
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): " + ex.getMessage(), true, true, true);
            }
            try {
                while (resultset.next()) {
                    String col1 = Long.toString(resultset.getLong(1));
                    unfilteredOutput = unfilteredOutput + col1 + " ";
                    String col2 = resultset.getString(2);
                    unfilteredOutput = unfilteredOutput + col2 + " ";
                    String col3 = resultset.getString(3);
                    unfilteredOutput = unfilteredOutput + col3;
                }
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource()->while (resultset.next() " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: selectResource(): connection.commit(): " + ex.getMessage(), true, true, true);
            }
        }
        for (Server server : serverList) {
            output = output + DCMTools.contains(unfilteredOutput, " " + server.getHost().getHostname() + " ");
        }
        return output;
    }

    public synchronized ArrayList<Resource> convertResourcesTextToResources(ArrayList<String> resourceIdList) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String resourceId : resourceIdList) {
            boolean resourceIdIsValidNumber = true;
            try {
                Long.parseLong(resourceId);
            }
            catch (Exception e) {
                resourceIdIsValidNumber = false;
            }
            if (!resourceIdIsValidNumber) continue;
            resourceList.add(this.selectResource(Long.parseLong(resourceId)));
        }
        return resourceList;
    }

    public synchronized ArrayList<Host> convertHostsTextToHostsList(ArrayList<String> hostTXTList) {
        ArrayList<Host> hostList = new ArrayList<Host>();
        for (String hostId : hostTXTList) {
            boolean hostIdIsValidNumber = true;
            try {
                Long.parseLong(hostId);
            }
            catch (Exception e) {
                hostIdIsValidNumber = false;
            }
            if (!hostIdIsValidNumber) continue;
            try {
                hostList.add(this.selectHost(Long.parseLong(hostId)));
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return hostList;
    }

    public synchronized void insertResource(Resource resourceParam) {
        Calendar cal = Calendar.getInstance();
        try {
            this.psInsertResource.setLong(1, resourceParam.getHostId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setString(2, resourceParam.getCategory());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setString(3, resourceParam.getResourceType());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setString(4, resourceParam.getValueType());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setString(5, resourceParam.getCounterType());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setString(6, resourceParam.getResource());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setBoolean(7, resourceParam.getEnabled());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setString(8, resourceParam.getPollCommand());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setDouble(9, resourceParam.getLastValue());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setDouble(10, resourceParam.getWarningLimit());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setDouble(11, resourceParam.getCriticalLimit());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setInt(12, resourceParam.getAlertPolls());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setLong(13, cal.getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setString(14, resourceParam.getRRDFile());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.setInt(15, resourceParam.getRetentionTime());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource.execute();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertResource: " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void updateResource(Resource resourceParam) {
        try {
            this.psUpdateResource.setLong(1, resourceParam.getHostId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setString(2, resourceParam.getCategory());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setString(3, resourceParam.getResourceType());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setString(4, resourceParam.getValueType());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setString(5, resourceParam.getCounterType());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setString(6, resourceParam.getResource());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setBoolean(7, resourceParam.getEnabled());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setString(8, resourceParam.getPollCommand());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setDouble(9, resourceParam.getLastValue());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setDouble(10, resourceParam.getWarningLimit());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setDouble(11, resourceParam.getCriticalLimit());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setInt(12, resourceParam.getAlertPolls());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setLong(13, resourceParam.getUpdated().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setString(14, resourceParam.getRRDFile());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setInt(15, resourceParam.getRetentionTime());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.setLong(16, resourceParam.getId());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource.executeUpdate();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void updateServerResourcesValues(Server serverParam) {
        Calendar cal = Calendar.getInstance();
        for (Resource resource : serverParam.getResourceList()) {
            cal = resource.getUpdated();
            try {
                this.psUpdateResourceValue.setDouble(1, resource.getLastValue());
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateServerResourcesValues: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psUpdateResourceValue.setLong(2, cal.getTimeInMillis());
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateServerResourcesValues: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psUpdateResourceValue.setLong(3, resource.getId());
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateServerResourcesValues: " + ex.getMessage(), true, true, true);
            }
            try {
                this.psUpdateResourceValue.executeUpdate();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateServerResourcesValues: ResourceId: " + resource.getId() + " ResourceValue: " + resource.getLastValue() + " " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: updateResource connection.commit(): " + ex.getMessage(), true, true, true);
            }
        }
    }

    public synchronized void deleteResources() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Resource");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.commit(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("ALTER TABLE APP.Resource ALTER COLUMN Id RESTART WITH 0");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void deleteResource(long idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Resource WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteResource(): connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized void dropResourceTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropResourceTable()->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Resource");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropResourceTable(): connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: dropResourceTable: connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    public synchronized Server getServer(long idParam) throws CloneNotSupportedException {
        Server server = new Server();
        Host host = new Host();
        Resource resource = new Resource();
        Statement statement = null;
        ResultSet resultset = null;
        boolean colcount = false;
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Host WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer(): " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                host.setId(resultset.getLong(1));
                cal.setTimeInMillis(resultset.getLong(2));
                host.setCreated(cal);
                host.setHostname(resultset.getString(3));
                host.setPort(resultset.getInt(4));
                host.setUsername(resultset.getString(5));
                host.setUserPassword(resultset.getString(6));
                host.setSuperuserPassword(resultset.getString(7));
                host.setSysinfo(resultset.getString(8));
                host.setEnabled(resultset.getBoolean(9));
                host.setContactEmail(resultset.getString(10));
                cal.setTimeInMillis(resultset.getLong(11));
                host.setLastPolled(cal);
                host.setErrors(resultset.getString(12));
                host.setCommand(resultset.getString(13));
                host.setComment2(resultset.getString(14));
                host.setComment3(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer():  connection.commit(): " + ex.getMessage(), true, true, true);
        }
        server.setHost(host);
        colcount = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer():  connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Resource WHERE HostId = " + idParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer(): " + ex.getMessage(), true, true, true);
        }
        try {
            while (resultset.next()) {
                resource.setId(resultset.getLong(1));
                resource.setHostId(resultset.getLong(2));
                resource.setCategory(resultset.getString(3));
                resource.setResourceType(resultset.getString(4));
                resource.setValueType(resultset.getString(5));
                resource.setCounterType(resultset.getString(6));
                resource.setResource(resultset.getString(7));
                resource.setEnabled(resultset.getBoolean(8));
                resource.setPollCommand(resultset.getString(9));
                resource.setLastValue(resultset.getDouble(10));
                resource.setWarningLimit(resultset.getDouble(11));
                resource.setCriticalLimit(resultset.getDouble(12));
                resource.setAlertPolls(resultset.getInt(13));
                cal.setTimeInMillis(resultset.getLong(14));
                resource.setUpdated(cal);
                resource.setArchiveDBFile(resultset.getString(15));
                resource.setRetentionTime(resultset.getInt(16));
                server.addResource((Resource)resource.clone());
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer(): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getServer(): connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return server;
    }

    public synchronized ArrayList<Server> selectServers() throws CloneNotSupportedException {
        ArrayList<Server> serverList = new ArrayList<Server>();
        for (Host host : this.getHosts()) {
            serverList.add(this.getServer(host.getId()));
        }
        return serverList;
    }

    public synchronized ArrayList<Server> selectServersByIdList(ArrayList<Long> idListParam) throws CloneNotSupportedException {
        ArrayList<Server> serverList = new ArrayList<Server>();
        for (Host host : this.getHosts()) {
            serverList.add(this.getServer(host.getId()));
        }
        return serverList;
    }

    public synchronized Server getServerByHostname(String hostnameParam) throws CloneNotSupportedException {
        Statement statement = null;
        ResultSet resultset = null;
        Server server = new Server();
        Host host = new Host();
        Calendar cal = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Host WHERE Hostname = '" + hostnameParam + "'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->statement.executeQuery(\"SELECT * FROM APP.Host\"): " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                host.setId(resultset.getLong(1));
                cal.setTimeInMillis(resultset.getLong(2));
                host.setCreated(cal);
                host.setHostname(resultset.getString(3));
                host.setPort(resultset.getInt(4));
                host.setUsername(resultset.getString(5));
                host.setUserPassword(resultset.getString(6));
                host.setSuperuserPassword(resultset.getString(7));
                host.setSysinfo(resultset.getString(8));
                host.setEnabled(resultset.getBoolean(9));
                host.setContactEmail(resultset.getString(10));
                cal.setTimeInMillis(resultset.getLong(11));
                host.setLastPolled(cal);
                host.setErrors(resultset.getString(12));
                host.setCommand(resultset.getString(13));
                host.setComment2(resultset.getString(14));
                host.setComment3(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: getHosts->while (resultset.next()...: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.getHosts : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        server = this.getServer(host.getId());
        return server;
    }

    public synchronized boolean deleteServerByHostname(String hostnameParam) throws CloneNotSupportedException {
        boolean recordsDeleted = false;
        ArrayList<Object> hostList = new ArrayList();
        hostList = this.getHostsByHostname(hostnameParam);
        Statement statement = null;
        Object resultset = null;
        for (Host host : hostList) {
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteServerByHostname(): connection.createStatement(): " + ex.getMessage(), true, true, true);
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                statement.executeUpdate("DELETE FROM APP.Host WHERE Id = " + host.getId());
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteServerByHostname(): DELETE FROM APP.Host WHERE Id = " + host.getId() + ": " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteServerByHostname(): connection.commit(): " + ex.getMessage(), true, true, true);
            }
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteServerByHostname(): connection.createStatement(): " + ex.getMessage(), true, true, true);
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                statement.executeUpdate("DELETE FROM APP.Resource WHERE HostId = " + host.getId());
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteServerByHostname(): DELETE FROM APP.Resource WHERE HostId = " + host.getId() + ": " + ex.getMessage(), true, true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException DCMDBClient.deleteServerByHostname(): connection.commit(): " + ex.getMessage(), true, true, true);
            }
        }
        recordsDeleted = true;
        return recordsDeleted;
    }

    public synchronized long selectLastHostId() {
        Statement statement = null;
        ResultSet resultset = null;
        long hostId = 0L;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Host ORDER BY Id DESC");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.: " + ex.getMessage(), true, true, true);
        }
        try {
            if (resultset.next()) {
                hostId = resultset.getLong(1);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        return hostId;
    }

    public synchronized void insertServer(Server serverParam) {
        try {
            this.psInsertServer.setLong(1, serverParam.getHost().getCreated().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(2, serverParam.getHost().getHostname());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setInt(3, serverParam.getHost().getPort());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(4, serverParam.getHost().getUsername());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer.: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(5, serverParam.getHost().getUserPassword());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(6, serverParam.getHost().getSuperuserPassword());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(7, serverParam.getHost().getSysinfo());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setBoolean(8, serverParam.getHost().getEnabled());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(9, serverParam.getHost().getContactEmail());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setLong(10, serverParam.getHost().getLastPolled().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(11, serverParam.getHost().getErrors());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(12, serverParam.getHost().getCommand());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(13, serverParam.getHost().getComment2());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.setString(14, serverParam.getHost().getComment3());
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer.execute();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertServer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: insertHost : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        long hostId = this.selectLastHostId();
        for (Resource resourse : serverParam.getResourceList()) {
            resourse.setHostId(hostId);
            this.insertResource(resourse);
        }
    }

    public void executeSQL(String sqlStatementParam) {
        Statement statement = null;
        Object resultset = null;
        String[] status = new String[]{"0", "0"};
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: executeSQL(): connection.createStatement(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement.executeUpdate(sqlStatementParam);
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: executeSQL(): statement.executeUpdate(sqlStatementParam): " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
    }

    private void checkTables() {
        Statement statement = null;
        ResultSet resultset = null;
        boolean tablesMissing = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: checkTables(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'DCMTIJD'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): SQLException: " + ex.getMessage(), true, true, true);
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("DCMTIJD")) {
                tablesMissing = true;
                this.createDCMTijdTable();
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): Failure " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: checkTables(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'DCMUSER'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): SQLException: " + ex.getMessage(), true, true, true);
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("DCMUSER")) {
                tablesMissing = true;
                this.createDCMUserTable();
                this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Creating table: DCMUSER", true, true, true);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): checkDCMUserTable: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: checkTables(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'DCMPRESET'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): SQLException: " + ex.getMessage(), true, true, true);
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("DCMPRESET")) {
                tablesMissing = true;
                this.createDCMPresetTable();
                this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Creating table: DCMPRESET", true, true, true);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): checkDCMPresetTable: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: checkTables(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'HOST'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): SQLException: " + ex.getMessage(), true, true, true);
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("HOST")) {
                tablesMissing = true;
                this.createHostTable();
                this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Creating table: HOST", true, true, true);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): checkHostTable: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: checkTables(): connection.createStatement(): " + ex.getMessage(), true, true, true);
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'RESOURCE'");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): SQLException: " + ex.getMessage(), true, true, true);
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("RESOURCE")) {
                tablesMissing = true;
                this.createResourceTable();
                this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Creating table: RESOURCE", true, true, true);
            }
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: createTables(): checkResourceTable: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error: DCMDBClient. : connection.commit(): " + ex.getMessage(), true, true, true);
        }
        if (tablesMissing) {
            this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Created " + this.database + " Database", true, true, true);
        }
    }

    private synchronized void reportFailure(String message) {
        this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client Data Verification Failed: " + message, true, true, true);
    }

    public synchronized void printSQLException(SQLException error) {
        while (error != null) {
            this.dcmDBClientCaller.log("SQLException: ", true, true, true);
            this.dcmDBClientCaller.log(" SQL State: " + error.getSQLState(), true, true, true);
            this.dcmDBClientCaller.log(" Error Code: " + error.getErrorCode(), true, true, true);
            this.dcmDBClientCaller.log(" Message: " + error.getMessage(), true, true, true);
            error = error.getNextException();
        }
    }

    public void shutdownDB() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                this.dcmDBClientCaller.log("Success: DCMDBClient: JavaDB Database Client Driver Shutdown Successfull", true, true, true);
            }
            this.dcmDBClientCaller.log("Error:  DCMDBClient: JavaDB Database Client Driver Shutdown Unsuccessfull", true, true, true);
            this.printSQLException(se);
        }
    }

    public void unloadDriver() {
        Object statement = null;
        ResultSet resultset = null;
        try {
            if (resultset != null) {
                resultset.close();
                resultset = null;
            }
        }
        catch (SQLException sqle) {
            this.printSQLException(sqle);
        }
        int i = 0;
        while (!this.statements.isEmpty()) {
            Statement st = (Statement)this.statements.remove(i);
            try {
                if (st == null) continue;
                st.close();
                st = null;
            }
            catch (SQLException sqle) {
                this.printSQLException(sqle);
            }
        }
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sqle) {
            this.printSQLException(sqle);
        }
    }

    private void initPrepareStatements() {
        try {
            this.psInsertHost = this.connection.prepareStatement("INSERT INTO APP.Host VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->INSERT Host: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateHost = this.connection.prepareStatement("UPDATE APP.Host SET Hostname = ?, Port = ?, Username = ?, UserPassword = ?, SuperuserPassword = ?, Sysinfo = ?, Enabled = ?, ContactEmail = ?, LastPolled = ?, Errors = ?, Command = ?, Comment2 = ?, Comment3 = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->UPDATE Host: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMTijd = this.connection.prepareStatement("INSERT INTO APP.DCMTijd VALUES (?, ?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->INSERT Failed: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMTijd = this.connection.prepareStatement("UPDATE APP.DCMTijd SET Tijd = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->UPDATE Failed: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMUser = this.connection.prepareStatement("INSERT INTO APP.DCMUser VALUES (DEFAULT, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->INSERT DCMUSer: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMUser = this.connection.prepareStatement("UPDATE APP.DCMUser SET Username = ?, Password = ?, Administrator = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->UPDATE DCMUser: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertDCMPreset = this.connection.prepareStatement("INSERT INTO APP.DCMPreset VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->INSERT DCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateDCMPreset = this.connection.prepareStatement("UPDATE APP.DCMPreset SET UserId = ?, ViewName = ?, ViewDescription = ?, StartCalendarRelative = ?, StartCalendar = ?, StartMonthSupplement = ?, StartDaySupplement = ?, StartHourSupplement = ?, StartMinuteSupplement = ?, EndCalendarRelative = ?, EndCalendar = ?, EndMonthSupplement = ?, EndDaySupplement = ?, EndHourSupplement = ?, EndMinuteSupplement = ?, EnableSearch = ?, SearchString = ?, SearchExact = ?, SelectedResources = ?, Shared = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->UPDATE DCMPreset: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertServer = this.connection.prepareStatement("INSERT INTO APP.Host VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->INSERT Host: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateServer = this.connection.prepareStatement("UPDATE APP.Host SET Hostname = ?, Port = ?, Username = ?, UserPassword = ?, SuperuserPassword = ?, Sysinfo = ?, Enabled = ?, ContactEmail = ?, LastPolled = ?, Errors = ?, Command = ?, Comment2 = ?, Comment3 = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->UPDATE Host: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psInsertResource = this.connection.prepareStatement("INSERT INTO APP.Resource VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->INSERT Resource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResource = this.connection.prepareStatement("UPDATE APP.Resource SET HostId = ?, Category = ?, ResourceType = ?, ValueType = ?, CounterType = ?, Resource = ?, Enabled = ?, PollCommand = ?, LastValue = ?, WarningLimit = ?, CriticalLimit = ?, AlertPolls = ?, Updated = ?, RRDFile = ?, RetentionTime = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->UPDATE Resource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psUpdateResourceValue = this.connection.prepareStatement("UPDATE APP.Resource SET LastValue = ?, Updated = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->UPDATE Resource: " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMUserTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportDCMPresetTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportHostTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
        try {
            this.psExportResourceTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
        try {
            this.psImportDCMUserTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (?,?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_Import_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
        try {
            this.psImportDCMPresetTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (?,?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_Import_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
        try {
            this.psImportHostTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (?,?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_Import_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
        try {
            this.psImportResourceTable = this.connection.prepareStatement("CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (?,?,?,?,?,?,?)");
        }
        catch (SQLException ex) {
            this.dcmDBClientCaller.log("Error:  DCMDBClient: SQLException: initPrepareStatements->CALL SYSCS_UTIL.SYSCS_Import_TABLE (?,?,?,?,?,?): " + ex.getMessage(), true, true, true);
        }
    }

    private static boolean isDBServerInitiated() {
        return dbServerInit;
    }

    private static void setDBServerInitiated() {
        dbServerInit = true;
    }

    public boolean getDBServerTest() {
        return this.dbServerTest;
    }

    @Override
    public void log(String messageParam, boolean logToStatus, boolean logApplication, boolean logToFile) {
        this.dcmDBClientCaller.log(messageParam, logToStatus, logApplication, logToFile);
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

